/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class ZipUtil {
    public static void unzip(String fromFile, String toDir) throws IOException {
        ZipUtil.unzip(new File(fromFile), new File(toDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File fromZipFile, File toDir) throws IOException {
        ZipFile zipFile;
        block5: {
            if (!toDir.exists()) {
                toDir.mkdirs();
            }
            zipFile = new ZipFile(fromZipFile);
            ZipInputStream zipInput = null;
            try {
                ZipEntry entry;
                zipInput = new ZipInputStream(new FileInputStream(fromZipFile));
                while ((entry = zipInput.getNextEntry()) != null) {
                    ZipUtil.extractFile(zipFile, entry, toDir);
                    zipInput.closeEntry();
                }
                if (zipInput == null) break block5;
            }
            catch (Throwable throwable) {
                if (zipInput != null) {
                    IOUtils.closeQuietly(zipInput);
                }
                zipFile.close();
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)zipInput);
        }
        zipFile.close();
    }

    private static void extractFile(ZipFile zipFile, ZipEntry zipEntry, File toDir) throws IOException {
        File toFile = new File(toDir.getAbsolutePath(), zipEntry.getName());
        if (zipEntry.isDirectory()) {
            FileUtils.forceMkdir((File)toFile);
        } else if (!toFile.exists()) {
            toFile.getParentFile().mkdirs();
            FileOutputStream out = FileUtils.openOutputStream((File)toFile);
            IOUtils.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)out);
            ((OutputStream)out).close();
        }
    }
}

