/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.silverpeas.util.jndi.SimpleMemoryContext;

public class SimpleMemoryContextFactory
implements InitialContextFactory {
    private static Map<String, String> savedSystemProperties = new HashMap<String, String>();
    private static SimpleMemoryContext context = new SimpleMemoryContext();

    public static void setUpAsInitialContext() {
        context.clear();
        savedSystemProperties.put("java.naming.factory.initial", System.getProperty("java.naming.factory.initial"));
        savedSystemProperties.put("java.naming.factory.url.pkgs", System.getProperty("java.naming.factory.url.pkgs"));
        System.setProperty("java.naming.factory.initial", SimpleMemoryContextFactory.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", SimpleMemoryContextFactory.class.getPackage().getName());
    }

    public static void tearDownAsInitialContext() {
        String property = savedSystemProperties.get("java.naming.factory.initial");
        if (property == null || property.trim().isEmpty()) {
            System.clearProperty("java.naming.factory.initial");
        } else {
            System.setProperty("java.naming.factory.initial", property);
        }
        property = savedSystemProperties.get("java.naming.factory.url.pkgs");
        if (property != null) {
            System.setProperty("java.naming.factory.url.pkgs", property);
        } else {
            System.clearProperty("java.naming.factory.url.pkgs");
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return context;
    }
}

