/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClasspathEntityResolver
implements EntityResolver {
    private EntityResolver defaultResolver;

    public ClasspathEntityResolver(EntityResolver defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (null != this.defaultResolver) {
            try {
                return this.defaultResolver.resolveEntity(publicId, systemId);
            }
            catch (IOException ioex) {
                return this.resolveInClasspath(publicId, systemId);
            }
        }
        return this.resolveInClasspath(publicId, systemId);
    }

    private InputSource resolveInClasspath(String publicId, String systemId) throws SAXException, IOException {
        InputSource result = this.resolveInClasspath(publicId);
        if (null == result) {
            result = this.resolveInClasspath(systemId);
        }
        if (null == result) {
            result = new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes("UTF-8")));
        }
        return result;
    }

    private InputSource resolveInClasspath(String id) throws SAXException, IOException {
        if (null != id && !id.isEmpty()) {
            String schemaName = id.substring(id.lastIndexOf(47));
            InputStream resource = this.getClass().getClassLoader().getResourceAsStream("/META-INF" + schemaName);
            if (null != resource) {
                return new InputSource(resource);
            }
        }
        return null;
    }
}

