/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.xml.xpath;

import org.jdom.Element;
import org.silverpeas.util.xml.XmlTreeHandler;
import org.silverpeas.util.xml.xpath.XPathParseException;
import org.silverpeas.util.xml.xpath.XPathTokenizer;

public class XPath {
    private XPathTokenizer _tokenizer = null;
    private XmlTreeHandler _xmlTreeHandler = null;
    private boolean _doPerformActions;
    private Boolean _isAttribute = null;
    private Boolean _isElement = null;
    private Boolean _exists = null;
    private Boolean _isAbsolute;

    public XPath() {
    }

    public XPath(String xpath) {
        this(null, xpath, 'S');
    }

    public XPath(Element startingElement, String xpath) {
        this(startingElement, xpath, 'S');
    }

    public XPath(Element startingElement, String xpath, char mode) {
        this.setMode(mode);
        this.setStartingElement(startingElement);
        this.setXPath(xpath);
    }

    public void setStartingElement(Element e) {
        this.getTreeHandler().setStartingElement(e);
        this.getTokenizer().reinitRead();
        this.eraseAll();
    }

    public Element getStartingElement() {
        return this.getTreeHandler().getStartingElement();
    }

    public void setXPath(String xpath) {
        this.getTokenizer().setXPath(xpath);
        this.getTreeHandler().returnToStartingElement();
        this.eraseAll();
    }

    public String getXPath() {
        return this.getTokenizer().getXPath();
    }

    public void setMode(char mode) {
        this.getTreeHandler().setMode(mode);
        this.getTreeHandler().returnToStartingElement();
        this.getTokenizer().reinitRead();
        this.eraseAll();
    }

    public char getMode() {
        return this.getTreeHandler().getMode();
    }

    private XPathTokenizer getTokenizer() {
        if (this._tokenizer == null) {
            this._tokenizer = new XPathTokenizer();
        }
        return this._tokenizer;
    }

    private XmlTreeHandler getTreeHandler() {
        if (this._xmlTreeHandler == null) {
            this._xmlTreeHandler = new XmlTreeHandler();
        }
        return this._xmlTreeHandler;
    }

    private void setXMLActionsToBePerformed(boolean doPerform) {
        this._doPerformActions = doPerform;
    }

    private boolean areXMLActionsPerformed() {
        return this._doPerformActions;
    }

    public void parse() throws XPathParseException {
        this.getTokenizer().reinitRead();
        this.setXMLActionsToBePerformed(false);
        this.analyse();
        if (this.getTreeHandler().getStartingElement() != null) {
            this.getTokenizer().reinitRead();
            this.getTreeHandler().returnToStartingElement();
            this.setXMLActionsToBePerformed(true);
            this.analyse();
        }
    }

    private void analyse() throws XPathParseException {
        this.getTokenizer().readNextToken();
        this.locationPath();
        if (this.getTokenizer().getCurrentTokenType() != 'E') {
            throw new XPathParseException("end of XPath expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
        }
        if (this.areXMLActionsPerformed()) {
            this.setExists(this.getTreeHandler().currentNodeExists());
        }
    }

    private void locationPath() throws XPathParseException {
        if (this.getTokenizer().getCurrentTokenType() == '/') {
            if (this.areXMLActionsPerformed() && this.getTreeHandler().currentNodeExists()) {
                this.getTreeHandler().gotoRoot();
            }
            this.setIsAbsolute(true);
            if (this.getTokenizer().readNextToken() != 'E') {
                this.relativeLocationPath();
            }
        } else {
            if (this.areXMLActionsPerformed() && this.getTreeHandler().currentNodeExists()) {
                this.getTreeHandler().setCurrentElementAsCousinsAncestor();
            }
            this.setIsAbsolute(false);
            this.relativeLocationPath();
        }
    }

    private void relativeLocationPath() throws XPathParseException {
        this.step();
        if (this.getTokenizer().getCurrentTokenType() == '/') {
            this.getTokenizer().readNextToken();
            this.relativeLocationPath();
        }
    }

    private void step() throws XPathParseException {
        switch (this.getTokenizer().getCurrentTokenType()) {
            case '.': {
                this.getTokenizer().readNextToken();
                break;
            }
            case 'P': {
                if (this.areXMLActionsPerformed() && this.getTreeHandler().currentNodeExists()) {
                    this.getTreeHandler().gotoParent();
                    this.getTreeHandler().setNameFromCurrentElement();
                }
                this.getTokenizer().readNextToken();
                break;
            }
            case '@': {
                if (this.getTokenizer().readNextToken() != 'N') {
                    throw new XPathParseException("XML Name expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
                }
                this.setIsAttribute(true);
                this.setIsElement(false);
                if (this.areXMLActionsPerformed() && this.getTreeHandler().currentNodeExists()) {
                    this.getTreeHandler().gotoFirstNephewNode('A', this.getTokenizer().getCurrentToken());
                }
                this.getTokenizer().readNextToken();
                break;
            }
            case 'N': {
                this.setIsElement(true);
                this.setIsAttribute(false);
                String elementName = this.getTokenizer().getCurrentToken();
                if (this.getTokenizer().readNextToken() == '[') {
                    this.predicate(elementName);
                    break;
                }
                if (!this.areXMLActionsPerformed() || !this.getTreeHandler().currentNodeExists()) break;
                this.getTreeHandler().gotoFirstNephewNode('E', elementName);
                break;
            }
            default: {
                throw new XPathParseException("'.', '..', '@' or XML Name expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
            }
        }
    }

    private void predicate(String elementName) throws XPathParseException {
        if (this.getTokenizer().getCurrentTokenType() != '[') {
            throw new XPathParseException("'[' expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
        }
        this.getTokenizer().readNextToken();
        this.predicateExpr(elementName);
        if (this.areXMLActionsPerformed() && this.getTreeHandler().currentNodeExists()) {
            this.getTreeHandler().setCurrentElementAsCousinsAncestor();
        }
        if (this.getTokenizer().getCurrentTokenType() != ']') {
            throw new XPathParseException("']' expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
        }
        this.getTokenizer().readNextToken();
    }

    private void predicateExpr(String elementName) throws XPathParseException {
        char nodeType = 'X';
        String nodeName = null;
        switch (this.getTokenizer().getCurrentTokenType()) {
            case '@': {
                nodeType = 'A';
                if (this.getTokenizer().readNextToken() != 'N') {
                    throw new XPathParseException("XML Name expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
                }
                nodeName = this.getTokenizer().getCurrentToken();
                break;
            }
            case 'N': {
                nodeType = 'E';
                nodeName = this.getTokenizer().getCurrentToken();
                break;
            }
            default: {
                throw new XPathParseException("'@' or XML Name expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
            }
        }
        if (this.getTokenizer().readNextToken() != '=') {
            throw new XPathParseException("'=' expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
        }
        this.getTokenizer().readNextToken();
        String value2find = this.primaryExpr();
        if (this.areXMLActionsPerformed() && this.getTreeHandler().currentNodeExists()) {
            this.getTreeHandler().gotoFirstNephewParentOf(elementName, nodeType, nodeName, value2find);
        }
    }

    private String primaryExpr() throws XPathParseException {
        String value = null;
        switch (this.getTokenizer().getCurrentTokenType()) {
            case 'I': 
            case 'L': 
            case 'R': {
                value = this.getTokenizer().getCurrentToken();
                break;
            }
            default: {
                throw new XPathParseException("Number or Literal expected", this.getXPath(), this.getTokenizer().getCurrentTokenPosition());
            }
        }
        this.getTokenizer().readNextToken();
        return value;
    }

    public Boolean isAttribute() {
        return this._isAttribute;
    }

    private void setIsAttribute(boolean isAttribute) {
        this._isAttribute = isAttribute;
    }

    private void eraseIsAttribute() {
        this._isAttribute = null;
    }

    public Boolean isElement() {
        return this._isElement;
    }

    private void setIsElement(boolean isElement) {
        this._isElement = isElement;
    }

    private void eraseIsElement() {
        this._isElement = null;
    }

    public Boolean exists() {
        return this._exists;
    }

    private void setExists(boolean doesExist) {
        this._exists = doesExist;
    }

    private void eraseExists() {
        this._exists = null;
    }

    private void setIsAbsolute(boolean isAbsolute) {
        this._isAbsolute = isAbsolute;
    }

    private void eraseIsAbsolute() {
        this._isAbsolute = null;
    }

    public Boolean isAbsolute() {
        return this._isAbsolute;
    }

    private void eraseAll() {
        this.eraseExists();
        this.eraseIsAbsolute();
        this.eraseIsAttribute();
        this.eraseIsElement();
    }

    public void setValue(String value) {
        this.getTreeHandler().setCurrentNodeValue(value);
    }

    public String getValue() {
        return this.getTreeHandler().getCurrentNodeValue();
    }

    public Object getNode() {
        return this.getTreeHandler().getCurrentNode();
    }

    public void setNodeAsStart() {
        this.getTreeHandler().setCurrentElementAsStartingElement();
    }
}

