/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.EAR;
import org.silverpeas.applicationbuilder.maven.MavenContribution;
import org.silverpeas.applicationbuilder.maven.MavenRepository;
import org.silverpeas.util.Console;
import org.silverpeas.util.file.DirectoryLocator;

public class ApplicationBuilder {
    private static final String APP_BUILDER_VERSION = "Application Builder " + ResourceBundle.getBundle("messages").getString("silverpeas.version");
    private static final String APPLICATION_NAME = "Silverpeas";
    private static final String APPLICATION_DESCRIPTION = "Collaborative portal organizer";
    private static final String APPLICATION_ROOT = ResourceBundle.getBundle("messages").getString("application.root.context");
    private EAR theEAR = null;
    private MavenRepository theRepository = null;
    private MavenRepository theExternalRepository = null;
    private final Console console = new Console(ApplicationBuilder.class);

    public ApplicationBuilder() throws AppBuilderException, IOException {
        boolean errorFound = false;
        try {
            this.theRepository = new MavenRepository(this.console);
        }
        catch (AppBuilderException abe) {
            this.console.printError("", abe);
            errorFound = true;
        }
        try {
            this.theEAR = new EAR(new File(DirectoryLocator.getLibraryHome()), this.console);
        }
        catch (AppBuilderException abe) {
            this.console.printError("", abe);
            errorFound = true;
        }
        if (errorFound) {
            throw new AppBuilderException();
        }
    }

    public MavenRepository getRepository() {
        return this.theRepository;
    }

    public MavenRepository getExternalRepository() {
        return this.theExternalRepository;
    }

    public EAR getEAR() {
        return this.theEAR;
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static String getApplicationDescription() {
        return APPLICATION_DESCRIPTION;
    }

    public static String getApplicationRoot() {
        return APPLICATION_ROOT;
    }

    private void makeArchivesToDeploy() throws AppBuilderException, IOException {
        MavenContribution[] contributions;
        this.console.printMessage("CHECKING REPOSITORY");
        this.console.printMessage("Repository OK");
        this.console.printMessage("GENERATING APPLICATION FOR JBOSS");
        this.console.setEchoAsDotEnabled(true);
        for (MavenContribution contribution : contributions = this.getRepository().getContributions()) {
            this.console.printMessage("ADDING \"" + contribution.getPackageName() + "\" of type \"" + contribution.getPackageType() + '\"');
            if (null != contribution.getLibraries()) {
                this.console.printTrace("merging libraries");
                this.getEAR().addLibraries(contribution.getLibraries());
            }
            if (null != contribution.getClientPart()) {
                this.console.printTrace("merging client part");
                this.getEAR().addLibrary(contribution.getClientPart());
            }
            if (null != contribution.getWARPart()) {
                this.console.printTrace("merging WAR part");
                this.getEAR().getWAR().mergeWARPart(contribution.getWARPart());
            }
            if (null != contribution.getEJBs()) {
                this.console.printTrace("adding EJBs");
                this.getEAR().addEJBs(contribution.getEJBs());
            }
            if (null == contribution.getExternals()) continue;
            this.console.printTrace("adding External Wars");
            this.getEAR().addExternalWars(contribution.getExternals());
        }
        if (null != this.getExternalRepository()) {
            MavenContribution[] lesContributionsExternes;
            for (MavenContribution maContrib : lesContributionsExternes = this.getExternalRepository().getContributions()) {
                this.console.printMessage("ADDING \"" + maContrib.getPackageName() + "\" of type \"" + maContrib.getPackageType() + '\"');
                if (null != maContrib.getClientPart()) {
                    this.console.printTrace("merging client part");
                }
                if (null != maContrib.getLibraries()) {
                    this.console.printTrace("merging libraries");
                }
                if (null != maContrib.getWARPart()) {
                    this.console.printTrace("merging WAR part");
                    this.getEAR().getWAR().mergeWARPart(maContrib.getWARPart());
                }
                if (null != maContrib.getEJBs()) {
                    this.console.printTrace("adding EJBs");
                    this.getEAR().addEJBs(maContrib.getEJBs());
                }
                if (null == maContrib.getExternals()) continue;
                this.console.printTrace("adding External Wars");
                this.getEAR().addExternalWars(maContrib.getExternals());
            }
        }
        this.getEAR().close();
        this.console.setEchoAsDotEnabled(false);
        this.console.printMessage("OK : \"" + this.getEAR().getName() + "\" successfully builded");
        this.console.printMessage("Please find them in \"" + DirectoryLocator.getLibraryHome() + '\"');
        System.out.println("\r\nFull log is available in \"" + DirectoryLocator.getLogHome() + File.separatorChar + "application_build.log \"");
    }

    private void endLoggingWithErrors() {
        this.console.setEchoAsDotEnabled(false);
        this.console.printError("ERRORS encountered : build aborted");
        System.err.println("see \"" + DirectoryLocator.getLogHome() + File.separatorChar + "application_build.log \" for details");
        this.console.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, AppBuilderException {
        ApplicationBuilder appBuilder = new ApplicationBuilder();
        try {
            appBuilder.console.printMessage("___ " + APP_BUILDER_VERSION + " ___");
            System.out.println("___ " + APP_BUILDER_VERSION + " ___");
            appBuilder.makeArchivesToDeploy();
        }
        catch (AppBuilderException abe) {
            appBuilder.console.printError(abe.getMessage(), abe);
            appBuilder.endLoggingWithErrors();
            System.exit(1);
        }
        catch (Exception t) {
            appBuilder.console.printError(t.getMessage(), t);
            appBuilder.endLoggingWithErrors();
            System.exit(1);
        }
        finally {
            appBuilder.console.close();
        }
    }
}

