/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;

public class ApplicationBuilderItem {
    private String name = null;
    private String location = null;
    private File home = null;
    private File path = null;
    private String archivePath = null;
    private long size = -1L;

    public ApplicationBuilderItem() {
    }

    public ApplicationBuilderItem(String directory, String itemName) {
        this.setLocation(directory);
        this.setName(itemName);
    }

    public ApplicationBuilderItem(File directory, String itemName) {
        this.setHome(directory);
        this.setName(itemName);
    }

    public void setHome(File directory) {
        this.home = directory;
        this.updatePath();
    }

    public File getHome() {
        return this.home;
    }

    public void setName(String itemName) {
        this.name = itemName.trim().isEmpty() ? null : itemName;
        this.updatePath();
        this.updateArchivePath();
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String directory) {
        this.location = null == directory ? null : (directory.trim().isEmpty() ? null : directory);
        this.updateArchivePath();
    }

    public String getLocation() {
        return this.location;
    }

    public File getPath() {
        return this.path;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public long getSize() {
        if (null == this.getPath()) {
            return this.size;
        }
        if (this.getPath().exists() && !this.getPath().isDirectory()) {
            return this.getPath().length();
        }
        return -1L;
    }

    public void setSize(long length) {
        this.size = length;
    }

    private void updatePath() {
        if (null != this.getHome() && null != this.getName()) {
            this.path = new File(this.getHome(), this.getName());
        }
    }

    private void updateArchivePath() {
        if (null != this.getName()) {
            this.archivePath = "";
            if (null != this.getLocation()) {
                this.archivePath = this.archivePath + this.getLocation() + File.separator;
            }
            this.archivePath = this.archivePath + this.getName();
        }
    }
}

