/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.AppDescriptor;
import org.silverpeas.applicationbuilder.ApplicationBuilder;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.applicationbuilder.EARDirectory;
import org.silverpeas.applicationbuilder.ExternalWar;
import org.silverpeas.applicationbuilder.ReadOnlyArchive;
import org.silverpeas.applicationbuilder.WAR;
import org.silverpeas.util.Console;

public class EAR
extends EARDirectory {
    private static final String NAME = "silverpeas.ear";
    private static final String LIB_DIRECTORY = "lib";
    private AppDescriptor theAppDescriptor = null;
    private WAR theWAR = null;

    public EAR(File directory, Console console) throws AppBuilderException {
        super(directory, NAME, console);
        this.setWAR(this.earDir);
        this.setAppDescriptor();
        this.setName(NAME);
    }

    public void addLibrary(ApplicationBuilderItem library) throws AppBuilderException {
        library.setLocation(LIB_DIRECTORY);
        this.add(library);
        this.getAppDescriptor().setClientInfos("lib/" + library.getName());
    }

    public void addLibraries(ApplicationBuilderItem[] libraries) throws AppBuilderException {
        for (int i = 0; i < libraries.length; ++i) {
            this.addLibrary(libraries[i]);
        }
    }

    public void close() throws AppBuilderException {
        this.getWAR().close();
        try {
            if (this.getWAR().getPath() != null && this.getWAR().getPath().exists() && !this.getWAR().getPath().delete()) {
                this.console.printMessage("WARNING : could not delete \"" + this.getWAR().getName() + "\" from temporary space");
            }
        }
        catch (Exception e) {
            this.console.printError("WARNING : could not delete \"" + this.getWAR().getName() + "\" from temporary space", e);
        }
        this.add(this.getAppDescriptor());
    }

    public void addEJBs(ApplicationBuilderItem[] srcEjbs) throws AppBuilderException {
        for (ApplicationBuilderItem srcEjb : srcEjbs) {
            this.add(srcEjb);
            this.getAppDescriptor().addEJBName(srcEjb.getName());
        }
    }

    public WAR getWAR() {
        return this.theWAR;
    }

    private void setWAR(File directory) throws AppBuilderException {
        this.theWAR = new WAR(directory, this.console);
    }

    public AppDescriptor getAppDescriptor() {
        return this.theAppDescriptor;
    }

    private void setAppDescriptor() throws AppBuilderException {
        this.theAppDescriptor = new AppDescriptor();
        this.getAppDescriptor().setWARInfos(this.getWAR().getName(), ApplicationBuilder.getApplicationRoot());
    }

    void addExternalWars(ReadOnlyArchive[] externals) throws AppBuilderException {
        for (ReadOnlyArchive externalArchive : externals) {
            ExternalWar externalWar = new ExternalWar(externalArchive.getHome(), externalArchive.getName(), this.console);
            String warName = externalWar.getName();
            this.getAppDescriptor().setWARInfos(warName, warName.substring(0, warName.lastIndexOf(46)));
            this.add(externalWar);
        }
    }
}

