/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.util.Console;

public class ReadOnlyArchive
extends ApplicationBuilderItem {
    private JarFile myJar = null;
    protected Console console;

    public ReadOnlyArchive(File directory, String fileName, Console console) throws AppBuilderException {
        super(directory, fileName);
        this.console = console;
        this.setJar();
    }

    private JarFile getJar() {
        return this.myJar;
    }

    private void setJar() throws AppBuilderException {
        if (!this.getPath().exists()) {
            throw new AppBuilderException(this.getPath().getAbsolutePath() + " not found");
        }
        if (!this.getPath().isFile()) {
            throw new AppBuilderException(this.getPath().getAbsolutePath() + " is not a file");
        }
        if (!this.getPath().canRead()) {
            throw new AppBuilderException(this.getPath().getAbsolutePath() + " is not readable");
        }
        try {
            this.myJar = new JarFile(this.getPath(), false);
        }
        catch (IOException ioe) {
            throw new AppBuilderException(this.getName() + " : could not instantiate JarFile", ioe);
        }
    }

    public ApplicationBuilderItem[] getEntries() {
        if (this.getJar() == null) {
            return null;
        }
        ArrayList<ApplicationBuilderItem> entries = new ArrayList<ApplicationBuilderItem>(this.getJar().size());
        Enumeration<JarEntry> e = this.getJar().entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            if (jarEntry.isDirectory()) continue;
            File oneFile = new File(jarEntry.getName());
            ApplicationBuilderItem item = new ApplicationBuilderItem(oneFile.getParent(), oneFile.getName());
            item.setSize(jarEntry.getSize());
            entries.add(item);
        }
        return entries.toArray(new ApplicationBuilderItem[entries.size()]);
    }

    public InputStream getEntry(ApplicationBuilderItem entry) {
        InputStream in = null;
        try {
            JarEntry jarEntry = this.getJarEntry(entry);
            if (jarEntry == null) {
                return null;
            }
            in = this.getJar().getInputStream(jarEntry);
        }
        catch (IOException ioe) {
            this.console.printError("Could not get input stream from item \"" + entry.getName() + '\"', ioe);
        }
        return in;
    }

    public long getEntrySize(ApplicationBuilderItem entry) {
        long size = 0L;
        JarEntry jarEntry = this.getJarEntry(entry);
        if (jarEntry != null) {
            size = jarEntry.getSize();
        }
        return size;
    }

    public void close() throws AppBuilderException {
        if (this.getJar() != null) {
            try {
                this.getJar().close();
            }
            catch (IOException ioe) {
                throw new AppBuilderException(this.getName() + " : could not close JarFile object", ioe);
            }
        }
    }

    private JarEntry getJarEntry(ApplicationBuilderItem entry) {
        if (this.getJar() == null) {
            return null;
        }
        Enumeration<JarEntry> e = this.getJar().entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            File entryFile = new File(jarEntry.getName());
            if (!entryFile.getPath().equals(entry.getArchivePath())) continue;
            return jarEntry;
        }
        return null;
    }
}

