/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilder;
import org.silverpeas.applicationbuilder.XmlDocument;

public class WARDescriptor
extends XmlDocument {
    private static final String NAME = "web.xml";
    private static final String LOCATION = "WEB-INF";
    private static final String ROOT_ELT = "web-app";
    private static final String SERVLET_VERSION = "3.0";
    private static final String ROOT_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    private static final String[][] ROOT_ADDITIONAL_NAMESPACE = new String[][]{{"xsi", "http://www.w3.org/2001/XMLSchema-instance"}};
    private static final String NAME_ELT = "display-name";
    private static final String SERVLET_ELT = "servlet";
    private static final String DESC_ELT = "description";
    private static final String[] TAGS_TO_MERGE = new String[]{"context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "jsp-config", "welcome-file-list", "error-page", "security-constraint"};
    private static final String[] TAGS_TO_SORT = new String[]{"display-name", "description", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "jsp-config", "welcome-file-list", "error-page", "security-constraint"};
    private static final String[] SERVLET_TAGS = new String[]{"display-name", "servlet-name", "servlet-class", "init-param", "load-on-startup", "param-name", "param-value"};

    public WARDescriptor() {
        super(LOCATION, NAME);
        this.setDocument();
    }

    public void mergeWARPartDescriptor(XmlDocument descriptor) throws AppBuilderException {
        this.mergeWith(TAGS_TO_MERGE, descriptor);
    }

    public void sort() throws AppBuilderException {
        int iTag;
        Element root = this.getDocument().getRootElement();
        Element tempRoot = (Element)root.clone();
        tempRoot.detach();
        tempRoot.removeContent();
        ArrayList eltLstLst = new ArrayList(TAGS_TO_SORT.length);
        for (iTag = 0; iTag < TAGS_TO_SORT.length; ++iTag) {
            List children = root.getChildren(TAGS_TO_SORT[iTag], root.getNamespace());
            ArrayList<Object> eltLst = new ArrayList<Object>();
            if (children != null && !children.isEmpty()) {
                for (Object child : children) {
                    if (!(child instanceof Content)) continue;
                    Content newElement = (Content)((Content)child).clone();
                    if (newElement instanceof Element && SERVLET_ELT.equalsIgnoreCase(((Element)newElement).getName())) {
                        eltLst.add(this.sort((Element)newElement, SERVLET_TAGS));
                        continue;
                    }
                    newElement.detach();
                    eltLst.add(newElement);
                }
            }
            eltLstLst.add(iTag, eltLst);
        }
        for (iTag = 0; iTag < TAGS_TO_SORT.length; ++iTag) {
            if (((List)eltLstLst.get(iTag)).isEmpty()) continue;
            tempRoot.addContent((Collection)((List)eltLstLst.get(iTag)));
        }
        this.setDocument(new Document(tempRoot));
    }

    private void setDocument() {
        Namespace nameSpace = Namespace.getNamespace((String)ROOT_NAMESPACE);
        Element root = new Element(ROOT_ELT, nameSpace);
        root.setAttribute("version", SERVLET_VERSION);
        for (int i = 0; i < ROOT_ADDITIONAL_NAMESPACE.length; ++i) {
            root.addNamespaceDeclaration(Namespace.getNamespace((String)ROOT_ADDITIONAL_NAMESPACE[i][0], (String)ROOT_ADDITIONAL_NAMESPACE[i][1]));
        }
        Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", xsiNamespace);
        Element name = new Element(NAME_ELT, nameSpace);
        name.setText(ApplicationBuilder.getApplicationName());
        root.addContent((Content)name);
        Element desc = new Element(DESC_ELT, nameSpace);
        desc.setText(ApplicationBuilder.getApplicationDescription());
        root.addContent((Content)desc);
        Document doc = new Document(root);
        super.setDocument(doc);
    }
}

