/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.util.xml.ClasspathEntityResolver;
import org.xml.sax.EntityResolver;

public class XmlDocument
extends ApplicationBuilderItem {
    private XMLOutputter outputter = null;
    private Document underlyingDocument = null;
    private String outputEncoding = "UTF-8";

    public XmlDocument() {
    }

    public XmlDocument(String directory, String name) {
        super(directory, name);
        this.setOutputter();
    }

    public XmlDocument(File directory, String name) {
        super(directory, name);
        this.setOutputter();
    }

    public void save() throws AppBuilderException {
        try {
            this.saveTo(new FileOutputStream(this.getPath()));
        }
        catch (FileNotFoundException fnfe) {
            throw new AppBuilderException("Could not save \"" + this.getPath().getAbsolutePath() + '\"', fnfe);
        }
    }

    public void saveTo(OutputStream outStream) throws AppBuilderException {
        try {
            this.getOutputter().output(this.getDocument(), outStream);
        }
        catch (IOException ioe) {
            throw new AppBuilderException("Could not save " + this.getName() + " to output stream", ioe);
        }
    }

    public void load() throws AppBuilderException {
        if (!this.getPath().exists()) {
            throw new AppBuilderException('\"' + this.getPath().getAbsolutePath() + "\" does not exist");
        }
        try {
            this.loadFrom(this.getPath().toURI().toURL().openStream());
        }
        catch (MalformedURLException mue) {
            throw new AppBuilderException("Could not load \"" + this.getPath().getAbsolutePath() + '\"', mue);
        }
        catch (IOException ioe) {
            throw new AppBuilderException("Could not load \"" + this.getPath().getAbsolutePath() + '\"', ioe);
        }
    }

    public void loadFrom(InputStream xmlStream) throws AppBuilderException {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            builder.setEntityResolver((EntityResolver)new ClasspathEntityResolver(builder.getEntityResolver()));
            this.underlyingDocument = builder.build(xmlStream);
        }
        catch (IOException jde) {
            throw new AppBuilderException("Could not load \"" + this.getName() + "\" from input stream", jde);
        }
        catch (JDOMException jde) {
            throw new AppBuilderException("Could not load \"" + this.getName() + "\" from input stream", jde);
        }
    }

    public void mergeWith(String[] tagsToMerge, XmlDocument xmlFile) throws AppBuilderException {
        Element root = this.getDocument().getRootElement();
        root.detach();
        Document documentToBeMerged = (Document)xmlFile.getDocument().clone();
        Element tempRoot = documentToBeMerged.getRootElement();
        for (int iTag = 0; iTag < tagsToMerge.length; ++iTag) {
            for (Object child : tempRoot.getChildren(tagsToMerge[iTag], tempRoot.getNamespace())) {
                if (!(child instanceof Element)) continue;
                Element newElement = (Element)((Element)child).clone();
                newElement.detach();
                newElement.setNamespace(root.getNamespace());
                Iterator descendantsIter = newElement.getDescendants();
                while (descendantsIter.hasNext()) {
                    Object descendant = descendantsIter.next();
                    if (!(descendant instanceof Element)) continue;
                    ((Element)descendant).setNamespace(root.getNamespace());
                }
                root.addContent((Content)newElement);
            }
        }
        this.setDocument(new Document(root));
    }

    public void sort(String[] tagsToSort) throws AppBuilderException {
        Element root = this.getDocument().getRootElement();
        this.setDocument(new Document(this.sort(root, tagsToSort)));
    }

    public Element sort(Element root, String[] tagsToSort) throws AppBuilderException {
        int iTag;
        Element tempRoot = (Element)root.clone();
        tempRoot.detach();
        tempRoot.removeContent();
        ArrayList eltLstLst = new ArrayList(tagsToSort.length);
        for (iTag = 0; iTag < tagsToSort.length; ++iTag) {
            List children = root.getChildren(tagsToSort[iTag], root.getNamespace());
            ArrayList<Content> eltLst = new ArrayList<Content>();
            if (children != null && !children.isEmpty()) {
                for (Object child : children) {
                    if (!(child instanceof Content)) continue;
                    Content newElement = (Content)((Content)child).clone();
                    newElement.detach();
                    eltLst.add(newElement);
                }
            }
            eltLstLst.add(iTag, eltLst);
        }
        for (iTag = 0; iTag < tagsToSort.length; ++iTag) {
            if (((List)eltLstLst.get(iTag)).isEmpty()) continue;
            tempRoot.addContent((Collection)((List)eltLstLst.get(iTag)));
        }
        return tempRoot;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
        this.setOutputter();
    }

    private String getOutputEncoding() {
        return this.outputEncoding;
    }

    public Document getDocument() {
        return this.underlyingDocument;
    }

    public void setDocument(Document doc) {
        this.underlyingDocument = doc;
    }

    public long getDocumentSize() throws AppBuilderException {
        if (this.getDocument() != null) {
            String docStr = this.getOutputter().outputString(this.getDocument());
            long docSize = docStr.length();
            if (this.getOutputEncoding().startsWith("UTF-16")) {
                docSize *= 2L;
            }
            return docSize;
        }
        return -1L;
    }

    public String[] getAttributeValues(String[] tagsToFind, String attribute) throws AppBuilderException {
        Document resultDoc = (Document)this.getDocument().clone();
        Element root = resultDoc.getRootElement();
        ArrayList<List> eltLstLst = new ArrayList<List>(tagsToFind.length);
        for (int iTag = 0; iTag < tagsToFind.length; ++iTag) {
            List eltLst = root.getChildren(tagsToFind[iTag]);
            if (!eltLst.isEmpty() && !root.removeChildren(tagsToFind[iTag])) {
                throw new AppBuilderException("Could not remove \"" + tagsToFind[iTag] + "\" elements from \"" + this.getName() + '\"');
            }
            eltLstLst.add(iTag, eltLst);
        }
        if (eltLstLst.isEmpty()) {
            return null;
        }
        String[] attributeValues = new String[eltLstLst.size()];
        for (int i = 0; i < eltLstLst.size(); ++i) {
            List eltLst = (List)eltLstLst.get(i);
            for (int j = 0; j < eltLst.size(); ++j) {
                Element e = (Element)eltLst.get(j);
                attributeValues[i] = attribute != null ? e.getAttributeValue(attribute) : e.getText();
            }
        }
        return attributeValues;
    }

    public String[] getTagValues(String tagToFind) {
        HashSet<String> result = new HashSet<String>();
        if (this.getDocument().getRootElement().getName().equals(tagToFind)) {
            result.add(this.getDocument().getRootElement().getText());
        }
        Iterator iChildren = this.getDocument().getRootElement().getChildren(tagToFind).iterator();
        while (iChildren.hasNext()) {
            result.add(((Element)iChildren.next()).getText());
        }
        if (result.isEmpty()) {
            return null;
        }
        return this.objectArray2StringArray(result.toArray());
    }

    public String[] getAttributeValues(String attributeToFind) {
        HashSet<String> result = new HashSet<String>();
        if (this.getDocument().getRootElement().getAttribute(attributeToFind) != null) {
            result.add(this.getDocument().getRootElement().getAttributeValue(attributeToFind));
        }
        Iterator iChildren = this.getDocument().getRootElement().getChildren().iterator();
        Element currentElement = null;
        while (iChildren.hasNext()) {
            currentElement = (Element)iChildren.next();
            if (currentElement.getAttribute(attributeToFind) == null) continue;
            result.add(currentElement.getAttributeValue(attributeToFind));
        }
        if (result.isEmpty()) {
            return null;
        }
        return this.objectArray2StringArray(result.toArray());
    }

    private String[] objectArray2StringArray(Object[] objectArray) {
        String[] result = new String[objectArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)objectArray[i];
        }
        return result;
    }

    private XMLOutputter getOutputter() {
        return this.outputter;
    }

    private void setOutputter() {
        Format format = Format.getPrettyFormat();
        format.setTextMode(Format.TextMode.TRIM);
        format.setEncoding(this.outputEncoding);
        format.setIndent("    ");
        this.outputter = new XMLOutputter(format);
    }
}

