/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.applicationbuilder.ReadOnlyArchive;
import org.silverpeas.util.Console;

public class MavenContribution {
    public static final int TYPE_WAR = 0;
    public static final int TYPE_EJB = 1;
    public static final int TYPE_CLIENT = 2;
    public static final int TYPE_LIB = 3;
    public static final int TYPE_EXTERNAL = 4;
    private int type;
    private final transient StringBuffer packageName = new StringBuffer();
    private ReadOnlyArchive client = null;
    private final transient List<ApplicationBuilderItem> ejbs = new ArrayList<ApplicationBuilderItem>();
    private ReadOnlyArchive warPart = null;
    private final transient List<ReadOnlyArchive> librairies = new ArrayList<ReadOnlyArchive>();
    private final transient List<ReadOnlyArchive> externals = new ArrayList<ReadOnlyArchive>();
    private final Console console;

    public MavenContribution(File contribution, int type, Console console) throws AppBuilderException {
        this.type = type;
        this.console = console;
        this.addContribution(contribution, type);
    }

    private void addContribution(File contribution, int type) throws AppBuilderException {
        this.packageName.append(contribution.getAbsolutePath());
        this.packageName.append(File.pathSeparatorChar).append(' ');
        switch (type) {
            case 0: {
                this.warPart = new ReadOnlyArchive(contribution.getParentFile(), contribution.getName(), this.console);
                break;
            }
            case 1: {
                this.ejbs.add(new ApplicationBuilderItem(contribution.getParentFile(), contribution.getName()));
                break;
            }
            case 2: {
                this.client = new ReadOnlyArchive(contribution.getParentFile(), contribution.getName(), this.console);
                break;
            }
            case 3: {
                this.librairies.add(new ReadOnlyArchive(contribution.getParentFile(), contribution.getName(), this.console));
                break;
            }
            case 4: {
                this.externals.add(new ReadOnlyArchive(contribution.getParentFile(), contribution.getName(), this.console));
                break;
            }
        }
    }

    public MavenContribution(File[] contributions, int type, Console console) throws AppBuilderException {
        this.console = console;
        for (File contribution : contributions) {
            this.addContribution(contribution, type);
        }
    }

    public ReadOnlyArchive getClientPart() {
        return this.client;
    }

    public ApplicationBuilderItem[] getEJBs() {
        return this.ejbs.toArray(new ApplicationBuilderItem[this.ejbs.size()]);
    }

    public ReadOnlyArchive getWARPart() {
        return this.warPart;
    }

    public ReadOnlyArchive[] getLibraries() {
        return this.librairies.toArray(new ReadOnlyArchive[this.librairies.size()]);
    }

    public ReadOnlyArchive[] getExternals() {
        return this.externals.toArray(new ReadOnlyArchive[this.externals.size()]);
    }

    public String getPackageName() {
        return this.packageName.toString();
    }

    public String getPackageType() {
        switch (this.type) {
            case 0: {
                return "WAR";
            }
            case 1: {
                return "EJB";
            }
            case 2: {
                return "CLIENT";
            }
            case 3: {
                return "LIBRAIRY";
            }
            case 4: {
                return "EXTERNAL";
            }
        }
        return "";
    }
}

