/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder.maven;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.maven.ArchiveFilenameFilter;
import org.silverpeas.applicationbuilder.maven.FileComparator;
import org.silverpeas.applicationbuilder.maven.MavenContribution;
import org.silverpeas.util.Console;
import org.silverpeas.util.file.DirectoryLocator;

public class MavenRepository {
    private final transient List<MavenContribution> contributions = new LinkedList<MavenContribution>();
    private final Console console;

    public MavenRepository(Console console) throws AppBuilderException {
        this.console = console;
        this.init();
    }

    protected void init() throws AppBuilderException {
        this.loadClients();
        this.loadEjbs();
        this.loadLibrairies();
        this.loadWarParts();
        this.loadExternalParts();
    }

    protected void loadClients() throws AppBuilderException {
        File[] archives;
        for (File archive : archives = this.listArchivesInDirectory(DirectoryLocator.getClientContribHome())) {
            this.contributions.add(new MavenContribution(archive, 2, this.console));
        }
    }

    protected void loadWarParts() throws AppBuilderException {
        File[] archives;
        for (File archive : archives = this.listArchivesInDirectory(DirectoryLocator.getWarContribHome())) {
            this.contributions.add(new MavenContribution(archive, 0, this.console));
        }
    }

    protected void loadEjbs() throws AppBuilderException {
        File[] archives = this.listArchivesInDirectory(DirectoryLocator.getEjbContribHome());
        this.contributions.add(new MavenContribution(archives, 1, this.console));
    }

    protected void loadLibrairies() throws AppBuilderException {
        File[] archives = this.listArchivesInDirectory(DirectoryLocator.getLibContribHome());
        this.contributions.add(new MavenContribution(archives, 3, this.console));
    }

    protected void loadExternalParts() throws AppBuilderException {
        File[] archives;
        for (File archive : archives = this.listArchivesInDirectory(DirectoryLocator.getExternalFilesHome())) {
            this.contributions.add(new MavenContribution(archive, 4, this.console));
        }
    }

    protected File[] listArchivesInDirectory(String directoryPath) {
        File[] archives;
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory()) {
            archives = directory.listFiles(new ArchiveFilenameFilter());
            List<File> files = Arrays.asList(archives);
            Collections.sort(files, new FileComparator());
            archives = files.toArray(new File[files.size()]);
        } else {
            archives = new File[]{};
        }
        return archives;
    }

    public MavenContribution[] getContributions() {
        return this.contributions.toArray(new MavenContribution[this.contributions.size()]);
    }
}

