/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.silverpeas.dbbuilder.DBBuilderItem;
import org.silverpeas.dbbuilder.DBXmlDocument;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.dbbuilder.sql.QueryExecutor;
import org.silverpeas.dbbuilder.util.Configuration;

public class DBBuilderDBItem
extends DBBuilderItem {
    private static final String SELECT_CONTENT_FROM_DB = "select SR_ITEM_ID, SR_ACTION_TAG, SR_ITEM_ORDER, SR_FILE_NAME, SR_FILE_TYPE, SR_DELIMITER, SR_KEEP_DELIMITER, SR_DBPROC_NAME from SR_UNINSTITEMS where SR_PACKAGE = ? order by SR_ACTION_TAG, SR_ITEM_ORDER ";
    private List<Map<String, Object>> dbInfos;
    protected static final String TEMP_DBCONTRIBUTION_FILE = "temp-contribution.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBBuilderDBItem(String module) throws Exception {
        this.setModule(module);
        this.dbInfos = this.getContentFromDB();
        File f = new File(Configuration.getTemp() + File.separatorChar + TEMP_DBCONTRIBUTION_FILE);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
        try {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<contribution product=\"" + module + "\">\n");
            if (this.dbInfos != null && !this.dbInfos.isEmpty()) {
                for (Map<String, Object> infos : this.dbInfos) {
                    String tag = (String)infos.get("SR_ACTION_TAG");
                    out.write("        <" + tag + ">\n");
                    out.write("            <row name=\"" + infos.get("SR_ITEM_ID") + "\" ");
                    String valueHash = infos.get("SR_ITEM_ORDER").toString();
                    out.write("sequence=\"" + new Integer(valueHash) + "\" ");
                    out.write("type=\"" + infos.get("SR_FILE_TYPE") + "\" ");
                    if (infos.containsKey("SR_DELIMITER") && infos.get("SR_DELIMITER") != null) {
                        out.write("delimiter=\"" + infos.get("SR_DELIMITER") + "\" ");
                    }
                    if (infos.containsKey("SR_KEEP_DELIMITER") && infos.get("SR_KEEP_DELIMITER") != null) {
                        valueHash = infos.get("SR_KEEP_DELIMITER").toString();
                    }
                    if ("0".equals(valueHash)) {
                        out.write("keepdelimiter=\"NO\" ");
                    } else {
                        out.write("keepdelimiter=\"YES\" ");
                    }
                    if (infos.containsKey("SR_DBPROC_NAME") && infos.get("SR_DBPROC_NAME") != null) {
                        out.write("dbprocname=\"" + infos.get("SR_DBPROC_NAME") + "\" ");
                    }
                    out.write("/>\n");
                    out.write("        </" + tag + ">\n");
                }
            }
            out.write("</contribution>\n");
        }
        finally {
            out.close();
        }
        DBXmlDocument destXml = new DBXmlDocument(new File(Configuration.getTemp()), TEMP_DBCONTRIBUTION_FILE);
        destXml.load();
        this.setFileXml(destXml);
        this.setRoot(((Document)destXml.getDocument().clone()).getRootElement());
    }

    @Override
    public String getVersionFromFile() throws Exception {
        if (this.versionFromFile == null) {
            this.versionFromFile = "xxx";
        }
        return this.versionFromFile;
    }

    private List<Map<String, Object>> getContentFromDB() throws Exception {
        Connection connexion = null;
        List<Map<String, Object>> infos = null;
        try {
            connexion = ConnectionFactory.getConnection();
            infos = QueryExecutor.executeLoopQuery(connexion, SELECT_CONTENT_FROM_DB, new Object[]{this.getModule()});
        }
        catch (Exception e) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE JVM : " + e.getMessage() + "\n\t\t\t(" + SELECT_CONTENT_FROM_DB + ')');
        }
        finally {
            if (connexion != null) {
                connexion.close();
            }
        }
        return infos;
    }
}

