/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.silverpeas.dbbuilder.DBBuilder;
import org.silverpeas.dbbuilder.Instruction;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.dbbuilder.sql.DbProcParameter;
import org.silverpeas.dbbuilder.sql.QueryExecutor;
import org.silverpeas.util.Console;
import org.silverpeas.util.StringUtil;

public abstract class DBBuilderPiece {
    private static AtomicInteger increment = new AtomicInteger(0);
    private String actionInternalID = null;
    private String pieceName = null;
    private String content = null;
    private String actionName = null;
    private boolean traceMode = false;
    protected Instruction[] instructions = null;
    protected Connection connection;
    protected Console console = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBBuilderPiece(Console console, String pieceName, String actionName, boolean traceMode) throws Exception {
        this.console = console;
        this.traceMode = traceMode;
        this.actionName = actionName;
        this.pieceName = pieceName;
        if (pieceName.endsWith(".jar")) {
            this.content = "";
        } else {
            File myFile = new File(pieceName);
            if (!(myFile.exists() && myFile.isFile() && myFile.canRead())) {
                console.printMessage("\t\t***Unable to load : " + pieceName);
                throw new Exception("Unable to find or load : " + pieceName);
            }
            int fileSize = (int)myFile.length();
            byte[] data = new byte[fileSize];
            DataInputStream in = new DataInputStream(new FileInputStream(pieceName));
            try {
                in.readFully(data);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            this.content = new String(data, Charsets.UTF_8);
        }
        Properties res = DBBuilder.getdbBuilderResources();
        if (res != null) {
            Enumeration<Object> e = res.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = res.getProperty(key);
                this.content = StringUtil.sReplace("${" + key + '}', value, this.content);
            }
        }
    }

    public DBBuilderPiece(Console console, String pieceName, String actionName, String content, boolean traceMode) throws Exception {
        this.console = console;
        this.traceMode = traceMode;
        this.actionName = actionName;
        this.pieceName = pieceName;
        this.content = content;
    }

    public DBBuilderPiece(Console console, String actionInternalID, String pieceName, String actionName, int itemOrder, boolean traceMode) throws Exception {
        this.console = console;
        this.traceMode = traceMode;
        this.actionName = actionName;
        this.pieceName = pieceName;
        this.actionInternalID = actionInternalID;
        this.content = this.getContentFromDB(actionInternalID);
    }

    public String getActionInternalID() {
        return this.actionInternalID;
    }

    public String getPieceName() {
        return this.pieceName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getContent() {
        return this.content;
    }

    public Console getConsole() {
        return this.console;
    }

    public boolean isTraceMode() {
        return this.traceMode;
    }

    public abstract void setInstructions();

    public abstract void cacheIntoDB(Connection var1, String var2, int var3) throws Exception;

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public void traceInstructions() {
        for (Instruction instruction : this.instructions) {
            System.out.println(instruction.getInstructionText());
        }
    }

    public void executeInstructions(Connection connection) throws Exception {
        this.setConnection(connection);
        block4: for (Instruction instruction : this.instructions) {
            String currentInstruction = instruction.getInstructionText();
            switch (instruction.getInstructionType()) {
                case 2: {
                    this.executeJavaInvoke(currentInstruction, instruction.getInstructionDetail());
                    continue block4;
                }
                case 0: {
                    this.executeSingleProcedure(currentInstruction, (DbProcParameter[])instruction.getInstructionDetail());
                    continue block4;
                }
                default: {
                    this.executeSingleUpdate(currentInstruction);
                }
            }
        }
    }

    public void cacheIntoDB(Connection connexion, String _package, int _itemOrder, String _pieceType, String _delimiter, Integer _keepDelimiter, String _dbProcName) throws Exception {
        this.setConnection(connexion);
        PreparedStatement pstmt = null;
        long theLong = System.currentTimeMillis();
        String itemID = String.valueOf(theLong) + '-' + increment.incrementAndGet();
        try {
            pstmt = connexion.prepareStatement("insert into SR_UNINSTITEMS(SR_ITEM_ID, SR_PACKAGE, SR_ACTION_TAG, SR_ITEM_ORDER, SR_FILE_NAME, SR_FILE_TYPE, SR_DELIMITER, SR_KEEP_DELIMITER, SR_DBPROC_NAME) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt.setString(1, itemID);
            pstmt.setString(2, _package);
            pstmt.setString(3, this.actionName);
            pstmt.setInt(4, _itemOrder);
            pstmt.setString(5, this.pieceName);
            pstmt.setString(6, _pieceType);
            pstmt.setString(7, _delimiter);
            pstmt.setInt(8, _keepDelimiter);
            pstmt.setString(9, _dbProcName);
            pstmt.executeUpdate();
        }
        catch (Exception ex) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE RDBMS : " + ex.getMessage() + '\n', ex);
        }
        finally {
            DbUtils.closeQuietly((Statement)pstmt);
        }
        try {
            String[] subS = this.getSubStrings(this.content);
            pstmt = connexion.prepareStatement("insert into SR_SCRIPTS(SR_ITEM_ID, SR_SEQ_NUM, SR_TEXT) values (?, ?, ? )");
            for (int i = 0; i < subS.length; ++i) {
                pstmt.setString(1, itemID);
                pstmt.setInt(2, i);
                pstmt.setString(3, subS[i]);
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE RDBMS : " + ex.getMessage() + '\n', ex);
        }
        finally {
            DbUtils.closeQuietly((Statement)pstmt);
        }
    }

    public void executeSingleUpdate(String currentInstruction) throws Exception {
        if (this.traceMode) {
            String printableInstruction = StringUtil.sReplace("\r\n", " ", currentInstruction);
            if ((printableInstruction = StringUtil.sReplace("\t", " ", printableInstruction)).length() > 147) {
                printableInstruction = printableInstruction.substring(0, 146) + "...";
            }
            this.console.printMessage("\t\t>" + printableInstruction);
        }
        Statement stmt = this.connection.createStatement();
        try {
            stmt.executeUpdate(currentInstruction);
        }
        catch (Exception e) {
            throw new Exception("\r\n***ERROR RETURNED BY THE RDBMS : " + e.getMessage() + "\r\n***STATEMENT ON ERROR IS : " + currentInstruction + " " + this.pieceName, e);
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    public void executeSingleProcedure(String currentInstruction, DbProcParameter[] params) throws Exception {
        if (this.traceMode) {
            String printableInstruction = StringUtil.sReplace("\n", " ", currentInstruction);
            if ((printableInstruction = StringUtil.sReplace("\t", " ", printableInstruction)).length() > 147) {
                printableInstruction = printableInstruction.substring(0, 146) + "...";
            }
            this.console.printMessage("\t\t>" + printableInstruction);
        }
        try {
            QueryExecutor.executeProcedure(this.connection, currentInstruction, params);
        }
        catch (Exception e) {
            throw new Exception("\r\n***ERROR RETURNED BY THE RDBMS : " + e.getMessage() + "\r\n***STATEMENT ON ERROR IS : " + currentInstruction, e);
        }
    }

    public void executeJavaInvoke(String currentInstruction, Object myClass) throws Exception {
        Method methode;
        if (this.traceMode) {
            this.console.printMessage("\t\t>" + myClass.getClass().getName() + '.' + currentInstruction + "()");
        }
        ((DbBuilderDynamicPart)myClass).setConnection(this.connection);
        try {
            methode = myClass.getClass().getMethod(currentInstruction, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("No method \"" + currentInstruction + "\" defined for \"" + myClass.getClass().getName() + "\" class.", e);
        }
        catch (SecurityException e) {
            throw new Exception("No method \"" + currentInstruction + "\" defined for \"" + myClass.getClass().getName() + "\" class.", e);
        }
        try {
            methode.invoke(myClass, new Object[0]);
        }
        catch (Exception e) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE JVM : " + e.getMessage(), e);
        }
    }

    private String[] getSubStrings(String str) {
        int maxl = 1100;
        int nbS = str.length() / maxl;
        if (str.length() - nbS * maxl > 0) {
            ++nbS;
        }
        String tmpS = str;
        String[] retS = new String[nbS];
        for (int i = 0; i < nbS; ++i) {
            if (i == nbS - 1) {
                retS[i] = tmpS;
                continue;
            }
            retS[i] = tmpS.substring(0, maxl - 1);
            tmpS = tmpS.substring(maxl - 1);
        }
        return retS;
    }

    private String getContentFromDB(String itemID) throws Exception {
        StringBuilder dbContent = new StringBuilder("");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Connection connexion = ConnectionFactory.getConnection();
            pstmt = connexion.prepareStatement("select SR_SEQ_NUM, SR_TEXT from SR_SCRIPTS where SR_ITEM_ID = ? order by 1");
            pstmt.setString(1, itemID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                dbContent = dbContent.append(rs.getString("SR_TEXT"));
            }
        }
        catch (Exception e) {
            try {
                throw new Exception("\r\n***ERROR RETURNED BY THE JVM : " + e.getMessage() + "\r\n(select SR_SEQ_NUM, SR_TEXT from SR_SCRIPTS where SR_ITEM_ID = '" + itemID + "'  order by 1)");
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)pstmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)pstmt);
        return dbContent.toString();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

