/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.silverpeas.util.jndi.SimpleMemoryContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private DataSource datasource;
    private static ConnectionFactory instance;

    private ConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactory getInstance() {
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (null == instance) {
                instance = new ConnectionFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
        SimpleMemoryContextFactory.setUpAsInitialContext();
        try {
            InitialContext ic = new InitialContext();
            ic.rebind("java:/datasources/DocumentStoreDS", (Object)this.datasource);
        }
        catch (NamingException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static Connection getConnection() throws SQLException {
        Connection connection = ConnectionFactory.getInstance().datasource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConnectionInfo() throws SQLException {
        StringBuilder builder = new StringBuilder(512);
        Connection connection = null;
        try {
            connection = ConnectionFactory.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String newLine = System.getProperty("line.separator");
            builder.append(newLine).append("\tRDBMS").append(metaData.getDatabaseProductName());
            builder.append(newLine).append("\tJdbcUrl       : ").append(metaData.getURL());
            builder.append(newLine).append("\tJdbcDriver    : ").append(metaData.getDriverName());
            builder.append(newLine).append("\tUserName      : ").append(metaData.getUserName());
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
        return builder.toString();
    }
}

