/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.silverpeas.dbbuilder.sql.DbProcParameter;

public class QueryExecutor {
    public static void executeUpdate(Connection connection, String query) throws SQLException {
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DbUtils.close((Statement)stmt);
        }
    }

    public static void executeProcedure(Connection connection, String procedureName, DbProcParameter[] dbProcParameters) throws SQLException {
        int i;
        StringBuilder preparedStatement;
        if (dbProcParameters == null || dbProcParameters.length == 0) {
            preparedStatement = new StringBuilder("{call " + procedureName + '}');
        } else {
            preparedStatement = new StringBuilder("{call " + procedureName + '(');
            for (i = 0; i < dbProcParameters.length; ++i) {
                preparedStatement.append('?');
                if (i == dbProcParameters.length - 1) continue;
                preparedStatement.append(',');
            }
            preparedStatement.append(")}");
        }
        CallableStatement call = connection.prepareCall(preparedStatement.toString());
        if (dbProcParameters != null) {
            for (i = 0; i < dbProcParameters.length; ++i) {
                DbProcParameter dbPP = dbProcParameters[i];
                call.setObject(i + 1, dbPP.getParameterValue(), dbPP.getParameterType());
                if (!dbPP.getIsOutParameter()) continue;
                call.registerOutParameter(i + 1, dbPP.getParameterType());
            }
        }
        call.execute();
        if (dbProcParameters != null) {
            for (i = 0; i < dbProcParameters.length; ++i) {
                if (!dbProcParameters[i].getIsOutParameter()) continue;
                dbProcParameters[i].setParameterValue(call.getObject(i + 1));
            }
        }
        call.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<Map<String, Object>> executeLoopQuery(Connection connection, String query, Object[] parameters) throws Exception {
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        ResultSet results = null;
        try {
            if (parameters == null) {
                stmt = connection.createStatement();
                results = stmt.executeQuery(query);
            } else {
                pstmt = connection.prepareStatement(query);
                for (int i = 0; i < parameters.length; ++i) {
                    pstmt.setObject(i + 1, parameters[i]);
                }
                results = pstmt.executeQuery();
            }
            ResultSetMetaData meta = results.getMetaData();
            while (results.next()) {
                HashMap<String, Object> h = new HashMap<String, Object>(meta.getColumnCount());
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    Object ob = results.getObject(i);
                    h.put(meta.getColumnLabel(i).toUpperCase(), ob);
                }
                array.add(h);
            }
        }
        catch (SQLException sqlex) {
            DbUtils.closeQuietly(results);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Statement)pstmt);
            catch (Throwable throwable) {
                DbUtils.closeQuietly(results);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Statement)pstmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)results);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Statement)pstmt);
        return array;
    }

    private QueryExecutor() {
    }
}

