/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.classified;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.dbutils.DbUtils;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.migration.classified.FieldTemplate;
import org.silverpeas.migration.classified.RecordTemplate;
import org.silverpeas.migration.jcr.service.AttachmentException;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.migration.jcr.service.model.DocumentType;
import org.silverpeas.migration.jcr.service.model.SimpleDocument;
import org.silverpeas.migration.jcr.service.model.SimpleDocumentPK;
import org.silverpeas.migration.jcr.service.repository.DocumentRepository;
import org.silverpeas.util.Console;
import org.silverpeas.util.StringUtil;

public class XmlFormImagesToAttachment
extends DbBuilderDynamicPart {
    private final RepositoryManager repositoryManager = new RepositoryManager();
    private final DocumentRepository documentRepository = new DocumentRepository(this.repositoryManager);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws Exception {
        Session session = this.openJCRSession();
        try {
            this.getConsole().printMessage("Migrate Classified Images in XML Form To Attachment and Classified Description in XML Form to Classified DB");
            this.getConsole().printMessage("");
            long migrationStart = System.currentTimeMillis();
            Collection<String> listInstanceId = this.getListClassifiedInstance();
            for (String instanceId : listInstanceId) {
                long instanceMigrationStart = System.currentTimeMillis();
                int instanceIntId = Integer.parseInt(instanceId);
                this.getConsole().printMessage("Migrate Classified instance id = " + instanceId);
                String xmlFormName = this.getXMLFormName(instanceIntId);
                this.getConsole().printTrace("Migrate Classified XML Form = " + xmlFormName);
                Collection<Integer> listTemplateId = this.getListTemplate(xmlFormName, instanceId);
                for (Integer templateId : listTemplateId) {
                    this.getConsole().printTrace("TemplateId = " + templateId);
                    Collection<RecordTemplate> listRecord = this.getListRecord(templateId);
                    for (RecordTemplate record : listRecord) {
                        int recordId = record.getRecordId();
                        String classifiedId = record.getExternalId();
                        int classifiedIntId = Integer.parseInt(classifiedId);
                        this.getConsole().printMessage("Record [recordId = " + recordId + ", externalId = " + classifiedId + "]");
                        Collection<FieldTemplate> listValue = this.getListValue(recordId);
                        for (FieldTemplate fieldTemplate : listValue) {
                            this.getConsole().printTrace("Field Name = " + fieldTemplate.getFieldName());
                            if (fieldTemplate.getFieldName().startsWith("photo")) {
                                if (StringUtil.isDefined(fieldTemplate.getFieldValue())) {
                                    this.getConsole().printTrace("Photo field value = " + fieldTemplate.getFieldValue());
                                    this.getConsole().printTrace("Delete field template recordId = " + recordId + ", fieldName = '" + fieldTemplate.getFieldName() + "', fieldValue = " + fieldTemplate.getFieldValue());
                                    try {
                                        this.deletePhotoValue(recordId, fieldTemplate.getFieldName());
                                    }
                                    catch (SQLException e) {
                                        this.getConsole().printError("ERROR when Deleting field template recordId = " + recordId + ", fieldName = '" + fieldTemplate.getFieldName() + "', fieldValue = " + fieldTemplate.getFieldValue() + ", error = " + e.getMessage(), e);
                                    }
                                    if (!StringUtil.isLong(fieldTemplate.getFieldValue())) continue;
                                    SimpleDocumentPK simpleDocumentPk = new SimpleDocumentPK(null, "classifieds" + instanceId);
                                    simpleDocumentPk.setOldSilverpeasId(Long.valueOf(fieldTemplate.getFieldValue()));
                                    try {
                                        this.moveImageContext(session, simpleDocumentPk);
                                    }
                                    catch (AttachmentException e) {
                                        this.getConsole().printError("ERROR when Moving attachment image id = " + fieldTemplate.getFieldValue() + ", " + e.getMessage());
                                    }
                                    continue;
                                }
                                this.getConsole().printTrace("Photo field value = null");
                                this.getConsole().printTrace("Delete field template recordId = " + recordId + ", fieldName = '" + fieldTemplate.getFieldName() + "', fieldValue = null");
                                try {
                                    this.deletePhotoValue(recordId, fieldTemplate.getFieldName());
                                }
                                catch (SQLException e) {
                                    this.getConsole().printError("ERROR when Deleting field template recordId = " + recordId + ", fieldName = '" + fieldTemplate.getFieldName() + "', fieldValue = null, error = " + e.getMessage(), e);
                                }
                                continue;
                            }
                            if (!"description".equals(fieldTemplate.getFieldName())) continue;
                            this.getConsole().printTrace("Description field value = " + fieldTemplate.getFieldValue());
                            this.getConsole().printTrace("Update classified instanceId = " + instanceId + ", classifiedId = " + classifiedId + ", description = " + fieldTemplate.getFieldValue());
                            boolean updated = false;
                            try {
                                this.updateClassified(instanceId, classifiedIntId, fieldTemplate.getFieldValue());
                                updated = true;
                            }
                            catch (SQLException e) {
                                this.getConsole().printError("ERROR when Updating classified instanceId = " + instanceId + ", classifiedId = " + classifiedId + ", description = " + fieldTemplate.getFieldValue() + ", error = " + e.getMessage(), e);
                            }
                            if (!updated) continue;
                            this.getConsole().printTrace("Delete field template recordId = " + recordId + ", fieldName = 'description'");
                            try {
                                this.deleteDescriptionValue(recordId);
                            }
                            catch (SQLException e) {
                                this.getConsole().printError("ERROR when Deleting field template recordId = " + recordId + ", fieldName = 'description', error = " + e.getMessage(), e);
                            }
                        }
                        this.getConsole().printTrace("");
                    }
                    this.getConsole().printTrace("---------------------");
                }
                if (session.hasPendingChanges()) {
                    session.save();
                }
                long instanceMigrationEnd = System.currentTimeMillis();
                this.getConsole().printMessage("Classified instance " + instanceId + " has been migrated in " + (instanceMigrationEnd - instanceMigrationStart) + " ms");
                this.getConsole().printMessage("--------------------------------------------------------------------");
            }
            long migrationEnd = System.currentTimeMillis();
            this.getConsole().printMessage("Classified components have been migrated in " + (migrationEnd - migrationStart) + " ms");
        }
        finally {
            this.repositoryManager.logout(session);
            this.repositoryManager.shutdown();
            this.getConsole().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getListClassifiedInstance() throws SQLException {
        ArrayList<String> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> listInstanceId = new ArrayList<String>();
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery("SELECT id FROM st_componentinstance where componentname='classifieds'");
            while (rs.next()) {
                String instanceId = rs.getString("id");
                listInstanceId.add(instanceId);
            }
            arrayList = listInstanceId;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.close((Statement)stmt);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.close((Statement)stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLFormName(int instanceId) throws SQLException {
        String string;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String xmlFormName = null;
        try {
            pstmt = this.getConnection().prepareStatement("SELECT value FROM st_instance_data where componentid = ? and name='XMLFormName'");
            pstmt.setInt(1, instanceId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                xmlFormName = rs.getString("value");
            }
            string = xmlFormName;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.close((Statement)pstmt);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.close((Statement)pstmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getListTemplate(String xmlFormName, String instanceId) throws SQLException {
        ArrayList<Integer> arrayList;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Integer> listTemplateId = new ArrayList<Integer>();
        try {
            pstmt = this.getConnection().prepareStatement("SELECT templateId FROM sb_formtemplate_template where templateName=? and externalId like ?");
            pstmt.setString(1, xmlFormName);
            pstmt.setString(2, "classifieds" + instanceId + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int templateId = rs.getInt("templateId");
                listTemplateId.add(new Integer(templateId));
            }
            arrayList = listTemplateId;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.close((Statement)pstmt);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.close((Statement)pstmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RecordTemplate> getListRecord(int templateId) throws SQLException {
        ArrayList<RecordTemplate> arrayList;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<RecordTemplate> listRecord = new ArrayList<RecordTemplate>();
        try {
            pstmt = this.getConnection().prepareStatement("SELECT recordId, externalId FROM sb_formtemplate_record where templateid = ?");
            pstmt.setInt(1, templateId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int recordId = rs.getInt("recordId");
                String externalId = rs.getString("externalId");
                RecordTemplate recordTemplate = new RecordTemplate(recordId, externalId);
                listRecord.add(recordTemplate);
            }
            arrayList = listRecord;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.close((Statement)pstmt);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.close((Statement)pstmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FieldTemplate> getListValue(int recordId) throws SQLException {
        ArrayList<FieldTemplate> arrayList;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<FieldTemplate> listValue = new ArrayList<FieldTemplate>();
        try {
            pstmt = this.getConnection().prepareStatement("SELECT fieldName, fieldValue FROM sb_formtemplate_textfield where recordid = ?");
            pstmt.setInt(1, recordId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String fieldName = rs.getString("fieldName");
                String fieldValue = rs.getString("fieldValue");
                FieldTemplate fieldTemplate = new FieldTemplate(fieldName, fieldValue);
                listValue.add(fieldTemplate);
            }
            arrayList = listValue;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.close((Statement)pstmt);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.close((Statement)pstmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClassified(String instanceId, int classifiedId, String description) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement("UPDATE SC_Classifieds_Classifieds set description = ? where instanceId = ? and classifiedId = ? ");
            pstmt.setString(1, description);
            pstmt.setString(2, "classifieds" + instanceId);
            pstmt.setInt(3, classifiedId);
            pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.close(pstmt);
            throw throwable;
        }
        DbUtils.close((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDescriptionValue(int recordId) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement("DELETE FROM sb_formtemplate_textfield where recordId = ? and fieldName = 'description'");
            pstmt.setInt(1, recordId);
            pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.close(pstmt);
            throw throwable;
        }
        DbUtils.close((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePhotoValue(int recordId, String fieldPhotoName) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement("DELETE FROM sb_formtemplate_textfield where recordId = ? and fieldName = ?");
            pstmt.setInt(1, recordId);
            pstmt.setString(2, fieldPhotoName);
            pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.close(pstmt);
            throw throwable;
        }
        DbUtils.close((Statement)pstmt);
    }

    private void moveImageContext(Session session, SimpleDocumentPK simpleDocumentPk) {
        try {
            Console console = this.getConsole();
            session = this.repositoryManager.getSession();
            SimpleDocument simpleDocument = this.documentRepository.findDocumentByOldSilverpeasId(session, simpleDocumentPk.getComponentName(), simpleDocumentPk.getOldSilverpeasId(), false, null);
            if (simpleDocument != null) {
                boolean verifFormatImage = this.verifFormatImage(simpleDocument.getFilename());
                if (verifFormatImage) {
                    console.printTrace("Delete attachment with attachmentId = " + simpleDocument.getId() + ", oldSilverpeasId = " + simpleDocument.getOldSilverpeasId());
                    String sourcePath = simpleDocument.getFullJcrPath();
                    simpleDocument.setDocumentType(DocumentType.attachment);
                    String destinationPath = simpleDocument.getFullJcrPath();
                    console.printTrace("Moving " + sourcePath + " to " + destinationPath);
                    if (!session.nodeExists(destinationPath)) {
                        this.documentRepository.prepareComponentAttachments(session, simpleDocumentPk.getInstanceId(), DocumentType.attachment.getFolderName());
                    }
                    session.move(sourcePath, destinationPath);
                } else {
                    console.printTrace("Format Image not correct, delete attachment attachmentId = " + simpleDocument.getId() + ", oldSilverpeasId = " + simpleDocument.getOldSilverpeasId());
                    this.documentRepository.deleteDocument(session, simpleDocument.getPk());
                }
            } else {
                throw new AttachmentException("ERROR Simple Document with oldSilverpeasId " + simpleDocumentPk.getOldSilverpeasId() + " not found");
            }
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private Session openJCRSession() {
        try {
            return this.repositoryManager.getSession();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private boolean verifFormatImage(String filename) {
        int indexPoint = filename.lastIndexOf(46);
        if (indexPoint != -1) {
            String extension = filename.substring(indexPoint + 1);
            if ("jpg".equals(extension = extension.toLowerCase(Locale.FRANCE)) || "gif".equals(extension) || "bmp".equals(extension) || "tiff".equals(extension) || "tif".equals(extension) || "jpeg".equals(extension) || "png".equals(extension)) {
                return true;
            }
        }
        return false;
    }
}

