/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.attachment;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.migration.jcr.service.AttachmentException;
import org.silverpeas.migration.jcr.service.ConverterUtil;
import org.silverpeas.migration.jcr.service.DocumentMigration;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.migration.jcr.service.model.DocumentType;
import org.silverpeas.migration.jcr.service.model.SimpleAttachment;
import org.silverpeas.migration.jcr.service.model.SimpleDocument;
import org.silverpeas.migration.jcr.service.model.SimpleDocumentPK;
import org.silverpeas.migration.jcr.service.repository.DocumentConverter;
import org.silverpeas.migration.jcr.service.repository.DocumentRepository;
import org.silverpeas.util.ConfigurationHolder;
import org.silverpeas.util.Console;
import org.silverpeas.util.DateUtil;
import org.silverpeas.util.StringUtil;
import org.silverpeas.util.file.FileUtil;

public class AttachmentMigration
implements Callable<Long> {
    public static final String SELECT_ATTACHMENTS = "SELECT attachmentid, attachmentphysicalname, attachmentlogicalname, attachmentdescription, attachmenttype, attachmentsize, attachmentcontext, attachmentforeignkey, instanceid, attachmentcreationdate, attachmentauthor, attachmenttitle, attachmentinfo, attachmentordernum, workerid, cloneid, lang , reservationdate, alertdate, expirydate, xmlform FROM sb_attachment_attachment WHERE instanceid = ? ORDER BY attachmentforeignkey, attachmentphysicalname, attachmentordernum";
    public static final String SELECT_ATTACHMENT_TRANSLATION = "SELECT id, attachmentid, lang, attachmentphysicalname, attachmentlogicalname, attachmenttype, attachmentsize, instanceid, attachmentcreationdate, attachmentauthor, attachmenttitle, attachmentinfo, xmlform FROM sb_attachment_attachmenti18n WHERE attachmentid = ? ORDER BY lang";
    public static final String DELETE_ATTACHMENT_TRANSLATIONS = "DELETE FROM sb_attachment_attachmenti18n WHERE attachmentid = ?";
    public static final String DELETE_ATTACHMENT = "DELETE FROM sb_attachment_attachment WHERE attachmentid = ?";
    private final String componentId;
    private final RepositoryManager repositoryManager;
    private final DocumentRepository documentRepository;
    private final Console console;
    private static final DocumentConverter converter = new DocumentConverter();

    public AttachmentMigration(String instanceId, RepositoryManager repositoryManager, Console console) {
        this.componentId = instanceId;
        this.repositoryManager = repositoryManager;
        this.documentRepository = new DocumentRepository(repositoryManager);
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long migrateComponent() throws Exception {
        this.console.printMessage("Migrating component " + this.componentId);
        long processStart = System.currentTimeMillis();
        long migratedDocumentCount = 0L;
        final Session session = this.openJCRSession();
        try {
            migratedDocumentCount += this.migrateAllDocuments(new DocumentMigration(){

                @Override
                public long migrate(SimpleDocument document) throws Exception {
                    return AttachmentMigration.this.migrateDocument(session, document);
                }
            });
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        finally {
            this.repositoryManager.logout(session);
        }
        long processEnd = System.currentTimeMillis();
        this.console.printMessage("Migrating the component " + this.componentId + " required the migration of " + migratedDocumentCount + " documents in " + (processEnd - processStart) + "ms");
        this.console.printMessage("");
        return migratedDocumentCount;
    }

    protected long migrateDocument(Session session, SimpleDocument document) throws Exception {
        File attachment = document.getAttachment().getFile();
        this.console.printMessage("=> Creating document " + document.getFilename() + " for " + attachment.getAbsolutePath());
        long processStart = System.currentTimeMillis();
        long translationCount = 0L;
        try {
            this.createDocumentNodeInJCR(session, document);
            Set<File> files = this.migrateDocumentTranslations(session, document);
            translationCount = files.size();
            files.add(attachment);
            this.cleanAll(document.getOldSilverpeasId(), files);
        }
        catch (AttachmentException ex) {
            if (ex.getCause() instanceof ItemExistsException) {
                this.console.printWarning("Attachment " + document.getFilename() + " for " + attachment.getAbsolutePath() + " seems to exists already", ex);
            }
            this.console.printError("Error in component " + this.componentId + " while migrating attachment " + document.getFilename() + ": " + ex.getMessage(), ex);
            throw ex;
        }
        long processEnd = System.currentTimeMillis();
        this.console.printMessage("   document  " + document.getFilename() + " with " + translationCount + " translations has been created in " + (processEnd - processStart) + "ms");
        return 1L;
    }

    private Set<File> migrateDocumentTranslations(final Session session, SimpleDocument document) throws Exception {
        final HashSet<File> translationFiles = new HashSet<File>();
        this.migrateAllTranslations(document, new DocumentMigration(){

            @Override
            public long migrate(SimpleDocument document) throws Exception {
                File file = document.getAttachment().getFile();
                AttachmentMigration.this.console.printMessage("   => Creating translation " + document.getFilename() + " in " + document.getAttachment().getLanguage() + " for " + file.getAbsolutePath());
                AttachmentMigration.this.createTranslationInJCR(session, document);
                translationFiles.add(file);
                return 0L;
            }
        });
        return translationFiles;
    }

    private void createDocumentNodeInJCR(Session session, SimpleDocument document) throws IOException {
        try {
            this.documentRepository.createDocument(session, document);
            session.save();
            this.copyContent(document);
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void createTranslationInJCR(Session session, SimpleDocument document) throws IOException {
        try {
            Node documentNode = session.getNodeByIdentifier(document.getId());
            converter.addAttachment(documentNode, document.getAttachment());
            session.save();
            this.copyContent(document);
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long migrateAllDocuments(DocumentMigration migration) throws Exception {
        long migratedDocumentCount = 0L;
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = connection.prepareStatement(SELECT_ATTACHMENTS);
            statement.setString(1, this.componentId);
            result = statement.executeQuery();
            while (result.next()) {
                String author;
                String instanceId = result.getString("instanceid");
                SimpleDocumentPK pk = new SimpleDocumentPK(null, instanceId);
                pk.setOldSilverpeasId(result.getLong("attachmentid"));
                String contentType = result.getString("attachmenttype");
                if (!StringUtil.isDefined(contentType)) {
                    contentType = FileUtil.getMimeType(result.getString("attachmentlogicalname"));
                }
                if (!StringUtil.isDefined(author = result.getString("attachmentauthor"))) {
                    author = "0";
                }
                String useContext = result.getString("attachmentcontext");
                SimpleAttachment attachment = new SimpleAttachment(result.getString("attachmentlogicalname"), ConverterUtil.checkLanguage(result.getString("lang")), result.getString("attachmenttitle"), result.getString("attachmentinfo"), result.getLong("attachmentsize"), contentType, author, DateUtil.parse(result.getString("attachmentcreationdate")), result.getString("xmlform"));
                File file = this.getAttachmenFile(result.getString("instanceid"), useContext, result.getString("attachmentphysicalname"));
                if (file != null) {
                    attachment.setFile(file);
                    SimpleDocument document = new SimpleDocument(pk, result.getString("attachmentforeignkey"), result.getInt("attachmentordernum"), false, result.getString("workerid"), DateUtil.parse(result.getString("reservationdate")), DateUtil.parse(result.getString("alertdate")), DateUtil.parse(result.getString("expirydate")), result.getString("attachmentdescription"), attachment);
                    document.setDocumentType(DocumentType.fromOldContext(instanceId, useContext));
                    document.setOldContext(useContext);
                    document.setUpdated(document.getCreated());
                    document.setUpdatedBy(author);
                    migratedDocumentCount += migration.migrate(document);
                    continue;
                }
                this.console.printWarning("The file refered by " + attachment + " doesn't exist in the filesystem! So, it is not taken into account");
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(result);
            DbUtils.closeQuietly((Statement)statement);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)result);
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
        return migratedDocumentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateAllTranslations(SimpleDocument document, DocumentMigration migration) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = this.getConnection();
        try {
            pstmt = connection.prepareStatement(SELECT_ATTACHMENT_TRANSLATION);
            pstmt.setLong(1, document.getOldSilverpeasId());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String language;
                String author;
                String instanceId = rs.getString("instanceid");
                SimpleDocumentPK pk = new SimpleDocumentPK(null, instanceId);
                pk.setOldSilverpeasId(rs.getLong("attachmentid"));
                String contentType = rs.getString("attachmenttype");
                if (!StringUtil.isDefined(contentType)) {
                    contentType = FileUtil.getMimeType(rs.getString("attachmentlogicalname"));
                }
                if (!StringUtil.isDefined(author = rs.getString("attachmentauthor"))) {
                    author = "0";
                }
                if (!StringUtil.isDefined(language = rs.getString("lang"))) {
                    language = ConverterUtil.extractLanguage(rs.getString("attachmentlogicalname"));
                }
                language = ConverterUtil.checkLanguage(language);
                File file = this.getAttachmenFile(rs.getString("instanceid"), document.getOldContext(), rs.getString("attachmentphysicalname"));
                if (file != null) {
                    SimpleAttachment attachment = new SimpleAttachment(rs.getString("attachmentlogicalname"), language, rs.getString("attachmenttitle"), rs.getString("attachmentinfo"), rs.getLong("attachmentsize"), contentType, author, DateUtil.parse(rs.getString("attachmentcreationdate")), rs.getString("xmlform"));
                    attachment.setFile(file);
                    document.setAttachment(attachment);
                    document.setUpdated(attachment.getCreated());
                    document.setUpdatedBy(attachment.getCreatedBy());
                    migration.migrate(document);
                    continue;
                }
                this.console.printWarning("The translation in " + language + " doesn't exist in the filesystem! So, it is not taken into account");
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)pstmt);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)pstmt);
        DbUtils.closeQuietly((Connection)connection);
    }

    protected File getAttachmenFile(String instanceId, String context, String physicalName) throws IOException {
        String baseDirectory = ConfigurationHolder.getDataHome() + File.separatorChar + "workspaces" + File.separatorChar + instanceId;
        String contextDirectory = "";
        if (context != null) {
            contextDirectory = context;
        }
        String attachmentDirectory = (baseDirectory + File.separatorChar + "Attachment" + File.separatorChar + contextDirectory).replace('/', File.separatorChar);
        String directory = (baseDirectory + File.separatorChar + contextDirectory).replace('/', File.separatorChar);
        File file = new File(attachmentDirectory, physicalName);
        if (!(file.exists() && file.isFile() || (file = new File(directory, physicalName)).exists() && file.isFile())) {
            file = null;
        }
        if (file == null) {
            this.console.printError("File " + physicalName + " not found in " + attachmentDirectory + " or in " + directory);
        }
        return file;
    }

    protected void cleanAll(long oldSilverpeasId, Set<File> files) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement deleteTranslations = null;
        PreparedStatement deleteAttachment = null;
        try {
            connection.setAutoCommit(false);
            deleteTranslations = connection.prepareStatement(DELETE_ATTACHMENT_TRANSLATIONS);
            deleteTranslations.setLong(1, oldSilverpeasId);
            deleteTranslations.executeUpdate();
            DbUtils.closeQuietly((Statement)deleteTranslations);
            deleteAttachment = connection.prepareStatement(DELETE_ATTACHMENT);
            deleteAttachment.setLong(1, oldSilverpeasId);
            deleteAttachment.executeUpdate();
            for (File file : files) {
                ConverterUtil.deleteFile(file);
            }
            connection.commit();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(deleteTranslations);
                DbUtils.closeQuietly(deleteAttachment);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)deleteTranslations);
        DbUtils.closeQuietly((Statement)deleteAttachment);
        DbUtils.closeQuietly((Connection)connection);
    }

    protected Connection getConnection() throws SQLException {
        return ConnectionFactory.getConnection();
    }

    @Override
    public Long call() throws Exception {
        return this.migrateComponent();
    }

    private Session openJCRSession() {
        try {
            return this.repositoryManager.getSession();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void copyContent(SimpleDocument document) throws IOException, RepositoryException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(document.getAttachment().getFile()));
            this.documentRepository.storeContent(document, in);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AttachmentException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }
}

