/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.attachment;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.dbutils.DbUtils;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.migration.jcr.attachment.AttachmentMigration;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.util.ConfigurationHolder;

public class AttachmentMigrator
extends DbBuilderDynamicPart {
    private static final ExecutorService executor;
    private static final int threadCount;
    private final RepositoryManager repositoryManager = new RepositoryManager();
    public static final String SELECT_COMPONENTS = "SELECT DISTINCT instanceid FROM sb_attachment_attachment ORDER BY instanceid";
    public static final String SELECT_MAX_ID = "SELECT maxid FROM uniqueid WHERE tablename = 'sb_attachment_attachment'";
    public static final String UPDATE_UNIQUEID = "INSERT INTO uniqueid (maxid, tablename) VALUES (?, 'sb_simple_document')";

    public void migrateAttachments() throws Exception {
        this.getConsole().printMessage("Migration of the attachments in JCR with a pool of " + threadCount + " threads");
        this.updateUniqueId();
        long totalNumberOfMigratedFiles = 0L;
        List<AttachmentMigration> migrators = this.buildComponentMigrators();
        List result = executor.invokeAll(migrators);
        try {
            for (Future nbOfMigratedDocuments : result) {
                totalNumberOfMigratedFiles += ((Long)nbOfMigratedDocuments.get()).longValue();
            }
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.getConsole().printError("Error during migration of attachments " + ex, ex);
            throw ex;
        }
        finally {
            executor.shutdown();
            this.repositoryManager.shutdown();
        }
        this.getConsole().printMessage("Nb of migrated documents : " + totalNumberOfMigratedFiles);
        this.getConsole().printMessage("*************************************************************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AttachmentMigration> buildComponentMigrators() throws SQLException {
        ArrayList<AttachmentMigration> arrayList;
        ArrayList<AttachmentMigration> result = new ArrayList<AttachmentMigration>(500);
        Statement stmt = null;
        ResultSet rs = null;
        this.getConsole().printMessage("All components to be migrated : ");
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery(SELECT_COMPONENTS);
            StringBuilder message = new StringBuilder();
            while (rs.next()) {
                String instanceId = rs.getString("instanceid");
                result.add(new AttachmentMigration(instanceId, this.repositoryManager, this.getConsole()));
                message.append(instanceId).append(" ");
            }
            this.getConsole().printMessage(message.toString());
            this.getConsole().printMessage("");
            arrayList = result;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)stmt);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        return arrayList;
    }

    protected void updateUniqueId() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        long maxId = 0L;
        this.getConsole().printMessage("Updating uniqueId");
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery(SELECT_MAX_ID);
            if (rs.next()) {
                maxId = rs.getLong("maxid");
            }
        }
        catch (SQLException sqlex) {
            try {
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)stmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        try {
            PreparedStatement pstmt = this.getConnection().prepareStatement(UPDATE_UNIQUEID);
            pstmt.setLong(1, maxId);
            pstmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        finally {
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    static {
        threadCount = ConfigurationHolder.getMaxThreadsCount();
        executor = Executors.newFixedThreadPool(threadCount);
    }
}

