/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service.model;

import org.silverpeas.migration.jcr.service.model.UnlockOption;

public class UnlockContext {
    private int options = 0;
    private String attachmentId;
    private String userId;
    private String comment;
    private String lang;

    public UnlockContext(String attachmentId, String userId, String lang) {
        this.attachmentId = attachmentId;
        this.userId = userId;
        this.lang = lang;
        this.comment = "";
    }

    public UnlockContext(String attachmentId, String userId, String lang, String comment) {
        this.attachmentId = attachmentId;
        this.userId = userId;
        this.lang = lang;
        this.comment = comment;
    }

    public void addOption(UnlockOption option) {
        this.options = option.addOption(this.options);
    }

    public void removeOption(UnlockOption option) {
        this.options = option.removeOption(this.options);
    }

    public boolean isPublicVersion() {
        return !UnlockOption.PRIVATE_VERSION.isSelected(this.options);
    }

    public boolean isForce() {
        return UnlockOption.FORCE.isSelected(this.options);
    }

    public boolean isUpload() {
        return UnlockOption.UPLOAD.isSelected(this.options);
    }

    public boolean isWebdav() {
        return UnlockOption.WEBDAV.isSelected(this.options);
    }

    public boolean isPrivateVersion() {
        return UnlockOption.PRIVATE_VERSION.isSelected(this.options);
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLang() {
        return this.lang;
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.options;
        hash = 29 * hash + (this.attachmentId != null ? this.attachmentId.hashCode() : 0);
        hash = 29 * hash + (this.userId != null ? this.userId.hashCode() : 0);
        hash = 29 * hash + (this.comment != null ? this.comment.hashCode() : 0);
        hash = 29 * hash + (this.lang != null ? this.lang.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnlockContext other = (UnlockContext)obj;
        if (this.options != other.options) {
            return false;
        }
        if (this.attachmentId == null ? other.attachmentId != null : !this.attachmentId.equals(other.attachmentId)) {
            return false;
        }
        if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
            return false;
        }
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        return !(this.lang == null ? other.lang != null : !this.lang.equals(other.lang));
    }
}

