/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.version;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.dbutils.DbUtils;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.migration.jcr.version.VersionedDocumentMigration;
import org.silverpeas.util.ConfigurationHolder;
import org.silverpeas.util.StringUtil;

public class VersioningMigrator
extends DbBuilderDynamicPart {
    private static final ExecutorService executor;
    private static final int threadCount;
    private final RepositoryManager repositoryManager = new RepositoryManager();
    public static final String SELECT_COMPONENTS = "SELECT DISTINCT instanceid FROM sb_version_document ORDER BY instanceid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateDocuments() throws Exception {
        this.getConsole().printMessage("Migration of the versioned documents in JCR with a pool of " + threadCount + " threads");
        long totalNumberOfMigratedFiles = 0L;
        List<VersionedDocumentMigration> migrators = this.buildComponentMigrators();
        List result = executor.invokeAll(migrators);
        try {
            for (Future nbOfMigratedDocuments : result) {
                totalNumberOfMigratedFiles += ((Long)nbOfMigratedDocuments.get()).longValue();
            }
        }
        finally {
            executor.shutdown();
            this.repositoryManager.shutdown();
        }
        this.getConsole().printMessage("Nb of migrated versioned documents : " + totalNumberOfMigratedFiles);
        this.getConsole().printMessage("*************************************************************");
    }

    private List<VersionedDocumentMigration> buildComponentMigrators() throws SQLException {
        ArrayList<VersionedDocumentMigration> arrayList;
        ArrayList<VersionedDocumentMigration> result = new ArrayList<VersionedDocumentMigration>(500);
        Statement stmt = null;
        ResultSet rs = null;
        this.getConsole().printMessage("All components to be migrated : ");
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery(SELECT_COMPONENTS);
            StringBuilder message = new StringBuilder();
            while (rs.next()) {
                String instanceId = rs.getString("instanceid");
                if (!StringUtil.isDefined(instanceId)) continue;
                result.add(new VersionedDocumentMigration(instanceId, this.repositoryManager, this.getConsole()));
                message.append(instanceId).append(" ");
            }
            this.getConsole().printMessage(message.toString());
            this.getConsole().printMessage("");
            arrayList = result;
        }
        catch (SQLException sqlex) {
            try {
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)stmt);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        return arrayList;
    }

    static {
        threadCount = ConfigurationHolder.getMaxThreadsCount();
        executor = Executors.newFixedThreadPool(threadCount);
    }
}

