/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.version.model;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.silverpeas.util.ConfigurationHolder;
import org.silverpeas.util.Console;

public class Version {
    private static Console console = new Console(Version.class);
    private int id;
    private int minor;
    private int major;
    private Date creation;
    private String createdBy;
    private String fileName;
    private String physicalFilename;
    private String contentType;
    private long size;
    private String xmlFormId;
    private String comment;
    private String instanceId;

    public Version(int id, int minor, int major, Date creation, String createdBy, String fileName, String physicalFilename, String contentType, long size, String xmlFormId, String comment, String instanceId) {
        this.id = id;
        this.minor = minor;
        this.major = major;
        this.creation = creation;
        this.createdBy = createdBy;
        this.fileName = fileName;
        this.physicalFilename = physicalFilename;
        this.contentType = contentType;
        this.size = size;
        this.xmlFormId = xmlFormId;
        this.comment = comment;
        this.instanceId = instanceId;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public Date getCreation() {
        return this.creation;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPhysicalFilename() {
        return this.physicalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.size;
    }

    public String getXmlFormId() {
        return this.xmlFormId;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isPublic() {
        return this.minor == 0;
    }

    public int getId() {
        return this.id;
    }

    public File getAttachment() throws IOException {
        String baseDirectory = ConfigurationHolder.getDataHome() + File.separatorChar + "workspaces" + File.separatorChar + this.instanceId + File.separatorChar + "Versioning";
        File file = new File(baseDirectory, this.physicalFilename);
        if (!file.exists() || !file.isFile()) {
            console.printWarning("The file " + file.getAbsolutePath() + " doesn't exist");
            file = null;
        }
        return file;
    }

    public String toString() {
        return "Version{id=" + this.id + ", minor=" + this.minor + ", major=" + this.major + ", creation=" + this.creation + ", createdBy=" + this.createdBy + ", fileName=" + this.fileName + ", physicalFilename=" + this.physicalFilename + ", contentType=" + this.contentType + ", size=" + this.size + ", xmlFormId=" + this.xmlFormId + ", comment=" + this.comment + ", instanceId=" + this.instanceId + '}';
    }
}

