/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.wysiwyg;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.migration.jcr.service.SimpleDocumentService;
import org.silverpeas.migration.jcr.wysiwyg.WysiwygDocumentMerger;
import org.silverpeas.util.StringUtil;

public class WysiwygCorrector
extends DbBuilderDynamicPart {
    private static final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final SimpleDocumentService service = new SimpleDocumentService();

    public void migrateDocuments() throws Exception {
        long totalNumberOfMigratedFiles = 0L;
        List<WysiwygDocumentMerger> mergers = this.buildWysiwygDocumentMergers();
        List result = executor.invokeAll(mergers);
        try {
            for (Future nbOfMigratedDocuments : result) {
                totalNumberOfMigratedFiles += ((Long)nbOfMigratedDocuments.get()).longValue();
            }
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.getConsole().printError("Error during migration of attachments " + ex, ex);
            throw ex;
        }
        finally {
            executor.shutdown();
        }
        this.getConsole().printMessage("Nb of migrated versioned documents : " + totalNumberOfMigratedFiles);
        this.service.shutdown();
    }

    private List<WysiwygDocumentMerger> buildWysiwygDocumentMergers() {
        this.getConsole().printMessage("All components to be migrated : ");
        List<String> componentIds = this.service.listComponentIdsWithWysiwyg();
        ArrayList<WysiwygDocumentMerger> result = new ArrayList<WysiwygDocumentMerger>(componentIds.size());
        for (String componentId : componentIds) {
            if (!StringUtil.isDefined(componentId)) continue;
            result.add(new WysiwygDocumentMerger(componentId, this.service, this.getConsole()));
            this.getConsole().printMessage(componentId + ", ");
        }
        this.getConsole().printMessage("*************************************************************");
        return result;
    }
}

