/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.questionreply;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.migration.questionreply.ReplyContent;
import org.silverpeas.util.file.FileUtil;

public class ReplyContentToWysiwygMigration
extends DbBuilderDynamicPart {
    public static final String QUERY = "SELECT sc_questionreply_question.instanceid AS instanceid, sc_questionreply_reply.id AS id, sc_questionreply_reply.content AS content FROM sc_questionreply_question, sc_questionreply_reply WHERE sc_questionreply_question.id = sc_questionreply_reply.questionid";

    public void migrateReplyContentToWysiwyg() throws Exception {
        Properties props = FileUtil.loadResource("/org/silverpeas/general.properties");
        String upLoadPath = props.getProperty("uploadsPath");
        List<ReplyContent> contents = this.getContent();
        for (ReplyContent content : contents) {
            this.migrate(content, upLoadPath);
        }
    }

    public List<ReplyContent> getContent() throws Exception {
        ArrayList<ReplyContent> result = new ArrayList<ReplyContent>();
        Connection connection = this.getConnection();
        Statement stmt = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(QUERY);
            while (rs.next()) {
                result.add(new ReplyContent(rs.getInt("id"), rs.getString("instanceid"), rs.getString("content")));
            }
            ArrayList<ReplyContent> arrayList = result;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new Exception("Error during content migration for QuestionReply : " + ex.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    void migrate(ReplyContent content, String upLoadPath) {
        block2: {
            File targetDir = new File(upLoadPath + File.separatorChar + content.getInstanceId() + File.separatorChar + "Attachment" + File.separatorChar + "wysiwyg" + File.separatorChar);
            ByteArrayInputStream in = null;
            try {
                targetDir.mkdirs();
                in = new ByteArrayInputStream(content.getContent().getBytes("UTF-8"));
                FileUtils.copyInputStreamToFile((InputStream)in, (File)new File(targetDir, content.getId() + "wysiwyg.txt"));
            }
            catch (IOException ioex) {
                if (in == null) break block2;
                IOUtils.closeQuietly(in);
            }
        }
    }
}

