/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.uniqueid;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;

public class FixCaseInUniqueId
extends DbBuilderDynamicPart {
    public void migrate() throws SQLException {
        Map<String, Long> uniqueIds = this.listCurrentIds();
        this.cleanTable();
        this.insertNewIds(uniqueIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTable() throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            stmt.executeUpdate("DELETE FROM uniqueId");
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> listCurrentIds() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<String, Long> uniqueIds = new HashMap<String, Long>(222);
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery("SELECT tablename, maxid FROM uniqueId");
            while (rs.next()) {
                String tableName = rs.getString("tablename");
                long maxId = rs.getLong("maxid");
                if (tableName == null) continue;
                if (uniqueIds.containsKey(tableName = tableName.toLowerCase())) {
                    if (((Long)uniqueIds.get(tableName)).compareTo(maxId) >= 0) continue;
                    uniqueIds.put(tableName, maxId);
                    continue;
                }
                uniqueIds.put(tableName, maxId);
            }
            HashMap<String, Long> hashMap = uniqueIds;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewIds(Map<String, Long> uniqueIds) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement("INSERT INTO uniqueId (tablename, maxId) VALUES(?, ?)");
            for (Map.Entry<String, Long> uniqueId : uniqueIds.entrySet()) {
                pstmt.setString(1, uniqueId.getKey());
                pstmt.setLong(2, uniqueId.getValue());
                pstmt.executeUpdate();
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }
}

