/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.settings.file;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.silverpeas.settings.file.ElementModif;

public abstract class ModifFile {
    protected String path = null;
    protected ArrayList<ElementModif> listeModifications = new ArrayList();
    protected boolean isModified = false;

    public ModifFile() {
    }

    public ModifFile(String path) throws Exception {
        this.setPath(path);
    }

    protected final void setPath(String src) throws Exception {
        File file = new File(src);
        if (!file.exists()) {
            throw new Exception("Le fichier \"" + src + "\" n'existe pas");
        }
        this.path = src;
    }

    public static void copyFile(File in, File out) throws Exception {
        FileUtils.copyFile((File)in, (File)out);
    }

    public void addModification(String pSearch, String pModif) {
        this.listeModifications.add(new ElementModif(pSearch, pModif));
    }

    public void addModification(ElementModif em) {
        this.listeModifications.add(em);
    }

    public void addModification(String pModif) throws Exception {
        int index = pModif.lastIndexOf(61);
        if (index == -1) {
            throw new Exception("la chaine \"" + pModif + "\" n'est pas standard \"key=modif\"");
        }
        this.listeModifications.add(new ElementModif(pModif.substring(0, index - 1), pModif.substring(index + 1, pModif.length())));
    }

    public void createFileBak(String str) throws Exception {
        File file = new File(this.path);
        if (!file.exists() || !file.isFile()) {
            throw new Exception("Le fichier :\"" + this.path + "\" n'existe pas ou n'est pas un fichier");
        }
        File newFile = str == null ? new File(this.path + ".bak") : new File(str);
        ModifFile.copyFile(file, newFile);
    }

    public abstract void executeModification() throws Exception;
}

