/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.silverpeas.util.Console;
import org.silverpeas.util.GestionVariables;
import org.silverpeas.util.StringUtil;

public class ConfigurationHolder {
    private static final String SILVERPEAS_HOME_PROP_KEY = "silverpeas.home";
    private static final String SILVERPEAS_HOME_ENV_KEY = "SILVERPEAS_HOME";
    private static final String THREADS_KEY = "threads";
    private static String silverpeasHome = null;
    private static GestionVariables configuration = null;
    private static boolean abortOnError = true;
    private static final Console console = new Console(ConfigurationHolder.class);

    protected static synchronized void reloadConfiguration() {
        try {
            ConfigurationHolder.defineHome();
            configuration = ConfigurationHolder.loadConfiguration();
        }
        catch (IOException ex) {
            console.printWarning("Error loading configuration", ex);
        }
    }

    public static void setAbortOnError(boolean on) {
        abortOnError = on;
    }

    public static boolean getAbortOnError() {
        return abortOnError;
    }

    public static String getHome() {
        if (silverpeasHome == null) {
            ConfigurationHolder.defineHome();
        }
        return silverpeasHome;
    }

    private static void defineHome() {
        silverpeasHome = System.getProperty(SILVERPEAS_HOME_PROP_KEY);
        if (!StringUtil.isDefined(silverpeasHome)) {
            silverpeasHome = System.getenv(SILVERPEAS_HOME_ENV_KEY);
            if (!StringUtil.isDefined(silverpeasHome)) {
                console.printError("### CANNOT FIND SILVERPEAS INSTALL LOCATION ###");
                console.printError("please use \"-Dsilverpeas.home=install_location\" on the command line");
                console.printError("or define the SILVERPEAS_HOME environment variable.");
                if (ConfigurationHolder.getAbortOnError()) {
                    console.printError("### ABORTED ###");
                    System.exit(1);
                }
            } else {
                System.setProperty(SILVERPEAS_HOME_PROP_KEY, silverpeasHome);
            }
        }
    }

    public static String getDataHome() throws IOException {
        return configuration.resolveAndEvalString("${SILVERPEAS_DATA_HOME}");
    }

    public static int getMaxThreadsCount() {
        return Integer.valueOf(System.getProperty(THREADS_KEY, "10"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GestionVariables loadConfiguration() throws IOException {
        Properties defaultConfig = new Properties();
        InputStream in = ConfigurationHolder.class.getResourceAsStream("/default_config.properties");
        try {
            defaultConfig.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        Properties config = new Properties(defaultConfig);
        File configFile = new File(ConfigurationHolder.getHome() + File.separatorChar + "setup" + File.separatorChar + "settings", "config.properties");
        if (configFile.exists() && configFile.isFile()) {
            in = new FileInputStream(configFile);
            try {
                config.load(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return new GestionVariables(config);
    }

    private ConfigurationHolder() {
    }

    static {
        try {
            ConfigurationHolder.defineHome();
            configuration = ConfigurationHolder.loadConfiguration();
        }
        catch (IOException ex) {
            console.printWarning("Error loading configuration", ex);
        }
    }
}

