/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.silverpeas.util.StringUtil;

public class DateUtil {
    private static final long millisPerHour = 3600000L;
    private static final long millisPerMinute = 60000L;
    public static final SimpleDateFormat DATE_PARSER = new SimpleDateFormat("yyyy/MM/dd");
    public static final FastDateFormat DATE_FORMATTER;
    public static final SimpleDateFormat DATETIME_PARSER;
    public static final FastDateFormat DATETIME_FORMATTER;
    public static final FastDateFormat ISO8601DATE_FORMATTER;
    public static final FastDateFormat ISO8601DAY_FORMATTER;
    public static final FastDateFormat ICALDAY_FORMATTER;
    public static final FastDateFormat ICALDATE_FORMATTER;
    public static final FastDateFormat ICALUTCDATE_FORMATTER;
    public static final FastDateFormat ISO8601_FORMATTER;
    public static final SimpleDateFormat TIME_PARSER;
    public static final FastDateFormat TIME_FORMATTER;

    public static Date getDate(Date date, String hour) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, DateUtil.extractHour(hour));
        calendar.set(12, DateUtil.extractMinutes(hour));
        return calendar.getTime();
    }

    public static int extractHour(String hour) {
        if (!StringUtil.isDefined(hour)) {
            return 0;
        }
        if (hour.indexOf(58) != -1) {
            return Integer.parseInt(hour.substring(0, hour.indexOf(58)));
        }
        if (hour.indexOf(104) != -1) {
            return Integer.parseInt(hour.substring(0, hour.indexOf(104)));
        }
        return 0;
    }

    public static int extractMinutes(String hour) {
        if (!StringUtil.isDefined(hour)) {
            return 0;
        }
        if (hour.indexOf(58) != -1) {
            return Integer.parseInt(hour.substring(hour.indexOf(58) + 1));
        }
        if (hour.indexOf(104) != -1) {
            return Integer.parseInt(hour.substring(hour.indexOf(104) + 1));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String date) throws ParseException {
        if (!StringUtil.isDefined(date)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = DATE_PARSER;
        synchronized (simpleDateFormat) {
            return DATE_PARSER.parse(date);
        }
    }

    public static Date parse(String date, String format) throws ParseException {
        if (!StringUtil.isDefined(date)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(date);
    }

    public static boolean datesAreEqual(Date date1, Date date2) {
        Calendar cDate1 = Calendar.getInstance();
        cDate1.setTime(date1);
        Calendar cDate2 = Calendar.getInstance();
        cDate2.setTime(date2);
        if (cDate1.get(1) != cDate2.get(1)) {
            return false;
        }
        if (cDate1.get(2) != cDate2.get(2)) {
            return false;
        }
        return cDate1.get(5) == cDate2.get(5);
    }

    public static String today2SQLDate() {
        return DateUtil.date2SQLDate(new Date());
    }

    public static String date2SQLDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMATTER.format(date);
    }

    public static String firstDayOfMonth2SQLDate(Date date) {
        String sqlDate = DATE_FORMATTER.format(date);
        sqlDate = sqlDate.substring(0, sqlDate.length() - 2) + "01";
        return sqlDate;
    }

    public static String formatDuration(long duration) {
        long hourDuration = duration / 3600000L;
        long minuteDuration = duration % 3600000L / 60000L;
        long secondDuration = duration % 3600000L % 60000L / 1000L;
        StringBuilder result = new StringBuilder(10);
        if (hourDuration > 0L) {
            if (hourDuration < 10L) {
                result.append('0');
            }
            result.append(hourDuration).append('h');
            if (minuteDuration < 10L) {
                result.append('0');
            }
            result.append(minuteDuration).append('m');
        } else if (hourDuration <= 0L && minuteDuration > 0L) {
            result.append(minuteDuration).append('m');
        }
        if (result.length() > 0 && secondDuration < 10L) {
            result.append('0');
        }
        return result.append(secondDuration).append('s').toString();
    }

    public static String getFormattedTime(Date date) {
        return DateUtil.formatTime(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = DATE_PARSER;
        synchronized (simpleDateFormat) {
            result.setTime(DATE_PARSER.parse(date));
        }
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        return result.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = DATETIME_PARSER;
        synchronized (simpleDateFormat) {
            result.setTime(DATETIME_PARSER.parse(date));
        }
        return result.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseTime(String time) throws ParseException {
        if (time == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = TIME_PARSER;
        synchronized (simpleDateFormat) {
            result.setTime(TIME_PARSER.parse(time));
        }
        return result.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar parseCalendar(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = DATE_PARSER;
        synchronized (simpleDateFormat) {
            result.setTime(DATE_PARSER.parse(date));
        }
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        return result;
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMATTER.format(date);
    }

    public static String formatDate(Calendar calend) {
        if (calend == null) {
            return null;
        }
        return DATE_FORMATTER.format(calend.getTime());
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat formater = new SimpleDateFormat(pattern);
        return formater.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTime(Calendar calend, String time) {
        calend.set(13, 0);
        calend.set(14, 0);
        if (time != null) {
            try {
                Calendar result = Calendar.getInstance();
                SimpleDateFormat simpleDateFormat = TIME_PARSER;
                synchronized (simpleDateFormat) {
                    result.setTime(TIME_PARSER.parse(time));
                }
                calend.set(11, result.get(11));
                calend.set(12, result.get(12));
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        calend.set(11, 0);
        calend.set(12, 0);
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return null;
        }
        return TIME_FORMATTER.format(date);
    }

    public static String formatTime(Calendar calend) {
        if (calend == null) {
            return null;
        }
        return TIME_FORMATTER.format(calend.getTime());
    }

    public static String formatAsISO8601Date(Date date) {
        return ISO8601DATE_FORMATTER.format(date);
    }

    public static String formatAsISO8601Day(Date date) {
        return ISO8601DAY_FORMATTER.format(date);
    }

    public static String formatAsICalDate(Date date) {
        return ICALDATE_FORMATTER.format(date);
    }

    public static String formatAsICalUTCDate(Date date) {
        return ICALUTCDATE_FORMATTER.format(date);
    }

    public static String formatAsICalDay(Date date) {
        return ICALDAY_FORMATTER.format(date);
    }

    public static Date parseISO8601Date(String date) throws ParseException {
        return DateUtils.parseDate((String)date, (String[])new String[]{ISO8601DATE_FORMATTER.getPattern(), ISO8601DAY_FORMATTER.getPattern()});
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date curDate) {
        if (curDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(curDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
        return null;
    }

    public static Date getBeginOfDay(Date curDate) {
        if (curDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(curDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static void setAtBeginOfDay(Calendar calendar) {
        if (calendar != null) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
    }

    public static void addDaysExceptWeekEnds(Calendar calendar, int nbDay) {
        int nb = 0;
        while (nb < nbDay) {
            calendar.add(5, 1);
            if (calendar.get(7) == 7 || calendar.get(7) == 1) continue;
            ++nb;
        }
    }

    public static int getDayNumberInWeek(Date curDate) {
        return DateUtil.convert(curDate).get(7);
    }

    public static Calendar convert(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        return cal;
    }

    private DateUtil() {
    }

    static {
        DATE_PARSER.setLenient(false);
        DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy/MM/dd");
        DATETIME_PARSER = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        DATETIME_FORMATTER = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm");
        TIME_PARSER = new SimpleDateFormat("HH:mm");
        TIME_PARSER.setLenient(false);
        TIME_FORMATTER = FastDateFormat.getInstance((String)"HH:mm");
        ISO8601DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm");
        ISO8601DAY_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd");
        ICALDAY_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMdd");
        ICALDATE_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss");
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        ICALUTCDATE_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss'Z'", (TimeZone)utcTimeZone);
        ISO8601_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)utcTimeZone);
    }
}

