/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.silverpeas.dbbuilder.util.Configuration;
import org.silverpeas.util.ConfigurationHolder;

public final class FileUtil {
    private static final Tika tika = new Tika();

    private FileUtil() {
    }

    public static void copyFile(String fromPath, String toPath) throws IOException {
        FileUtils.copyFileToDirectory((File)new File(fromPath), (File)new File(toPath));
    }

    public static void copyFile(String fileName, String fromDir, String toDir) throws IOException {
        FileUtils.copyFile((File)new File(fromDir, fileName), (File)new File(toDir, fileName));
    }

    public static void copyFile(File from, File toDir) throws IOException {
        if (!from.canRead()) {
            throw new IOException("Cannot read file '" + from + "'.");
        }
        if (toDir.exists() && !toDir.canWrite()) {
            throw new IOException("Cannot write to file '" + toDir + "'.");
        }
        toDir.getParentFile().mkdirs();
        FileUtils.copyFile((File)from, (File)toDir);
    }

    public static void copyDir(String fromDir, String toDir) throws IOException {
        FileUtils.copyDirectory((File)new File(fromDir), (File)new File(toDir));
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        if (!fromDir.exists()) {
            throw new IOException("Cannot found file or directory \"" + fromDir + "\".");
        }
        if (fromDir.isFile()) {
            FileUtil.copyFile(fromDir, toDir);
        } else {
            if (toDir.isFile()) {
                throw new IOException("cannot copy directory \"" + fromDir + "\" into the file" + toDir + "\".");
            }
            toDir.mkdirs();
            FileUtils.copyDirectory((File)fromDir, (File)toDir);
        }
    }

    public static String getExtension(File file) throws IOException {
        return FilenameUtils.getExtension((String)file.getName());
    }

    public static String getExtension(String file) throws IOException {
        return FilenameUtils.getExtension((String)file);
    }

    public static void deleteFiles(String _file) throws IOException {
        File file = new File(_file);
        FileUtils.forceDelete((File)file);
    }

    public static void deleteFilesOnExit(String _file) throws IOException {
        File file = new File(_file);
        FileUtils.forceDeleteOnExit((File)file);
    }

    public static String getMimeType(String fileName) {
        return tika.detect(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadResource(String propertyName) throws IOException {
        Properties properties = new Properties();
        InputStream in = Configuration.class.getClassLoader().getResourceAsStream(propertyName);
        try {
            if (null == in) {
                File configurationFile;
                String path = propertyName.replace('/', File.separatorChar);
                if (!(path = path.replace('\\', File.separatorChar)).startsWith(File.separator)) {
                    path = File.separatorChar + path;
                }
                if ((configurationFile = new File(ConfigurationHolder.getHome() + File.separatorChar + "properties" + path)).exists()) {
                    in = new FileInputStream(configurationFile);
                }
            }
            if (null != in) {
                properties.load(in);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return properties;
    }

    public static String getAbsolutePath(String componentId) {
        try {
            Properties props = FileUtil.loadResource("/org/silverpeas/general.properties");
            return props.getProperty("uploadsPath") + File.separatorChar + componentId + File.separatorChar;
        }
        catch (IOException ex) {
            try {
                return ConfigurationHolder.getDataHome() + File.separatorChar + "workspaces" + File.separatorChar + componentId + File.separatorChar;
            }
            catch (IOException ioex) {
                return ConfigurationHolder.getHome() + File.separatorChar + "data" + File.separatorChar + "workspaces" + File.separatorChar + componentId + File.separatorChar;
            }
        }
    }
}

