/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.xml;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class XmlTreeHandler {
    public static final char MODE_SELECT = 'S';
    public static final char MODE_INSERT = 'I';
    public static final char MODE_DELETE = 'D';
    public static final char MODE_UPDATE = 'U';
    public static final char MODE_UNIQUE = '1';
    private Element _startingElement = null;
    private char _mode;
    private String _name = null;
    private Element _element = null;
    private Iterator _iElements = null;
    private Attribute _attribute = null;
    private Element _cousinsAncestor = null;
    public static final char TYPE_ATTRIBUTE = 'A';
    public static final char TYPE_ELEMENT = 'E';
    private LinkedList _stateStack = null;

    public XmlTreeHandler() {
        this(null, 'S');
    }

    public XmlTreeHandler(Element startingElement) {
        this(startingElement, 'S');
    }

    public XmlTreeHandler(Element startingElement, char mode) {
        this.setStartingElement(startingElement);
        this.setMode(mode);
    }

    public void setStartingElement(Element startingElement) {
        this.removeAllStates();
        this._startingElement = startingElement;
        this.eraseAttribute();
        this.eraseName();
        this.setElement(this._startingElement);
        this.syncIElementsWithElementAndName();
        this.setCurrentElementAsCousinsAncestor();
        this.pushState();
    }

    public void setMode(char mode) {
        this._mode = mode;
    }

    public char getMode() {
        return this._mode;
    }

    public Element getStartingElement() {
        return this._startingElement;
    }

    private void setName(String name) {
        this._name = name;
    }

    private String getName() {
        return this._name;
    }

    private boolean hasName() {
        return null != this.getName();
    }

    private void eraseName() {
        if (this.hasName()) {
            this.setName(null);
        }
    }

    private void setElement(Element e) {
        this._element = e;
    }

    private Element getElement() {
        return this._element;
    }

    private boolean hasElement() {
        return null != this.getElement();
    }

    private void eraseElement() {
        if (this.hasElement()) {
            this.setElement(null);
        }
    }

    private void setIElements(Iterator iElements) {
        this._iElements = iElements;
    }

    private Iterator getIElements() {
        return this._iElements;
    }

    private boolean hasIElements() {
        return null != this.getIElements();
    }

    private void eraseIElements() {
        if (this.hasIElements()) {
            this._iElements = null;
        }
    }

    private void setNextIElementsAsElement() {
        if (this.hasIElements()) {
            switch (this.getMode()) {
                case '1': 
                case 'D': {
                    if (this.hasName()) {
                        this.eraseAll();
                        break;
                    }
                }
                case 'U': {
                    if (this.hasName() && this.getIElements().hasNext()) {
                        this.setElement((Element)this.getIElements().next());
                        break;
                    }
                }
                case 'I': {
                    if (this.hasName()) {
                        Element e = new Element(this.getName());
                        this.getElement().getParentElement().getChildren(this.getName()).add(e);
                        this.setElement(e);
                        this.syncIElementsWithElementAndName();
                        break;
                    }
                }
                case 'S': {
                    if (this.getIElements().hasNext()) {
                        this.setElement((Element)this.getIElements().next());
                        break;
                    }
                    this.eraseAll();
                    break;
                }
            }
        } else {
            this.eraseAll();
        }
    }

    private void syncIElementsWithElementAndName() {
        if (this.hasElement()) {
            if (this.getElement().isRootElement()) {
                this.eraseIElements();
            } else {
                List children = null;
                children = this.hasName() ? this.getElement().getParentElement().getChildren(this.getName()) : this.getElement().getParentElement().getChildren();
                this.setIElements(children.iterator());
                while (!this.getElement().equals(this.getIElements().next())) {
                }
            }
        }
    }

    private void setAttribute(Attribute a) {
        this._attribute = a;
    }

    private Attribute getAttribute() {
        return this._attribute;
    }

    private boolean hasAttribute() {
        return null != this.getAttribute();
    }

    private void eraseAttribute() {
        if (this.hasAttribute()) {
            this.setAttribute(null);
        }
    }

    private void setCousinsAncestor(Element ancestor) {
        this._cousinsAncestor = ancestor;
    }

    private Element getCousinsAncestor() {
        return this._cousinsAncestor;
    }

    private void eraseCousinsAncestor() {
        this._cousinsAncestor = null;
    }

    private boolean hasCousinsAncestor() {
        return null != this._cousinsAncestor;
    }

    private boolean isElementCousinsAncestor() {
        if (!this.hasElement()) {
            return false;
        }
        if (!this.hasCousinsAncestor()) {
            return this.getElement().isRootElement();
        }
        return this.getCousinsAncestor().equals((Object)this.getElement());
    }

    private boolean isParentCousinsAncestor() {
        if (!this.hasElement()) {
            return false;
        }
        if (!this.hasCousinsAncestor()) {
            return this.hasParent() && this.getElement().getParentElement().isRootElement();
        }
        Element a = this.getCousinsAncestor();
        Element p = this.getElement().getParentElement();
        return a.equals((Object)p);
    }

    private void setElementCousinsAncestor() {
        if (this.hasElement()) {
            this.setCousinsAncestor(this.getElement());
        } else {
            this.eraseCousinsAncestor();
        }
    }

    private void setParentCousinsAncestor() {
        if (this.hasElement() && this.hasParent() && !this.getElement().getParentElement().isRootElement()) {
            this.setCousinsAncestor(this.getElement().getParentElement());
        } else {
            this.eraseCousinsAncestor();
        }
    }

    private void eraseAll() {
        this.eraseAttribute();
        this.eraseName();
        this.eraseElement();
        this.eraseIElements();
        this.eraseCousinsAncestor();
    }

    public boolean isElement() {
        return this.hasElement();
    }

    public boolean isAttribute() {
        return this.hasAttribute();
    }

    public Element getCurrentElement() {
        if (this.isElement()) {
            return this.getElement();
        }
        return null;
    }

    public Attribute getCurrentAttribute() {
        if (this.isAttribute()) {
            return this.getAttribute();
        }
        return null;
    }

    public boolean currentNodeExists() {
        return this.hasElement() || this.hasAttribute();
    }

    public Object getCurrentNode() {
        if (this.isElement()) {
            return this.getElement();
        }
        if (this.isAttribute()) {
            return this.getAttribute();
        }
        return null;
    }

    public String getCurrentNodeValue() {
        if (this.isElement()) {
            return this.getElement().getText();
        }
        if (this.isAttribute()) {
            return this.getAttribute().getValue();
        }
        return null;
    }

    public void setCurrentNodeValue(String value) {
        if (this.isElement()) {
            this.getElement().setText(value);
        }
        if (this.isAttribute()) {
            this.getAttribute().setValue(value);
        }
    }

    public boolean hasCurrentNodeValue() {
        String value = this.getCurrentNodeValue();
        return null != value && !value.trim().isEmpty();
    }

    public boolean isCurrentElementRoot() {
        if (!this.isElement()) {
            return false;
        }
        return this.getCurrentElement().isRootElement();
    }

    public void gotoRoot() {
        if (null != this.getStartingElement()) {
            this.eraseAll();
            this.setElement(this.getStartingElement().getDocument().getRootElement());
            this.syncIElementsWithElementAndName();
        }
    }

    public void returnToStartingElement() {
        this.returnToStartingState();
    }

    public void setCurrentElementAsStartingElement() {
        this.removeAllStates();
        if (this.hasElement()) {
            this._startingElement = this.getElement();
            this.setCurrentElementAsCousinsAncestor();
        } else {
            this.eraseAll();
            this._startingElement = null;
        }
        this.pushState();
    }

    public void setNameFromCurrentElement() {
        if (this.hasElement()) {
            this.setName(this.getElement().getName());
            this.syncIElementsWithElementAndName();
        }
    }

    public boolean hasParent() {
        return this.isElement() && !this.isCurrentElementRoot();
    }

    public void gotoParent() {
        if (this.hasParent()) {
            this.eraseName();
            if (this.isElementCousinsAncestor()) {
                this.setParentCousinsAncestor();
            }
            this.setElement(this.getCurrentElement().getParentElement());
            this.syncIElementsWithElementAndName();
        } else {
            this.eraseAll();
        }
    }

    public boolean hasNextSibling() {
        if (this.hasIElements()) {
            return this.getIElements().hasNext();
        }
        return false;
    }

    public void gotoNextSibling() {
        boolean changeCousinsAncestor = this.isElementCousinsAncestor();
        this.setNextIElementsAsElement();
        if (changeCousinsAncestor && this.hasElement()) {
            this.setCousinsAncestor(this.getElement());
        }
    }

    /*
     * Unable to fully structure code
     */
    private List getNamedChildren() {
        block13: {
            block12: {
                if (!this.isElement()) {
                    return null;
                }
                children = null;
                if (!this.hasName()) break block12;
                children = this.getCurrentElement().getChildren(this.getName());
                switch (this.getMode()) {
                    case 'S': {
                        break;
                    }
                    case '1': {
                        if (children.isEmpty()) ** GOTO lbl23
                        if (1 < children.size()) {
                            i = children.iterator();
                            passedFirst = false;
                            while (i.hasNext()) {
                                e = (Element)i.next();
                                if (passedFirst) {
                                    this.getCurrentElement().removeContent((Content)e);
                                    continue;
                                }
                                passedFirst = true;
                            }
                        }
                        break block13;
                    }
lbl23:
                    // 2 sources

                    case 'U': {
                        if (!children.isEmpty()) break;
                    }
                    case 'I': {
                        children.add(new Element(this.getName()));
                        break;
                    }
                    case 'D': {
                        this.getCurrentElement().removeChildren(this.getName());
                        children.clear();
                        break;
                    }
                }
                break block13;
            }
            children = this.getCurrentElement().getChildren();
        }
        if (children.isEmpty()) {
            return null;
        }
        return children;
    }

    private void setFirstNamedChild() {
        List children = this.getNamedChildren();
        if (null == children) {
            this.eraseAll();
        } else {
            this.setElement((Element)children.iterator().next());
            this.syncIElementsWithElementAndName();
        }
    }

    public boolean hasChildren() {
        if (this.isElement()) {
            return this.getCurrentElement().getChildren().isEmpty();
        }
        return false;
    }

    public boolean hasChildren(String name) {
        if (this.hasChildren()) {
            List children = this.getElement().getChildren(name);
            return null != children && !children.isEmpty();
        }
        return false;
    }

    public void gotoFirstChild() {
        this.eraseName();
        this.setFirstNamedChild();
    }

    public void gotoFirstChild(String name) {
        this.setName(name);
        this.setFirstNamedChild();
    }

    public void gotoAttribute(String name) {
        if (this.isElement()) {
            Attribute a = this.getCurrentElement().getAttribute(name);
            switch (this.getMode()) {
                case 'S': {
                    break;
                }
                case '1': 
                case 'I': 
                case 'U': {
                    if (null != a) break;
                    a = new Attribute(name, "PLEASE GIVE ME A VALUE");
                    this.getCurrentElement().setAttribute(a);
                    break;
                }
                case 'D': {
                    if (null == a) break;
                    this.getCurrentElement().removeAttribute(name);
                    a = null;
                }
            }
            if (null == a) {
                this.eraseAll();
            } else {
                this.eraseName();
                this.eraseIElements();
                this.eraseElement();
                this.setAttribute(a);
            }
        } else {
            this.eraseAll();
        }
    }

    public void gotoFirstChildNode(char nodeType, String nodeName) {
        switch (nodeType) {
            case 'A': {
                this.gotoAttribute(nodeName);
                break;
            }
            case 'E': {
                this.gotoFirstChild(nodeName);
                break;
            }
            default: {
                this.eraseAll();
            }
        }
    }

    public void gotoNextSiblingNode() {
        if (this.isElement()) {
            this.gotoNextSibling();
        } else {
            this.eraseAll();
        }
    }

    public boolean hasNextSiblingNode() {
        char bakMode = this.getMode();
        this.pushState();
        this.gotoNextSiblingNode();
        boolean found = this.currentNodeExists();
        this.popState();
        this.setMode(bakMode);
        return found;
    }

    public void pushState() {
        if (null == this._stateStack) {
            this._stateStack = new LinkedList();
        }
        this._stateStack.addFirst(new Object[]{this.getAttribute(), this.getElement(), this.getName(), this.getStartingElement(), this.getCousinsAncestor()});
    }

    public void popState() {
        if (null != this._stateStack && 1 <= this._stateStack.size()) {
            this.setAttribute((Attribute)((Object[])this._stateStack.getFirst())[0]);
            this.setElement((Element)((Object[])this._stateStack.getFirst())[1]);
            this.setName((String)((Object[])this._stateStack.getFirst())[2]);
            this.syncIElementsWithElementAndName();
            this._startingElement = (Element)((Object[])this._stateStack.getFirst())[3];
            this.setCousinsAncestor((Element)((Object[])this._stateStack.getFirst())[4]);
            this._stateStack.removeFirst();
        }
    }

    private void removeAllStates() {
        if (null != this._stateStack && 0 < this._stateStack.size()) {
            while (1 <= this._stateStack.size()) {
                this._stateStack.removeFirst();
            }
        }
    }

    private void returnToStartingState() {
        if (null != this._stateStack && 0 < this._stateStack.size()) {
            while (1 < this._stateStack.size()) {
                this._stateStack.removeFirst();
            }
            this.popState();
            this.pushState();
        }
    }

    public void setCurrentElementAsCousinsAncestor() {
        this.setElementCousinsAncestor();
    }

    public void gotoNextCousin() {
        if (this.hasElement() && this.hasName()) {
            switch (this.getMode()) {
                case 'U': {
                    if (this.hasNextCousin()) {
                        this.setMode('S');
                        this.gotoNextCousin();
                        this.setMode('U');
                        break;
                    }
                }
                case 'I': {
                    char bakMode = this.getMode();
                    if ('I' == this.getMode()) {
                        this.setMode('S');
                        while (this.hasNextCousin()) {
                            this.gotoNextCousin();
                        }
                        this.setMode(bakMode);
                    }
                    this.gotoNextSibling();
                    break;
                }
                case '1': 
                case 'D': {
                    this.gotoNextSibling();
                    break;
                }
                case 'S': {
                    if (!this.isElement() || this.isCurrentElementRoot() || !this.hasName()) {
                        this.eraseAll();
                        break;
                    }
                    if (this.hasNextSibling()) {
                        this.gotoNextSibling();
                        break;
                    }
                    if (this.isParentCousinsAncestor()) {
                        this.eraseAll();
                        break;
                    }
                    boolean changeCousinsAncestor = this.isElementCousinsAncestor();
                    String cousinName = this.getName();
                    this.setElement(this.getElement().getParentElement());
                    this.setName(this.getElement().getName());
                    this.syncIElementsWithElementAndName();
                    this.gotoNextCousin();
                    if (this.hasElement()) {
                        this.gotoFirstChild(cousinName);
                        if (!this.hasElement() || !changeCousinsAncestor) break;
                        this.setCousinsAncestor(this.getElement());
                        break;
                    }
                    this.eraseAll();
                }
            }
        } else {
            this.eraseAll();
        }
    }

    public boolean hasNextCousin() {
        boolean found;
        if (this.hasElement() && this.hasName()) {
            this.pushState();
            char bakMode = this.getMode();
            this.setMode('S');
            this.gotoNextCousin();
            this.setMode(bakMode);
            found = this.currentNodeExists();
            this.popState();
        } else {
            found = false;
        }
        return found;
    }

    public boolean isParentOf(char nodeType, String nodeName, String nodeValue) {
        boolean found = false;
        if (this.hasElement()) {
            this.pushState();
            char bakMode = this.getMode();
            this.setMode('S');
            this.gotoFirstChildNode(nodeType, nodeName);
            found = this.currentNodeExists();
            if (null != nodeValue) {
                if (found) {
                    boolean bl = found = null != this.getCurrentNodeValue();
                }
                if (found) {
                    found = this.getCurrentNodeValue().trim().equals(nodeValue);
                }
            }
            while (!found && this.hasNextSiblingNode()) {
                this.gotoNextSiblingNode();
                found = this.currentNodeExists();
                if (null == nodeValue) continue;
                if (found) {
                    boolean bl = found = null != this.getCurrentNodeValue();
                }
                if (!found) continue;
                found = this.getCurrentNodeValue().trim().equals(nodeValue);
            }
            this.setMode(bakMode);
            this.popState();
        }
        return found;
    }

    public boolean isParentOf(char nodeType, String nodeName) {
        return this.isParentOf(nodeType, nodeName, null);
    }

    public void gotoFirstNephewNode(char nodeType, String nodeName) {
        if (this.hasElement()) {
            boolean found = false;
            char bakMode = this.getMode();
            found = this.isParentOf(nodeType, nodeName);
            if (!found) {
                this.setMode('S');
                while (!found && this.hasNextCousin()) {
                    this.gotoNextCousin();
                    found = this.isParentOf(nodeType, nodeName);
                }
                this.setMode(bakMode);
            }
            this.gotoFirstChildNode(nodeType, nodeName);
        } else {
            this.eraseAll();
        }
    }

    public void gotoFirstNephewParentOf(String nephewName, char nodeType, String nodeName, String nodeValue) {
        if (this.hasElement()) {
            boolean found;
            char bakMode = this.getMode();
            this.setMode('S');
            this.pushState();
            this.gotoFirstNephewNode('E', nephewName);
            boolean nephewExists = this.currentNodeExists();
            this.popState();
            if (nephewExists) {
                this.gotoFirstNephewNode('E', nephewName);
                found = this.isParentOf(nodeType, nodeName, nodeValue);
                while (!found && this.hasNextCousin()) {
                    this.gotoNextCousin();
                    found = this.isParentOf(nodeType, nodeName, nodeValue);
                }
            } else {
                found = false;
            }
            this.setMode(bakMode);
            switch (this.getMode()) {
                case 'D': {
                    if (nephewExists && found && this.hasParent()) {
                        Element e = this.getCurrentElement();
                        this.gotoParent();
                        this.getCurrentElement().removeContent((Content)e);
                    }
                    this.eraseAll();
                    break;
                }
                case '1': {
                    Element e;
                    if (!nephewExists) {
                        this.gotoFirstChild(nephewName);
                    } else if (!found) {
                        this.setMode('S');
                        while (this.hasNextSiblingNode()) {
                            this.gotoNextSiblingNode();
                        }
                        this.setMode(bakMode);
                        this.gotoNextSiblingNode();
                    }
                    if (!found) {
                        this.pushState();
                        this.gotoFirstChildNode(nodeType, nodeName);
                        if (null != nodeValue) {
                            this.setCurrentNodeValue(nodeValue);
                        }
                        this.popState();
                    }
                    if (1 >= (e = this.getCurrentElement()).getParentElement().getChildren(this.getName()).size()) break;
                    this.pushState();
                    String uniqname = this.getName();
                    this.gotoParent();
                    this.getCurrentElement().removeChildren(uniqname);
                    this.getCurrentElement().addContent((Content)e);
                    this.popState();
                    break;
                }
                case 'S': {
                    if (found) break;
                    this.eraseAll();
                    break;
                }
                case 'U': {
                    if (found) break;
                }
                case 'I': {
                    if (!nephewExists) {
                        this.gotoFirstChild(nephewName);
                    }
                    if (found) {
                        this.setMode('S');
                        while (this.hasNextCousin()) {
                            this.gotoNextCousin();
                        }
                        this.setMode(bakMode);
                    }
                    if (nephewExists) {
                        this.gotoNextCousin();
                    }
                    this.pushState();
                    this.gotoFirstChildNode(nodeType, nodeName);
                    if (null != nodeValue) {
                        this.setCurrentNodeValue(nodeValue);
                    }
                    this.popState();
                }
            }
        } else {
            this.eraseAll();
        }
    }

    public void gotoNextCousinParentOf(char nodeType, String nodeName, String nodeValue) {
        if (this.hasElement() && this.hasName()) {
            char bakMode = this.getMode();
            this.setMode('S');
            boolean found = false;
            while (!found && this.hasNextCousin()) {
                this.gotoNextCousin();
                found = this.isParentOf(nodeType, nodeName, nodeValue);
            }
            this.setMode(bakMode);
            switch (this.getMode()) {
                case 'D': {
                    if (found && this.hasParent()) {
                        Element e = this.getCurrentElement();
                        this.gotoParent();
                        this.getCurrentElement().removeContent((Content)e);
                    }
                    this.eraseAll();
                    break;
                }
                case '1': {
                    Element e;
                    if (!found) {
                        this.gotoNextSiblingNode();
                        this.pushState();
                        this.gotoFirstChildNode(nodeType, nodeName);
                        if (null != nodeValue) {
                            this.setCurrentNodeValue(nodeValue);
                        }
                        this.popState();
                    }
                    if (1 >= (e = this.getCurrentElement()).getParentElement().getChildren(this.getName()).size()) break;
                    this.pushState();
                    String uniqname = this.getName();
                    this.gotoParent();
                    this.getCurrentElement().removeChildren(uniqname);
                    this.getCurrentElement().addContent((Content)e);
                    this.popState();
                    break;
                }
                case 'S': {
                    if (found) break;
                    this.eraseAll();
                    break;
                }
                case 'U': {
                    if (found) break;
                }
                case 'I': {
                    if (found) {
                        this.setMode('S');
                        while (this.hasNextCousin()) {
                            this.gotoNextCousin();
                        }
                        this.setMode(bakMode);
                    }
                    this.gotoNextCousin();
                    this.pushState();
                    this.gotoFirstChildNode(nodeType, nodeName);
                    if (null != nodeValue) {
                        this.setCurrentNodeValue(nodeValue);
                    }
                    this.popState();
                }
            }
        } else {
            this.eraseAll();
        }
    }

    public void gotoNextCousinParentOf(char nodeType, String nodeName) {
        this.gotoNextCousinParentOf(nodeType, nodeName, null);
    }

    public boolean hasNextCousinParentOf(char nodeType, String nodeName, String nodeValue) {
        boolean found;
        if (this.hasElement()) {
            this.pushState();
            char bakMode = this.getMode();
            this.setMode('S');
            this.gotoNextCousinParentOf(nodeType, nodeName, nodeValue);
            this.setMode(bakMode);
            found = this.currentNodeExists();
            this.popState();
        } else {
            found = false;
        }
        return found;
    }

    public boolean hasNextCousinParentOf(char nodeType, String nodeName) {
        return this.hasNextCousinParentOf(nodeType, nodeName, null);
    }
}

