/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.xml.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.silverpeas.settings.SilverpeasSettings;
import org.silverpeas.util.GestionVariables;
import org.silverpeas.util.xml.transform.Parameter;
import org.silverpeas.util.xml.transform.Value;

public class XmlConfiguration {
    private String fileName;
    private List<Parameter> parameters;

    public XmlConfiguration(String dir, Element eltConfigFile, GestionVariables gv) throws IOException {
        this.fileName = gv.resolveAndEvalString(dir + eltConfigFile.getAttributeValue("name"));
        this.parameters = new ArrayList<Parameter>();
        List eltParameters = eltConfigFile.getChildren("parameter");
        for (Element eltParameter : eltParameters) {
            Parameter parameter = new Parameter(gv.resolveAndEvalString(eltParameter.getAttributeValue("key")), SilverpeasSettings.getXmlMode(eltParameter.getAttributeValue("mode")));
            if (eltParameter.getChildren() != null && !eltParameter.getChildren().isEmpty()) {
                List eltValues = eltParameter.getChildren("value");
                if (eltValues == null || eltValues.isEmpty()) {
                    parameter.addValue(new Value(null, null, gv.resolveAndEvalString(eltParameter.getTextTrim()), parameter.getMode()));
                } else {
                    for (Element eltValue : eltValues) {
                        String location;
                        String relativePath = eltValue.getAttributeValue("relative-to");
                        if (relativePath != null && !relativePath.isEmpty()) {
                            relativePath = gv.resolveAndEvalString(relativePath);
                        }
                        if ((location = eltValue.getAttributeValue("location")) != null && !location.isEmpty()) {
                            location = gv.resolveAndEvalString(location);
                        }
                        parameter.addValue(new Value(location, relativePath, gv.resolveAndEvalString(eltValue.getTextTrim()), parameter.getMode()));
                    }
                }
            } else {
                parameter.addValue(new Value(null, null, gv.resolveAndEvalString(eltParameter.getTextTrim()), parameter.getMode()));
            }
            this.parameters.add(parameter);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }
}

