/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.xml.xpath;

import java.util.Arrays;

public class XPathParseException
extends Exception {
    private Integer _errorIndex = null;
    private String _indexedErrorMsg = null;

    public XPathParseException() {
    }

    public XPathParseException(String msg) {
        super(msg);
    }

    public XPathParseException(String msg, String xpathStr, int errorIndex) {
        super(msg + " at column " + errorIndex);
        this._errorIndex = errorIndex;
        this._indexedErrorMsg = xpathStr + '\n';
        char[] padding = new char[errorIndex - 1];
        Arrays.fill(padding, '-');
        this._indexedErrorMsg = this._indexedErrorMsg + new String(padding) + '^';
    }

    public XPathParseException(String msg, String xpathStr, int errorIndex, Throwable cause) {
        super(msg + " at column " + errorIndex, cause);
        this._errorIndex = errorIndex;
        this._indexedErrorMsg = xpathStr + '\n';
        char[] padding = new char[errorIndex - 1];
        Arrays.fill(padding, '-');
        this._indexedErrorMsg = this._indexedErrorMsg + new String(padding) + '^';
    }

    public Integer getErrorIndex() {
        return this._errorIndex;
    }

    public String getErrorLocationMessage() {
        return this._indexedErrorMsg;
    }

    @Override
    public String getMessage() {
        String msg = "";
        if (super.getMessage() != null) {
            msg = msg + super.getMessage();
        }
        if (this.getErrorLocationMessage() != null) {
            msg = msg + '\n' + this.getErrorLocationMessage();
        }
        return msg.isEmpty() ? null : msg;
    }
}

