/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.xml.xpath;

import java.util.Arrays;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.silverpeas.util.xml.xpath.XPathParseException;

public class XPathTokenizer {
    private String _xpath = null;
    public static final char STEP_SEPARATOR = '/';
    public static final char PREDICATE_OPEN = '[';
    public static final char PREDICATE_CLOSE = ']';
    public static final char EQUALITY = '=';
    public static final char DOT = '.';
    public static final char ABREV_ATTRIBAXIS = '@';
    public static final char PARENT_STEP = 'P';
    public static final char LITERAL = 'L';
    public static final char INTEGER = 'I';
    public static final char REAL = 'R';
    public static final char NAME = 'N';
    public static final char END_OF_XPATH = 'E';
    public static final char UNDEFINED = 'U';
    private static final char LITERAL_DELIM_SINGLE = '\'';
    private static final char LITERAL_DELIM_DOUBLE = '\"';
    private static char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private int _iXpath;
    private int _tokenPosition;
    private String _token = null;
    private char _tokenType = (char)85;

    public XPathTokenizer() {
    }

    public XPathTokenizer(String xpath) {
        this.setXPath(xpath);
    }

    public void reinitRead() {
        this.setIndex(0);
        this.setIndexAsPosition();
        this.setCurrentToken(null);
        this.setCurrentTokenType('U');
    }

    public void setXPath(String xpath) {
        this._xpath = xpath;
        this.reinitRead();
    }

    public String getXPath() {
        return this._xpath;
    }

    public String getCurrentToken() {
        return this._token;
    }

    public char getCurrentTokenType() {
        return this._tokenType;
    }

    public int getCurrentTokenPosition() {
        return this._tokenPosition;
    }

    private int getIndex() {
        return this._iXpath;
    }

    private void setIndex(int newIndex) {
        this._iXpath = newIndex;
    }

    private void setCurrentToken(String token) {
        this._token = token;
    }

    private void setCurrentTokenType(char tokenType) {
        this._tokenType = tokenType;
    }

    private void setIndexAsPosition() {
        this._tokenPosition = this.getIndex() + 1;
    }

    public char readNextToken() throws XPathParseException {
        this.setIndexAsPosition();
        this.setCurrentTokenType('U');
        if (this.getXPath() == null) {
            throw new XPathParseException("someone forgot to set my XPath !");
        }
        if (this.getXPath().length() == 0) {
            throw new XPathParseException("please give me a non empty XPath");
        }
        if (this.getIndex() == this.getXPath().length()) {
            this.setCurrentTokenType('E');
            return this._tokenType;
        }
        switch (this.getXPath().charAt(this.getIndex())) {
            case '/': {
                this.setCurrentTokenType('/');
                this.setCurrentToken(null);
                this.setIndex(this.getIndex() + 1);
                break;
            }
            case '.': {
                if (this.getXPath().length() > this.getIndex() + 1 && this.getXPath().charAt(this.getIndex() + 1) == '.') {
                    this.setCurrentTokenType('P');
                    this.setCurrentToken(new String(new char[]{'.', '.'}));
                    this.setIndex(this.getIndex() + 2);
                    break;
                }
                int iStartStepOrNumber = this.getIndex();
                this.setIndex(this.getIndex() + 1);
                if (this.readDigits()) {
                    this.setCurrentTokenType('R');
                    this.setCurrentToken(this.getXPath().substring(iStartStepOrNumber, this.getIndex()));
                    break;
                }
                this.setCurrentToken(null);
                this.setCurrentTokenType('.');
                break;
            }
            case '@': {
                this.setCurrentTokenType('@');
                this.setCurrentToken(null);
                this.setIndex(this.getIndex() + 1);
                break;
            }
            case '[': {
                this.setCurrentTokenType('[');
                this.setCurrentToken(null);
                this.setIndex(this.getIndex() + 1);
                break;
            }
            case ']': {
                this.setCurrentTokenType(']');
                this.setCurrentToken(null);
                this.setIndex(this.getIndex() + 1);
                break;
            }
            case '=': {
                this.setCurrentTokenType('=');
                this.setCurrentToken(null);
                this.setIndex(this.getIndex() + 1);
                break;
            }
            case '\'': {
                this.setIndex(this.getIndex() + 1);
                int iDelimSingle = this.getXPath().indexOf(39, this.getIndex());
                if (iDelimSingle == -1) {
                    throw new XPathParseException("literal not closed", this.getXPath(), this.getIndex());
                }
                this.setCurrentTokenType('L');
                this.setCurrentToken(this.getXPath().substring(this.getIndex(), iDelimSingle));
                this.setIndex(iDelimSingle + 1);
                break;
            }
            case '\"': {
                this.setIndex(this.getIndex() + 1);
                int iDelimDouble = this.getXPath().indexOf(34, this.getIndex());
                if (iDelimDouble == -1) {
                    throw new XPathParseException("literal not closed", this.getXPath(), this.getIndex());
                }
                this.setCurrentTokenType('L');
                this.setCurrentToken(this.getXPath().substring(this.getIndex(), iDelimDouble));
                this.setIndex(iDelimDouble + 1);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.setCurrentTokenType('I');
                int iStartNumber = this.getIndex();
                this.readDigits();
                if (this.getIndex() < this.getXPath().length() && this.getXPath().charAt(this.getIndex()) == '.') {
                    this.setCurrentTokenType('R');
                    this.setIndex(this.getIndex() + 1);
                    this.readDigits();
                }
                this.setCurrentToken(this.getXPath().substring(iStartNumber, this.getIndex()));
                break;
            }
            default: {
                int iStartName = this.getIndex();
                boolean nameFound = false;
                this.setIndex(this.getIndex() + 1);
                try {
                    while (this.getIndex() <= this.getXPath().length() && this.isValidName(this.getXPath().substring(iStartName, this.getIndex()))) {
                        nameFound = true;
                        this.setIndex(this.getIndex() + 1);
                    }
                }
                catch (RuntimeException re) {
                    throw new XPathParseException("unauthorised char in XML name", this.getXPath(), this.getIndex(), re);
                }
                if (nameFound) {
                    this.setCurrentTokenType('N');
                    this.setIndex(this.getIndex() - 1);
                    this.setCurrentToken(this.getXPath().substring(iStartName, this.getIndex()));
                    break;
                }
                throw new XPathParseException("unauthorised char", this.getXPath(), iStartName + 1);
            }
        }
        return this.getCurrentTokenType();
    }

    private boolean readDigits() {
        boolean found = false;
        while (this.getIndex() < this.getXPath().length() && Arrays.binarySearch(DIGITS, this.getXPath().charAt(this.getIndex())) >= 0) {
            found = true;
            this.setIndex(this.getIndex() + 1);
        }
        return found;
    }

    protected boolean isValidName(String name) {
        try {
            new Element(name);
            return true;
        }
        catch (IllegalNameException e) {
            return false;
        }
    }

    static {
        Arrays.sort(DIGITS);
    }
}

