/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.converter.openoffice;

import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.openoffice.ExtendedDocumentFormatRegistry;
import com.silverpeas.converter.option.FilterOption;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilverpeasOpenOfficeDocumentConverter
extends OpenOfficeDocumentConverter {
    private static final Logger logger = LoggerFactory.getLogger(SilverpeasOpenOfficeDocumentConverter.class);
    private final List<FilterOption> filterData = new ArrayList<FilterOption>();

    public SilverpeasOpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection, (DocumentFormatRegistry)new ExtendedDocumentFormatRegistry());
    }

    public void addFilterData(FilterOption option) {
        this.filterData.add(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertInternal(File inputFile, com.artofsolving.jodconverter.DocumentFormat inputFormat, File outputFile, com.artofsolving.jodconverter.DocumentFormat outputFormat) {
        HashMap<String, Object> loadProperties = new HashMap<String, Object>();
        loadProperties.putAll(this.getDefaultLoadProperties());
        loadProperties.putAll(inputFormat.getImportOptions());
        Map storeProperties = outputFormat.getExportOptions(inputFormat.getFamily());
        if (!this.filterData.isEmpty()) {
            ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
            for (FilterOption option : this.filterData) {
                propertyValues.add(SilverpeasOpenOfficeDocumentConverter.property((String)option.getName(), (Object)option.getValue()));
            }
            loadProperties.put("FilterData", propertyValues.toArray(new PropertyValue[0]));
            storeProperties.put("FilterData", propertyValues.toArray(new PropertyValue[0]));
        }
        OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
        synchronized (openOfficeConnection) {
            XFileIdentifierConverter fileContentProvider = this.openOfficeConnection.getFileContentProvider();
            String inputUrl = fileContentProvider.getFileURLFromSystemPath("", inputFile.getAbsolutePath());
            String outputUrl = fileContentProvider.getFileURLFromSystemPath("", outputFile.getAbsolutePath());
            this.loadAndExport(inputUrl, loadProperties, outputUrl, storeProperties);
        }
    }

    private void loadAndExport(String inputUrl, Map<String, Object> loadProperties, String outputUrl, Map<String, Object> storeProperties) throws OpenOfficeException {
        XComponent document;
        try {
            document = this.loadDocument(inputUrl, loadProperties);
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new OpenOfficeException("conversion failed: could not load input document; OOo errorCode: " + errorCodeIOException.ErrCode, (Throwable)errorCodeIOException);
        }
        catch (Exception otherException) {
            throw new OpenOfficeException("conversion failed: could not load input document", (Throwable)otherException);
        }
        if (document == null) {
            throw new OpenOfficeException("conversion failed: could not load input document");
        }
        this.refreshDocument(document);
        try {
            this.storeDocument(document, outputUrl, storeProperties);
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new OpenOfficeException("conversion failed: could not save output document; OOo errorCode: " + errorCodeIOException.ErrCode, (Throwable)errorCodeIOException);
        }
        catch (Exception otherException) {
            throw new OpenOfficeException("conversion failed: could not save output document", (Throwable)otherException);
        }
    }

    private XComponent loadDocument(String inputUrl, Map<String, Object> loadProperties) throws IOException, IllegalArgumentException {
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        return desktop.loadComponentFromURL(inputUrl, "_blank", 0, SilverpeasOpenOfficeDocumentConverter.toPropertyValues(loadProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDocument(XComponent document, String outputUrl, Map<String, Object> storeProperties) throws IOException {
        try {
            XStorable storable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)document);
            storable.storeToURL(outputUrl, SilverpeasOpenOfficeDocumentConverter.toPropertyValues(storeProperties));
        }
        finally {
            XCloseable closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)document);
            if (closeable != null) {
                try {
                    closeable.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    logger.warn("document.close() vetoed");
                }
            } else {
                document.dispose();
            }
        }
    }

    public void convert(InputStream source, DocumentFormat inFormat, OutputStream destination, DocumentFormat outFormat, FilterOption ... options) {
        this.convert(source, this.getDocumentFormat(inFormat), destination, this.getDocumentFormat(outFormat));
    }

    private com.artofsolving.jodconverter.DocumentFormat getDocumentFormat(DocumentFormat documentFormat) {
        String mimeType = documentFormat.getMimeType();
        com.artofsolving.jodconverter.DocumentFormat format = this.getDocumentFormatRegistry().getFormatByMimeType(mimeType);
        if (format == null) {
            if ("application/rtf".equals(mimeType)) {
                mimeType = mimeType.replaceFirst("application", "text");
            }
            format = this.getDocumentFormatRegistry().getFormatByMimeType(mimeType);
        }
        if (format == null) {
            throw new java.lang.IllegalArgumentException("unknown document format for MIME-TYPE: " + documentFormat.getMimeType());
        }
        return format;
    }
}

