/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.silverpeas.form.AbstractField;
import com.silverpeas.form.Field;
import com.silverpeas.form.FormException;

public abstract class TextField
extends AbstractField {
    private static final long serialVersionUID = 983277921021971664L;
    public static final String TYPE = "text";
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_TYPE_INT = "int";
    public static final String CONTENT_TYPE_FLOAT = "float";
    public static final String PARAM_MAXLENGTH = "maxLength";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public abstract boolean isReadOnly();

    @Override
    public String getValue() {
        return this.getStringValue();
    }

    @Override
    public String getValue(String language) {
        return this.getStringValue();
    }

    @Override
    public void setValue(String value) throws FormException {
        this.setStringValue(value);
    }

    @Override
    public void setValue(String value, String language) throws FormException {
        this.setStringValue(value);
    }

    @Override
    public boolean acceptValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return !this.isReadOnly();
    }

    @Override
    public Object getObjectValue() {
        return this.getStringValue();
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof String) {
            this.setStringValue((String)value);
        } else {
            if (value != null) {
                throw new FormException("TextField.setObjectValue", "form.EXP_NOT_A_STRING");
            }
            this.setNull();
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        if (value instanceof String) {
            return !this.isReadOnly();
        }
        return false;
    }

    @Override
    public boolean isNull() {
        return this.getStringValue() == null || this.getStringValue().trim().equals("");
    }

    @Override
    public void setNull() throws FormException {
        this.setStringValue(null);
    }

    public boolean equals(Object o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof TextField) {
            String t = ((TextField)o).getStringValue();
            if (t == null) {
                t = "";
            }
            return s.equalsIgnoreCase(t);
        }
        if (o instanceof Field) {
            String t = ((Field)o).getValue("");
            if (t == null) {
                t = "";
            }
            return s.equalsIgnoreCase(t);
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof TextField) {
            String t = ((TextField)o).getStringValue();
            if (t == null) {
                t = "";
            }
            return s.compareTo(t);
        }
        if (o instanceof Field) {
            String t = ((Field)o).getValue("");
            if (t == null) {
                t = "";
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getStringValue();
        return ("" + s).toLowerCase().hashCode();
    }
}

