/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.importExport;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.importExport.XMLField;
import com.silverpeas.form.importExport.XMLModelContentType;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;

public class FormTemplateImportExport {
    public void importXMLModelContentType(ForeignPK pk, String objectType, XMLModelContentType xmlModel, String userId) throws Exception {
        String externalId = pk.getInstanceId() + ":" + xmlModel.getName();
        if (StringUtil.isDefined(objectType)) {
            externalId = pk.getInstanceId() + ":" + objectType + ":" + xmlModel.getName();
        }
        PublicationTemplateManager.getInstance().addDynamicPublicationTemplate(externalId, xmlModel.getName());
        PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(externalId);
        RecordSet set = pub.getRecordSet();
        DataRecord data = set.getRecord(pk.getId());
        if (data == null) {
            data = set.getEmptyRecord();
            data.setId(pk.getId());
        }
        List<XMLField> xmlFields = xmlModel.getFields();
        for (XMLField xmlField : xmlFields) {
            FieldTemplate fieldTemplate;
            String xmlFieldName = xmlField.getName();
            String xmlFieldValue = xmlField.getValue();
            Field field = data.getField(xmlFieldName);
            if (field == null || (fieldTemplate = pub.getRecordTemplate().getFieldTemplate(xmlFieldName)) == null) continue;
            FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(field.getTypeName(), fieldTemplate.getDisplayerName());
            String fieldValue = "file".equals(field.getTypeName()) ? this.manageFileField(pk, userId, xmlFieldValue, fieldTemplate) : xmlFieldValue;
            fieldDisplayer.update(fieldValue, field, fieldTemplate, new PagesContext());
        }
        set.save(data);
    }

    public String manageFileField(ForeignPK pk, String userId, String xmlFieldValue, FieldTemplate fieldTemplate) throws IOException {
        String fieldValue;
        DocumentType type = "image".equals(fieldTemplate.getDisplayerName()) ? DocumentType.attachment : DocumentType.form;
        File image = new File(xmlFieldValue);
        if (image.length() > 0L) {
            String fileName = FileUtil.getFilename(xmlFieldValue);
            SimpleDocument document = new SimpleDocument(new SimpleDocumentPK(null, pk.getInstanceId()), pk.getId(), 0, false, new SimpleAttachment(fileName, I18NHelper.defaultLanguage, fileName, "", image.length(), FileUtil.getMimeType(fileName), userId, new Date(), null));
            document.setDocumentType(type);
            fieldValue = AttachmentServiceFactory.getAttachmentService().createAttachment(document, image, true).getId();
        } else {
            fieldValue = null;
        }
        return fieldValue;
    }
}

