/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.builder;

import com.silverpeas.notification.builder.AbstractResourceUserNotificationBuilder;
import com.silverpeas.notification.builder.DefaultUserNotification;
import com.silverpeas.notification.builder.UserNotification;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.Link;

public abstract class AbstractTemplateUserNotificationBuilder<T>
extends AbstractResourceUserNotificationBuilder<T> {
    private final Map<String, SilverpeasTemplate> templates = new HashMap<String, SilverpeasTemplate>();

    public AbstractTemplateUserNotificationBuilder(T resource) {
        super(resource, null, null);
    }

    public AbstractTemplateUserNotificationBuilder(T resource, String fileName) {
        super(resource, null, fileName);
    }

    public AbstractTemplateUserNotificationBuilder(T resource, String title, String fileName) {
        super(resource, title, fileName);
    }

    protected abstract String getBundleSubjectKey();

    @Override
    protected String getTitle() {
        if (StringUtils.isBlank((CharSequence)this.getBundleSubjectKey())) {
            return super.getTitle();
        }
        return this.getBundle().getString(this.getBundleSubjectKey());
    }

    protected String getFileName() {
        return this.getContent();
    }

    @Override
    protected UserNotification createNotification() {
        return new DefaultUserNotification(this.getTitle(), this.templates, this.getFileName());
    }

    @Override
    protected final void performBuild(T resource) {
        this.templates.clear();
        this.perform(resource);
        NotificationResourceData nRDBase = this.initializeNotificationResourceData();
        for (String curLanguage : DisplayI18NHelper.getLanguages()) {
            String linkUrl = this.getResourceURL(resource);
            String linkLabel = "";
            if (this.getContributionAccessLinkLabelBundleKey() != null) {
                linkLabel = this.getBundle(curLanguage).getString(this.getContributionAccessLinkLabelBundleKey(), "");
            }
            Link link = new Link(linkUrl, linkLabel);
            this.getNotificationMetaData().setLink(link, curLanguage);
            SilverpeasTemplate template = this.createTemplate();
            template.setAttribute("silverpeasURL", linkUrl);
            this.templates.put(curLanguage, template);
            this.performTemplateData(curLanguage, resource, template);
            NotificationResourceData notificationResourceData = nRDBase.clone();
            this.performNotificationResource(curLanguage, resource, notificationResourceData);
            this.getNotificationMetaData().setNotificationResourceData(curLanguage, notificationResourceData);
        }
    }

    @Override
    protected final void performNotificationResource(T resource) {
    }

    @Override
    protected final void performNotificationResource(T resource, NotificationResourceData notificationResourceData) {
    }

    protected SilverpeasTemplate createTemplate() {
        SilverpeasTemplate template = OrganisationControllerFactory.getOrganisationController().isComponentExist(this.getComponentInstanceId()) || OrganisationControllerFactory.getOrganisationController().isToolAvailable(this.getComponentInstanceId()) ? SilverpeasTemplateFactory.createSilverpeasTemplateOnComponents(this.getTemplatePath()) : SilverpeasTemplateFactory.createSilverpeasTemplateOnCore(this.getTemplatePath());
        return template;
    }

    protected void perform(T resource) {
    }

    protected abstract void performTemplateData(String var1, T var2, SilverpeasTemplate var3);

    protected abstract void performNotificationResource(String var1, T var2, NotificationResourceData var3);

    protected abstract String getTemplatePath();

    protected String getContributionAccessLinkLabelBundleKey() {
        return null;
    }
}

