/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.builder;

import com.silverpeas.notification.builder.DefaultUserNotification;
import com.silverpeas.notification.builder.NullUserNotification;
import com.silverpeas.notification.builder.UserNotification;
import com.silverpeas.notification.builder.UserNotificationBuilder;
import com.silverpeas.notification.builder.UserSubscriptionNotificationBehavior;
import com.silverpeas.notification.builder.UserSubscriptionNotificationSendingHandler;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.notificationManager.ExternalRecipient;
import com.stratelia.silverpeas.notificationManager.GroupRecipient;
import com.stratelia.silverpeas.notificationManager.NotificationManagerSettings;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.notificationManager.constant.NotifMessageType;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUserNotificationBuilder
implements UserNotificationBuilder {
    private String title = null;
    private String content = null;
    private UserNotification userNotification = null;
    private final Map<String, ResourceLocator> bundles = new HashMap<String, ResourceLocator>();

    protected AbstractUserNotificationBuilder() {
    }

    protected AbstractUserNotificationBuilder(String title, String content) {
        this();
        this.title = title;
        this.content = content;
    }

    protected void initialize() {
        this.userNotification = this.createNotification();
        this.getNotificationMetaData().setMessageType(this.getMessageType().getId());
        this.getNotificationMetaData().setAction(this.getAction());
        this.getNotificationMetaData().setComponentId(this.getComponentInstanceId());
        this.getNotificationMetaData().setSender(this.getSender());
        this.getNotificationMetaData().setSendImmediately(this.isSendImmediatly());
    }

    protected UserNotification createNotification() {
        return new DefaultUserNotification(this.getTitle(), this.getContent());
    }

    protected abstract NotifAction getAction();

    protected abstract String getComponentInstanceId();

    protected abstract String getSender();

    protected final NotificationMetaData getNotificationMetaData() {
        return this.userNotification.getNotificationMetaData();
    }

    protected NotifMessageType getMessageType() {
        return NotifMessageType.NORMAL;
    }

    protected boolean isSendImmediatly() {
        return false;
    }

    @Override
    public final UserNotification build() {
        try {
            if (this instanceof UserSubscriptionNotificationBehavior && !UserSubscriptionNotificationSendingHandler.isEnabledForCurrentRequest() && NotifAction.UPDATE == this.getAction()) {
                this.stop();
            }
            this.initialize();
            this.performUsersToBeNotified();
            this.performBuild();
        }
        catch (Stop e) {
            this.userNotification = new NullUserNotification();
        }
        return this.userNotification;
    }

    protected abstract Collection<String> getUserIdsToNotify();

    protected Collection<String> getUserIdsToExcludeFromNotifying() {
        return null;
    }

    protected Collection<String> getGroupIdsToNotify() {
        return null;
    }

    protected Collection<String> getExternalAddressesToNotify() {
        return null;
    }

    protected final void performUsersToBeNotified() {
        Collection<String> userIdsToNotify = this.getUserIdsToNotify();
        Collection<String> userIdsToExcludeFromNotifying = this.getUserIdsToExcludeFromNotifying();
        Collection<String> groupIdsToNotify = this.getGroupIdsToNotify();
        Collection<String> emailsToNotify = this.getExternalAddressesToNotify();
        if (this.stopWhenNoUserToNotify() && CollectionUtil.isEmpty(userIdsToNotify) && CollectionUtil.isEmpty(groupIdsToNotify) && CollectionUtil.isEmpty(emailsToNotify)) {
            SilverTrace.warn("notification", "IUserNotificationBuider.build()", "IUserNotificationBuider.EX_NO_USER_OR_GROUP_TO_NOTIFY");
            this.stop();
        }
        if (CollectionUtil.isNotEmpty(userIdsToNotify)) {
            for (String userId : userIdsToNotify) {
                this.getNotificationMetaData().addUserRecipient(new UserRecipient(userId));
            }
        }
        if (CollectionUtil.isNotEmpty(userIdsToExcludeFromNotifying)) {
            for (String userId : userIdsToExcludeFromNotifying) {
                this.getNotificationMetaData().addUserRecipientToExclude(new UserRecipient(userId));
            }
        }
        if (this instanceof UserSubscriptionNotificationBehavior && NotificationManagerSettings.isRemoveSenderFromSubscriptionNotificationReceiversEnabled() && StringUtil.isInteger(this.getSender())) {
            this.getNotificationMetaData().addUserRecipientToExclude(new UserRecipient(this.getSender()));
        }
        if (CollectionUtil.isNotEmpty(groupIdsToNotify)) {
            for (String groupId : groupIdsToNotify) {
                this.getNotificationMetaData().addGroupRecipient(new GroupRecipient(groupId));
            }
        }
        if (CollectionUtil.isNotEmpty(emailsToNotify)) {
            for (String address : emailsToNotify) {
                this.getNotificationMetaData().addExternalRecipient(new ExternalRecipient(address));
            }
        }
    }

    protected boolean stopWhenNoUserToNotify() {
        return true;
    }

    protected abstract void performBuild();

    protected String getMultilangPropertyFile() {
        return null;
    }

    protected final ResourceLocator getBundle() {
        return this.getBundle(I18NHelper.defaultLanguage);
    }

    protected final ResourceLocator getBundle(String language) {
        ResourceLocator bundle = this.bundles.get(language);
        if (bundle == null && StringUtils.isNotBlank((CharSequence)this.getMultilangPropertyFile())) {
            bundle = new ResourceLocator(this.getMultilangPropertyFile(), language);
            this.bundles.put(language, bundle);
        }
        return bundle;
    }

    protected String getTitle() {
        return this.title;
    }

    protected String getContent() {
        return this.content;
    }

    protected void stop() {
        throw new Stop();
    }

    private class Stop
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private Stop() {
        }
    }
}

