/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.publicationTemplate;

import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.record.FormEncryptionContentIterator;
import com.silverpeas.form.record.GenericRecordSet;
import com.silverpeas.form.record.GenericRecordSetManager;
import com.silverpeas.form.record.IdentifiedRecordTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateImpl;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.security.ContentEncryptionServiceFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.GlobalContext;
import org.silverpeas.util.crypto.CryptoException;

public class PublicationTemplateManager {
    private static final PublicationTemplateManager instance = new PublicationTemplateManager();
    private final Map<String, PublicationTemplate> externalTemplates = new HashMap<String, PublicationTemplate>();
    private final Map<String, PublicationTemplateImpl> templates = new HashMap<String, PublicationTemplateImpl>();
    public static String templateDir = null;
    public static String defaultTemplateDir = null;
    private static JAXBContext JAXB_CONTEXT = null;

    private PublicationTemplateManager() {
    }

    public static PublicationTemplateManager getInstance() {
        return instance;
    }

    public static String makePath(String dirName, String fileName) {
        if (!StringUtil.isDefined(dirName)) {
            return fileName;
        }
        if (!StringUtil.isDefined(fileName)) {
            return dirName;
        }
        if (dirName.charAt(dirName.length() - 1) == '/' || dirName.charAt(dirName.length() - 1) == '\\') {
            return dirName.replace('\\', '/') + fileName.replace('\\', '/');
        }
        return dirName.replace('\\', '/') + "/" + fileName.replace('\\', '/');
    }

    public GenericRecordSet addDynamicPublicationTemplate(String externalId, String templateFileName) throws PublicationTemplateException {
        String fileName = templateFileName;
        try {
            if (!fileName.endsWith(".xml")) {
                fileName = fileName + ".xml";
            }
            PublicationTemplate thePubTemplate = this.loadPublicationTemplate(fileName);
            RecordTemplate recordTemplate = thePubTemplate.getRecordTemplate();
            return PublicationTemplateManager.getGenericRecordSetManager().createRecordSet(externalId, recordTemplate, fileName, thePubTemplate.isDataEncrypted());
        }
        catch (FormException e) {
            throw new PublicationTemplateException("PublicationTemplateManager.addDynamicPublicationTemplate", "form.EXP_INSERT_FAILED", "externalId=" + externalId + ", templateFileName=" + templateFileName, (Exception)e);
        }
    }

    public PublicationTemplate getPublicationTemplate(String externalId) throws PublicationTemplateException {
        return this.getPublicationTemplate(externalId, null);
    }

    public PublicationTemplate getPublicationTemplate(String externalId, String templateFileName) throws PublicationTemplateException {
        String currentTemplateFileName = templateFileName;
        PublicationTemplate thePubTemplate = this.externalTemplates.get(externalId);
        if (thePubTemplate == null) {
            if (templateFileName == null) {
                try {
                    RecordSet set = PublicationTemplateManager.getGenericRecordSetManager().getRecordSet(externalId);
                    IdentifiedRecordTemplate template = (IdentifiedRecordTemplate)set.getRecordTemplate();
                    currentTemplateFileName = template.getTemplateName();
                }
                catch (Exception e) {
                    throw new PublicationTemplateException("PublicationTemplateManager.getPublicationTemplate", "form.EXP_INSERT_FAILED", "externalId=" + externalId + ", templateFileName=" + templateFileName, e);
                }
            }
            thePubTemplate = this.loadPublicationTemplate(currentTemplateFileName);
            thePubTemplate.setExternalId(externalId);
            this.externalTemplates.put(externalId, thePubTemplate);
        }
        return thePubTemplate;
    }

    public void removePublicationTemplate(String externalId) throws PublicationTemplateException {
        try {
            PublicationTemplateManager.getGenericRecordSetManager().removeRecordSet(externalId);
        }
        catch (FormException e) {
            throw new PublicationTemplateException("PublicationTemplateManager.removePublicationTemplate", "form.EXP_DELETE_FAILED", "externalId=" + externalId, (Exception)e);
        }
    }

    public PublicationTemplate loadPublicationTemplate(String xmlFileName) throws PublicationTemplateException {
        SilverTrace.info("form", "PublicationTemplateManager.loadPublicationTemplate", "root.MSG_GEN_ENTER_METHOD", "xmlFileName=" + xmlFileName);
        try {
            PublicationTemplateImpl publicationTemplate = this.templates.get(xmlFileName);
            if (publicationTemplate != null) {
                return publicationTemplate.basicClone();
            }
            String xmlFilePath = PublicationTemplateManager.makePath(templateDir, xmlFileName);
            File xmlFile = new File(xmlFilePath);
            if (!xmlFile.exists()) {
                xmlFilePath = PublicationTemplateManager.makePath(defaultTemplateDir, xmlFileName);
                xmlFile = new File(xmlFilePath);
            }
            if (!xmlFile.exists()) {
                return null;
            }
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            publicationTemplate = (PublicationTemplateImpl)unmarshaller.unmarshal(xmlFile);
            publicationTemplate.setFileName(xmlFileName);
            this.templates.put(xmlFileName, publicationTemplate);
            return publicationTemplate.basicClone();
        }
        catch (JAXBException e) {
            throw new PublicationTemplateException("PublicationTemplateManager.loadPublicationTemplate", "form.EX_ERR_CASTOR_UNMARSHALL_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)((Object)e));
        }
    }

    public void savePublicationTemplate(PublicationTemplate template) throws PublicationTemplateException, CryptoException {
        boolean encryptionChanged;
        SilverTrace.info("form", "PublicationTemplateManager.savePublicationTemplate", "root.MSG_GEN_ENTER_METHOD", "template = " + template.getFileName());
        String xmlFileName = template.getFileName();
        PublicationTemplate previousTemplate = this.loadPublicationTemplate(xmlFileName);
        boolean bl = encryptionChanged = previousTemplate != null && template.isDataEncrypted() != previousTemplate.isDataEncrypted();
        if (encryptionChanged) {
            if (template.isDataEncrypted()) {
                PublicationTemplateManager.getGenericRecordSetManager().encryptData(xmlFileName);
            } else {
                PublicationTemplateManager.getGenericRecordSetManager().decryptData(xmlFileName);
            }
        }
        try {
            String xmlFilePath = PublicationTemplateManager.makePath(templateDir, xmlFileName);
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)template, new File(xmlFilePath));
        }
        catch (JAXBException e) {
            throw new PublicationTemplateException("PublicationTemplateManager.loadPublicationTemplate", "form.EX_ERR_CASTOR_UNMARSHALL_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)((Object)e));
        }
    }

    public List<PublicationTemplate> getPublicationTemplates(boolean onlyVisibles) throws PublicationTemplateException {
        Collection<File> templateNames;
        ArrayList<PublicationTemplate> publicationTemplates = new ArrayList<PublicationTemplate>();
        try {
            templateNames = FileFolderManager.getAllFile(templateDir);
        }
        catch (UtilException e1) {
            throw new PublicationTemplateException("PublicationTemplateManager.getPublicationTemplates", "form.EX_ERR_CASTOR_LOAD_PUBLICATION_TEMPLATES", e1);
        }
        for (File templateFile : templateNames) {
            String fileName = templateFile.getName();
            try {
                String extension = FileRepositoryManager.getFileExtension(fileName);
                if (!"xml".equalsIgnoreCase(extension)) continue;
                PublicationTemplate template = this.loadPublicationTemplate(fileName.substring(fileName.lastIndexOf(File.separator) + 1, fileName.length()));
                if (onlyVisibles) {
                    if (!template.isVisible()) continue;
                    publicationTemplates.add(template);
                    continue;
                }
                publicationTemplates.add(template);
            }
            catch (Exception e) {
                SilverTrace.error("form", "PublicationTemplateManager.getPublicationTemplates", "form.EX_ERR_CASTOR_LOAD_PUBLICATION_TEMPLATE", "fileName = " + fileName);
            }
        }
        return publicationTemplates;
    }

    public List<PublicationTemplate> getPublicationTemplates() throws PublicationTemplateException {
        return this.getPublicationTemplates(true);
    }

    public List<PublicationTemplate> getPublicationTemplates(GlobalContext globalContext) throws PublicationTemplateException {
        List<PublicationTemplate> theTemplates = this.getPublicationTemplates(true);
        if (globalContext == null) {
            return theTemplates;
        }
        ArrayList<PublicationTemplate> allowedTemplates = new ArrayList<PublicationTemplate>();
        for (PublicationTemplate template : theTemplates) {
            if (!this.isPublicationTemplateVisible(template, globalContext)) continue;
            allowedTemplates.add(template);
        }
        return allowedTemplates;
    }

    public boolean isPublicationTemplateVisible(String templateName, GlobalContext globalContext) throws PublicationTemplateException {
        PublicationTemplate template = this.loadPublicationTemplate(templateName);
        return this.isPublicationTemplateVisible(template, globalContext);
    }

    private boolean isPublicationTemplateVisible(PublicationTemplate template, GlobalContext globalContext) {
        if (!template.isRestrictedVisibility()) {
            return true;
        }
        if (template.isRestrictedVisibilityToInstance()) {
            if (this.isTemplateVisibleAccordingToInstance(template, globalContext)) {
                return true;
            }
        } else {
            OrganisationController oc = OrganisationControllerFactory.getOrganisationController();
            boolean allowed = true;
            if (template.isRestrictedVisibilityToApplication() && !this.isTemplateVisibleAccordingToApplication(template, globalContext, oc)) {
                allowed = false;
            }
            if (allowed) {
                if (!template.isRestrictedVisibilityToSpace()) {
                    return true;
                }
                if (this.isTemplateVisibleAccordingToSpace(template, globalContext, oc)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isTemplateVisibleAccordingToInstance(PublicationTemplate template, GlobalContext context) {
        List<String> restrictedInstanceIds = template.getInstances();
        return restrictedInstanceIds.contains(context.getComponentId());
    }

    private boolean isTemplateVisibleAccordingToApplication(PublicationTemplate template, GlobalContext context, OrganisationController oc) {
        List<String> restrictedApplications = template.getApplications();
        String componentName = context.getComponentName();
        if (StringUtil.isDefined(context.getComponentId())) {
            ComponentInstLight component = oc.getComponentInstLight(context.getComponentId());
            componentName = component.getName();
        }
        return restrictedApplications.contains(componentName);
    }

    private boolean isTemplateVisibleAccordingToSpace(PublicationTemplate template, GlobalContext context, OrganisationController oc) {
        List<String> restrictedSpaceIds = template.getSpaces();
        List<SpaceInst> spacePath = oc.getSpacePath(context.getSpaceId());
        for (SpaceInst space : spacePath) {
            String spaceId = space.getId();
            if (!spaceId.startsWith("WA")) {
                spaceId = "WA" + spaceId;
            }
            if (!restrictedSpaceIds.contains(spaceId)) continue;
            return true;
        }
        return false;
    }

    public List<PublicationTemplate> getSearchablePublicationTemplates() throws PublicationTemplateException {
        ArrayList<PublicationTemplate> searchableTemplates = new ArrayList<PublicationTemplate>();
        List<PublicationTemplate> publicationTemplates = this.getPublicationTemplates();
        for (PublicationTemplate template : publicationTemplates) {
            try {
                if (template.getSearchForm() == null) continue;
                searchableTemplates.add(template);
            }
            catch (PublicationTemplateException e) {
                SilverTrace.warn("form", "PublicationTemplateManager.getSearchablePublicationTemplates", "form.ERROR_ONE_ILL_FORM", template.getName() + " is malformed");
            }
        }
        return searchableTemplates;
    }

    public List<PublicationTemplate> getCryptedPublicationTemplates() throws PublicationTemplateException {
        ArrayList<PublicationTemplate> cryptedTemplates = new ArrayList<PublicationTemplate>();
        List<PublicationTemplate> publicationTemplates = this.getPublicationTemplates();
        for (PublicationTemplate template : publicationTemplates) {
            if (!template.isDataEncrypted()) continue;
            cryptedTemplates.add(template);
        }
        return cryptedTemplates;
    }

    public void removePublicationTemplateFromCaches(String fileName) {
        SilverTrace.info("form", "PublicationTemplateManager.removePublicationTemplateFromCaches", "root.MSG_GEN_ENTER_METHOD", "fileName = " + fileName);
        ArrayList<String> externalIdsToRemove = new ArrayList<String>();
        Collection<PublicationTemplate> publicationTemplates = this.externalTemplates.values();
        for (PublicationTemplate template : publicationTemplates) {
            if (!template.getFileName().equals(fileName)) continue;
            externalIdsToRemove.add(template.getExternalId());
        }
        for (String externalId : externalIdsToRemove) {
            this.externalTemplates.remove(externalId);
        }
        this.templates.remove(fileName);
        PublicationTemplateManager.getGenericRecordSetManager().removeTemplateFromCache(fileName);
    }

    private static GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    protected void registerForRenewingContentCipher() {
        FormEncryptionContentIterator contentIterator = new FormEncryptionContentIterator();
        ContentEncryptionServiceFactory.getFactory().getContentEncryptionService().registerForRenewingContentCipher(contentIterator);
    }

    static {
        ResourceLocator templateSettings = new ResourceLocator("org.silverpeas.publicationTemplate.settings.template", "");
        templateDir = templateSettings.getString("templateDir");
        defaultTemplateDir = System.getenv("SILVERPEAS_HOME") + "/data/templateRepository/";
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{PublicationTemplateImpl.class});
        }
        catch (JAXBException e) {
            SilverTrace.fatal("form", "PublicationTemplateManager.init", "CANT_GET_JAXB_CONTEXT", e);
        }
    }
}

