/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.invitation;

import com.silverpeas.socialnetwork.invitation.Invitation;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class InvitationDao {
    private static final String INSERT_INVITATION = "INSERT INTO sb_sn_invitation (id, senderID, receiverId, message, invitationDate) VALUES (?, ?, ?, ?, ?)";
    private static final String DELETE_INVITATION = "DELETE FROM sb_sn_invitation WHERE id = ?";
    private static final String DELETE_SAME_INVITATIONS = "DELETE FROM sb_sn_invitation  WHERE id IN (SELECT invit.id FROM sb_sn_invitation invit, sb_sn_invitation tmp WHERE tmp.id = ? AND ((tmp.senderid= invit.senderid AND tmp.receiverid = invit.receiverid) OR (tmp.senderid = invit.receiverid AND tmp.receiverid = invit.senderid)))";
    private static final String SELECT_INVITATION = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE senderID = ? and receiverId= ?";
    private static final String SELECT_INVITATION_BY_ID = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE id = ? ";
    private static final String SELECT_ALL_INVITATIONS_SENT = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE senderID = ?";
    private static final String SELECT_ALL_INVITATIONS_RECEIVE = "SELECT id, senderID, receiverId, message, invitationDate FROM sb_sn_invitation  WHERE receiverId= ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createInvitation(Connection connection, Invitation invitation) throws UtilException, SQLException {
        int id = DBUtil.getNextId("sb_sn_invitation", "id");
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(INSERT_INVITATION);
            pstmt.setInt(1, id);
            pstmt.setInt(2, invitation.getSenderId());
            pstmt.setInt(3, invitation.getReceiverId());
            pstmt.setString(4, invitation.getMessage());
            pstmt.setTimestamp(5, new Timestamp(invitation.getInvitationDate().getTime()));
            pstmt.executeUpdate();
        }
        finally {
            DBUtil.close(pstmt);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteInvitation(Connection connection, int invitationId) throws SQLException {
        PreparedStatement pstmt = null;
        boolean endAction = false;
        try {
            pstmt = connection.prepareStatement(DELETE_INVITATION);
            pstmt.setInt(1, invitationId);
            pstmt.executeUpdate();
            endAction = true;
        }
        finally {
            DBUtil.close(pstmt);
        }
        return endAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSameInvitations(Connection connection, int invitationId) throws SQLException {
        PreparedStatement pstmt = null;
        boolean endAction = false;
        try {
            pstmt = connection.prepareStatement(DELETE_SAME_INVITATIONS);
            pstmt.setInt(1, invitationId);
            pstmt.executeUpdate();
            endAction = true;
        }
        finally {
            DBUtil.close(pstmt);
        }
        return endAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invitation getInvitation(Connection connection, int senderId, int receiverId) throws SQLException {
        Invitation invitation = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(SELECT_INVITATION);
            pstmt.setInt(1, senderId);
            pstmt.setInt(2, receiverId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                invitation = new Invitation();
                invitation.setId(rs.getInt(1));
                invitation.setSenderId(rs.getInt(2));
                invitation.setReceiverId(rs.getInt(3));
                invitation.setMessage(rs.getString(4));
                invitation.setInvitationDate(new Date(rs.getTimestamp(5).getTime()));
            }
        }
        finally {
            DBUtil.close(pstmt);
        }
        return invitation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invitation getInvitation(Connection connection, int id) throws SQLException {
        Invitation invitation = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(SELECT_INVITATION_BY_ID);
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                invitation = new Invitation();
                invitation.setId(rs.getInt(1));
                invitation.setSenderId(rs.getInt(2));
                invitation.setReceiverId(rs.getInt(3));
                invitation.setMessage(rs.getString(4));
                invitation.setInvitationDate(new Date(rs.getTimestamp(5).getTime()));
            }
        }
        finally {
            DBUtil.close(pstmt);
        }
        return invitation;
    }

    public boolean isExists(Connection connection, int senderId, int receiverId) throws SQLException {
        return this.getInvitation(connection, senderId, receiverId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Invitation> getAllMyInvitationsSent(Connection connection, int myId) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Invitation> invitations = new ArrayList<Invitation>();
        try {
            pstmt = connection.prepareStatement(SELECT_ALL_INVITATIONS_SENT);
            pstmt.setInt(1, myId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Invitation invitation = new Invitation();
                invitation.setId(rs.getInt(1));
                invitation.setSenderId(rs.getInt(2));
                invitation.setReceiverId(rs.getInt(3));
                invitation.setMessage(rs.getString(4));
                invitation.setInvitationDate(new Date(rs.getTimestamp(5).getTime()));
                invitations.add(invitation);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close(rs, pstmt);
        return invitations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Invitation> getAllMyInvitationsReceive(Connection connection, int myId) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Invitation> invitations = new ArrayList<Invitation>();
        try {
            pstmt = connection.prepareStatement(SELECT_ALL_INVITATIONS_RECEIVE);
            pstmt.setInt(1, myId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Invitation invitation = new Invitation();
                invitation.setId(rs.getInt(1));
                invitation.setSenderId(rs.getInt(2));
                invitation.setReceiverId(rs.getInt(3));
                invitation.setMessage(rs.getString(4));
                invitation.setInvitationDate(new Date(rs.getTimestamp(5).getTime()));
                invitations.add(invitation);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close(rs, pstmt);
        return invitations;
    }
}

