/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.invitation;

import com.silverpeas.socialnetwork.invitation.Invitation;
import com.silverpeas.socialnetwork.invitation.InvitationDao;
import com.silverpeas.socialnetwork.relationShip.RelationShip;
import com.silverpeas.socialnetwork.relationShip.RelationShipDao;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Named;

@Named
public class InvitationService {
    private InvitationDao invitationDao = new InvitationDao();
    private RelationShipDao relationShipDao = new RelationShipDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invite(Invitation invitation) {
        int invitationRslt = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            boolean alreadySent = this.invitationDao.isExists(connection, invitation.getSenderId(), invitation.getReceiverId());
            invitationRslt = alreadySent ? -1 : (this.relationShipDao.isInRelationShip(connection, invitation.getSenderId(), invitation.getReceiverId()) ? -2 : this.invitationDao.createInvitation(connection, invitation));
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.invite", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return invitationRslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreInvitation(int id) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.invitationDao.deleteInvitation(connection, id);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.ignoreInvitation", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int accepteInvitation(int idInvitation) {
        int resultAccepteInvitation = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            Invitation invitation = this.invitationDao.getInvitation(connection, idInvitation);
            if (invitation == null) {
                resultAccepteInvitation = -1;
            } else if (this.relationShipDao.isInRelationShip(connection, invitation.getSenderId(), invitation.getReceiverId())) {
                resultAccepteInvitation = -2;
            } else {
                RelationShip ship1 = new RelationShip();
                ship1.setUser1Id(invitation.getSenderId());
                ship1.setUser2Id(invitation.getReceiverId());
                ship1.setAcceptanceDate(new Timestamp(new Date().getTime()));
                ship1.setInviterId(invitation.getSenderId());
                RelationShip ship2 = new RelationShip();
                ship2.setUser1Id(invitation.getReceiverId());
                ship2.setUser2Id(invitation.getSenderId());
                ship2.setAcceptanceDate(new Timestamp(new Date().getTime()));
                ship2.setInviterId(invitation.getSenderId());
                this.invitationDao.deleteSameInvitations(connection, idInvitation);
                resultAccepteInvitation = this.relationShipDao.createRelationShip(connection, ship1);
                this.relationShipDao.createRelationShip(connection, ship2);
            }
            connection.commit();
        }
        catch (Exception ex) {
            resultAccepteInvitation = 0;
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.accepteInvitation", "", ex);
            DBUtil.rollback(connection);
        }
        finally {
            DBUtil.close(connection);
        }
        return resultAccepteInvitation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Invitation> getAllMyInvitationsSent(int userId) {
        Connection connection = null;
        ArrayList<Invitation> invitations = new ArrayList();
        try {
            connection = this.getConnection();
            invitations = this.invitationDao.getAllMyInvitationsSent(connection, userId);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.ignoreInvitation", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return invitations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Invitation> getAllMyInvitationsReceive(int myId) {
        Connection connection = null;
        ArrayList<Invitation> invitations = new ArrayList();
        try {
            connection = this.getConnection();
            invitations = this.invitationDao.getAllMyInvitationsReceive(connection, myId);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.ignoreInvitation", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return invitations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invitation getInvitation(int id) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Invitation invitation = this.invitationDao.getInvitation(connection, id);
            return invitation;
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.ignoreInvitation", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invitation getInvitation(int senderId, int receiverId) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Invitation invitation = this.invitationDao.getInvitation(connection, senderId, receiverId);
            return invitation;
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.ignoreInvitation", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return null;
    }

    private Connection getConnection() throws UtilException {
        return DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationShip getRelationShip(int relationShipId) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            RelationShip relationShip = this.relationShipDao.getRelationShip(connection, relationShipId);
            return relationShip;
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Invitation", "InvitationService.getRelationShip", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return null;
    }
}

