/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.wysiwyg.dynamicvalue.pool;

import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPool;
import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolInformation;
import com.silverpeas.wysiwyg.dynamicvalue.pool.TechnicalException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;

public class ConnectionPoolWithJDBC
implements ConnectionPool {
    private static DataSource ds = null;
    private static ConnectionPoolInformation poolInfo = null;

    @Override
    public Connection getConnection() throws SQLException {
        if (ds == null) {
            ConnectionPoolWithJDBC.initializeDatasource();
        }
        return ds.getConnection();
    }

    private static synchronized void initializeDatasource() {
        SilverTrace.debug("wysiwyg", ConnectionPoolWithJDBC.class.toString(), " Datasource initialization : starting ...");
        if (ds == null) {
            if (poolInfo == null) {
                SilverTrace.error("wysiwig", ConnectionPoolWithJDBC.class.toString(), "wysiwig.CONNECTION_INIALIZATION_FAILED");
                throw new TechnicalException(ConnectionPoolWithJDBC.class.toString() + " : An error occurred  during the connection initialization. The Pool information must be set");
            }
            SilverTrace.debug("wysiwyg", ConnectionPoolWithJDBC.class.toString(), " Datasource initialization : poolInfo detail :: " + poolInfo.toString());
            DriverAdapterCPDS cpds = new DriverAdapterCPDS();
            try {
                cpds.setDriver(poolInfo.getDriver());
            }
            catch (ClassNotFoundException e) {
                SilverTrace.error("wysiwig", ConnectionPoolWithJDBC.class.toString(), "wysiwig.DRIVER_MISSING");
                throw new TechnicalException(ConnectionPoolWithJDBC.class.toString() + " : An error occurred  during the connection initializatoin. The JDBC driver isn't in the classpath", e);
            }
            cpds.setUrl(poolInfo.getUrl());
            cpds.setUser(poolInfo.getUser());
            cpds.setPassword(poolInfo.getPassword());
            SharedPoolDataSource tds = new SharedPoolDataSource();
            tds.setConnectionPoolDataSource((ConnectionPoolDataSource)cpds);
            tds.setMaxActive(poolInfo.getMaxActive());
            tds.setMaxWait(poolInfo.getMaxWait());
            tds.setMaxIdle(poolInfo.getMaxIdle());
            tds.setTimeBetweenEvictionRunsMillis(poolInfo.getTimeBetweenEvictionRunsMillis());
            tds.setNumTestsPerEvictionRun(poolInfo.getNumTestsPerEvictionRun());
            tds.setMinEvictableIdleTimeMillis(poolInfo.getMinEvictableIdleTimeMillis());
            ds = tds;
            SilverTrace.debug("wysiwyg", ConnectionPoolWithJDBC.class.toString(), " Datasource initialization : ending ...");
        }
    }

    @Override
    public ConnectionPoolInformation getPoolInformation() {
        return poolInfo;
    }

    @Override
    public void setPoolInformation(ConnectionPoolInformation poolInfo) {
        ConnectionPoolWithJDBC.poolInfo = poolInfo;
    }
}

