/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.sqldriver;

import com.stratelia.silverpeas.domains.sqldriver.SQLSettings;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.admin.user.constant.UserAccessLevel;

public class SQLUserTable {
    SQLSettings drvSettings = new SQLSettings();

    public SQLUserTable(SQLSettings ds) {
        this.drvSettings = ds;
    }

    public int createUser(Connection c, UserDetail user) throws AdminException {
        PreparedStatement statement = null;
        int nextId = 0;
        String theQuery = "insert into " + this.drvSettings.getUserTableName() + "(" + this.getColumns() + ") values (?,?,?,?,?)";
        try {
            SilverTrace.debug("admin", "SQLUserTable.createUser", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            nextId = DBUtil.getNextId(this.drvSettings.getUserTableName(), this.drvSettings.getUserSpecificIdColumnName());
            statement.setInt(1, nextId);
            statement.setString(2, this.drvSettings.trunc(user.getFirstName(), 100));
            statement.setString(3, this.drvSettings.trunc(user.getLastName(), 100));
            statement.setString(4, this.drvSettings.trunc(user.geteMail(), 100));
            statement.setString(5, this.drvSettings.trunc(user.getLogin(), 50));
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLUserTable.createUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return nextId;
    }

    public void deleteUser(Connection c, int userId) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "delete from " + this.drvSettings.getUserTableName() + " where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLUserTable.deleteUser", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, userId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLUserTable.deleteUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public void updateUser(Connection c, UserDetail ud) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "update " + this.drvSettings.getUserTableName() + " set " + this.drvSettings.getUserFirstNameColumnName() + " = ?," + this.drvSettings.getUserLastNameColumnName() + " = ?," + this.drvSettings.getUserEMailColumnName() + " = ?," + this.drvSettings.getUserLoginColumnName() + " = ? " + " where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLUserTable.updateUser", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setString(1, this.drvSettings.trunc(ud.getFirstName(), 100));
            statement.setString(2, this.drvSettings.trunc(ud.getLastName(), 100));
            statement.setString(3, this.drvSettings.trunc(ud.geteMail(), 100));
            statement.setString(4, this.drvSettings.trunc(ud.getLogin(), 50));
            statement.setInt(5, Integer.parseInt(ud.getSpecificId()));
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLUserTable.updateUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public void updateUserSpecificProperty(Connection c, int userId, DomainProperty dp, String value) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "update " + this.drvSettings.getUserTableName() + " set " + dp.getMapParameter() + " = ?" + " where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLUserTable.updateUserSpecificProperty", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            if ("BOOLEAN".equals(dp.getType())) {
                statement.setInt(1, Integer.parseInt(value));
            } else {
                statement.setString(1, value);
            }
            statement.setInt(2, userId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AdminException("SQLUserTable.createUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public void updateUserPassword(Connection c, int userId, String value) throws AdminException {
        if (this.drvSettings.isUserPasswordAvailable()) {
            PreparedStatement statement = null;
            String theQuery = "update " + this.drvSettings.getUserTableName() + " set " + this.drvSettings.getUserPasswordColumnName() + " = ?" + " where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
            try {
                SilverTrace.debug("admin", "SQLUserTable.updateUserPassword", "root.MSG_QUERY", theQuery);
                statement = c.prepareStatement(theQuery);
                statement.setString(1, value);
                statement.setInt(2, userId);
                statement.executeUpdate();
            }
            catch (Exception e) {
                try {
                    throw new AdminException("SQLUserTable.updateUserPassword", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(statement);
                    throw throwable;
                }
            }
            DBUtil.close(statement);
        }
    }

    public void updateUserPasswordValid(Connection c, int userId, boolean value) throws AdminException {
        if (this.drvSettings.isUserPasswordValidAvailable()) {
            PreparedStatement statement = null;
            String theQuery = "update " + this.drvSettings.getUserTableName() + " set " + this.drvSettings.getUserPasswordValidColumnName() + " = ?" + " where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
            try {
                SilverTrace.debug("admin", "SQLUserTable.updateUserPasswordValid", "root.MSG_QUERY", theQuery);
                statement = c.prepareStatement(theQuery);
                statement.setString(1, value ? "Y" : "N");
                statement.setInt(2, userId);
                statement.executeUpdate();
            }
            catch (Exception e) {
                try {
                    throw new AdminException("SQLUserTable.updateUserPasswordValid", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(statement);
                    throw throwable;
                }
            }
            DBUtil.close(statement);
        }
    }

    public void updateUserSpecificProperty(Connection c, int userId, DomainProperty dp, boolean value) throws AdminException {
        this.updateUserSpecificProperty(c, userId, dp, value ? "Y" : "N");
    }

    public List<Integer> getAllUserIds(Connection c) throws AdminException {
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<Integer> theResult = new ArrayList<Integer>();
        String theQuery = "select " + this.drvSettings.getUserSpecificIdColumnName() + " from " + this.drvSettings.getUserTableName();
        try {
            SilverTrace.debug("admin", "SQLUserTable.getDirectGroupIdsOfUser", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLUserTable.getDirectGroupIdsOfUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return theResult;
    }

    public List<UserDetail> getAllUsers(Connection c) throws AdminException {
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<UserDetail> theResult = new ArrayList<UserDetail>();
        String theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getUserTableName();
        try {
            SilverTrace.debug("admin", "getAllUsers", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(this.fetchUser(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new AdminException("getAllUsers", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return theResult;
    }

    public List<UserDetail> getUsersBySpecificProperty(Connection c, String propertyName, String value) throws AdminException {
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<UserDetail> theResult = new ArrayList<UserDetail>();
        String theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getUserTableName();
        theQuery = theQuery + " where " + propertyName + " = ? ";
        try {
            SilverTrace.debug("admin", "getUsersBySpecificProperty", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setString(1, value);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(this.fetchUser(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new AdminException("getUsersBySpecificProperty", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return theResult;
    }

    public UserDetail getUser(Connection c, int userId) throws AdminException {
        UserDetail userDetail;
        String theQuery;
        PreparedStatement statement;
        ResultSet rs;
        block5: {
            rs = null;
            statement = null;
            theQuery = "select " + this.getColumns() + " from " + this.drvSettings.getUserTableName() + " where id = ?";
            SilverTrace.debug("admin", "SQLUserTable.getUser", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, userId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            UserDetail userDetail2 = this.fetchUser(rs);
            DBUtil.close(rs, statement);
            return userDetail2;
        }
        try {
            userDetail = null;
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLUserTable.getUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return userDetail;
    }

    public String getUserSpecificProperty(Connection c, int userId, DomainProperty dp) throws AdminException {
        String string;
        String theQuery;
        PreparedStatement statement;
        ResultSet rs;
        block5: {
            rs = null;
            statement = null;
            theQuery = "select " + dp.getMapParameter() + " from " + this.drvSettings.getUserTableName() + " where id = ?";
            SilverTrace.debug("admin", "SQLUserTable.getUserSpecificProperty", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, userId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            String string2 = rs.getString(1);
            DBUtil.close(rs, statement);
            return string2;
        }
        try {
            string = "";
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLUserTable.getUserSpecificProperty", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return string;
    }

    public String getUserPassword(Connection c, int userId) throws AdminException {
        if (this.drvSettings.isUserPasswordAvailable()) {
            String string;
            String theQuery;
            PreparedStatement statement;
            ResultSet rs;
            block6: {
                rs = null;
                statement = null;
                theQuery = "select " + this.drvSettings.getUserPasswordColumnName() + " from " + this.drvSettings.getUserTableName() + " where id = ?";
                SilverTrace.debug("admin", "SQLUserTable.getUserPassword", "root.MSG_QUERY", theQuery);
                statement = c.prepareStatement(theQuery);
                statement.setInt(1, userId);
                rs = statement.executeQuery();
                if (!rs.next()) break block6;
                String string2 = rs.getString(1);
                DBUtil.close(rs, statement);
                return string2;
            }
            try {
                string = "";
            }
            catch (SQLException e) {
                try {
                    throw new AdminException("SQLUserTable.getUserPassword", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, statement);
                    throw throwable;
                }
            }
            DBUtil.close(rs, statement);
            return string;
        }
        return "";
    }

    public boolean getUserPasswordValid(Connection c, int userId) throws AdminException {
        if (this.drvSettings.isUserPasswordValidAvailable()) {
            boolean bl;
            String theQuery;
            PreparedStatement statement;
            ResultSet rs;
            block6: {
                rs = null;
                statement = null;
                theQuery = "select " + this.drvSettings.getUserPasswordValidColumnName() + " from " + this.drvSettings.getUserTableName() + " where id = ?";
                SilverTrace.debug("admin", "SQLUserTable.getUserPasswordValid", "root.MSG_QUERY", theQuery);
                statement = c.prepareStatement(theQuery);
                statement.setInt(1, userId);
                rs = statement.executeQuery();
                if (!rs.next()) break block6;
                boolean bl2 = "Y".equalsIgnoreCase(rs.getString(1));
                DBUtil.close(rs, statement);
                return bl2;
            }
            try {
                bl = this.drvSettings.isUserPasswordAvailable();
            }
            catch (SQLException e) {
                try {
                    throw new AdminException("SQLUserTable.getUserPasswordValid", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, statement);
                    throw throwable;
                }
            }
            DBUtil.close(rs, statement);
            return bl;
        }
        return this.drvSettings.isUserPasswordAvailable();
    }

    protected String getColumns() {
        return this.drvSettings.getUserSpecificIdColumnName() + ", " + this.drvSettings.getUserFirstNameColumnName() + ", " + this.drvSettings.getUserLastNameColumnName() + ", " + this.drvSettings.getUserEMailColumnName() + ", " + this.drvSettings.getUserLoginColumnName();
    }

    protected UserDetail fetchUser(ResultSet rs) throws SQLException {
        UserDetail u = new UserDetail();
        u.setSpecificId(Integer.toString(rs.getInt(1)));
        u.setFirstName(rs.getString(2));
        u.setLastName(rs.getString(3));
        u.seteMail(rs.getString(4));
        u.setLogin(rs.getString(5));
        u.setAccessLevel(UserAccessLevel.USER);
        return u;
    }
}

