/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.silvertrace;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.MsgTrace;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SMTPAppender;

public class SilverLog {
    public static final int TRACE_LEVEL_UNKNOWN = 0;
    public static final int TRACE_LEVEL_DEBUG = 1;
    public static final int TRACE_LEVEL_INFO = 2;
    public static final int TRACE_LEVEL_WARN = 3;
    public static final int TRACE_LEVEL_ERROR = 4;
    public static final int TRACE_LEVEL_FATAL = 5;
    public static final int APPENDER_CONSOLE = 1;
    public static final int APPENDER_FILE = 2;
    public static final int APPENDER_ROLLING_FILE = 4;
    public static final int APPENDER_MAIL = 8;
    public static final int APPENDER_ALL = -1;
    public static final String LAYOUT_HTML = "LAYOUT_HTML";
    public static final String LAYOUT_SHORT = "LAYOUT_SHORT";
    public static final String LAYOUT_DETAILED = "LAYOUT_DETAILED";
    public static final String LAYOUT_FULL_DEBUG = "LAYOUT_FULL_DEBUG";
    public static final String ROLLING_MODE_MOUNTH = "'.'yyyy-MM";
    public static final String ROLLING_MODE_WEEK = "'.'yyyy-ww";
    public static final String ROLLING_MODE_DAILY = "'.'yyyy-MM-dd";
    public static final String ROLLING_MODE_HOUR = "'.'yyyy-MM-dd-HH";
    protected static Logger currentLogger = null;
    protected static String logDir = null;
    protected static String logModule = null;
    protected static final String layoutShort = "%-5p : %m%n";
    protected static final String layoutDetailed = "%d{dd/MM/yy-HH:mm:SSS},%m%n";
    protected static final String layoutFullDebug = "%-15.15r [%-26.26t] - %d{dd/MM/yy-HH:mm:SSS} - %-5p : %m%n";

    public static void logConnexion(String message, String ipAddress, String userLogin) {
        try {
            if (currentLogger != null && currentLogger.isDebugEnabled()) {
                currentLogger.debug((Object)SilverLog.formatTraceMessage(message, ipAddress, userLogin));
            }
        }
        catch (RuntimeException e) {
            SilverTrace.error("silvertrace", "SilverLog.logConnexion()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", e);
        }
    }

    protected static void initAll() {
        try {
            ResourceBundle resource = FileUtil.loadBundle("com.stratelia.silverpeas.silvertrace.settings.silverLog", new Locale("", ""));
            logDir = resource.getString("LogDir");
            if (currentLogger != null) {
                currentLogger.getRoot().getLoggerRepository().resetConfiguration();
            }
            currentLogger = Logger.getLogger((String)resource.getString("module.path"));
            logModule = resource.getString("module.name");
            SilverLog.initFromBundle(resource);
        }
        catch (Exception e) {
            SilverTrace.error("silvertrace", "SilverLog.resetAll()", "silvertrace.ERR_INIT_TRACE", e);
        }
    }

    public static void initFromBundle(ResourceBundle resource) {
        try {
            int i = 0;
            String appenderTypeStr = resource.getString("appender" + i + ".type");
            while (appenderTypeStr != null) {
                int appenderTypeInt = "APPENDER_CONSOLE".equalsIgnoreCase(appenderTypeStr) ? 1 : ("APPENDER_FILE".equalsIgnoreCase(appenderTypeStr) ? 2 : ("APPENDER_ROLLING_FILE".equalsIgnoreCase(appenderTypeStr) ? 4 : ("APPENDER_MAIL".equalsIgnoreCase(appenderTypeStr) ? 8 : -1)));
                boolean appenderEnabled = MsgTrace.getBooleanProperty(resource, "appender" + i + ".enabled", true);
                if (appenderTypeInt != -1 && appenderEnabled) {
                    SilverLog.addAppenderFromBundle(resource, i, appenderTypeInt);
                }
                ++i;
                try {
                    appenderTypeStr = resource.getString("appender" + i + ".type");
                }
                catch (MissingResourceException ex) {
                    appenderTypeStr = null;
                }
            }
        }
        catch (Exception e) {
            SilverTrace.error("silvertrace", "SilverLog.resetAll()", "silvertrace.ERR_INIT_APPENDER_FROM_PROP", e);
        }
    }

    protected static void addAppenderFromBundle(ResourceBundle resource, int appenderNumber, int appenderType) {
        String layout = resource.getString("appender" + appenderNumber + ".layout");
        switch (appenderType) {
            case 1: {
                String consoleName = resource.getString("appender" + appenderNumber + ".consoleName");
                SilverLog.addAppenderConsole(layout, consoleName);
                break;
            }
            case 2: {
                String fileName = SilverLog.translateFileName(resource.getString("appender" + appenderNumber + ".fileName"));
                boolean append = MsgTrace.getBooleanProperty(resource, "appender" + appenderNumber + ".append", true);
                SilverLog.addAppenderFile(layout, fileName, append);
                break;
            }
            case 4: {
                String fileName = SilverLog.translateFileName(resource.getString("appender" + appenderNumber + ".fileName"));
                String rollingModeName = resource.getString("appender" + appenderNumber + ".rollingMode");
                String rollingMode = rollingModeName == null ? ROLLING_MODE_DAILY : ("ROLLING_MODE_MOUNTH".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_MOUNTH : ("ROLLING_MODE_WEEK".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_WEEK : ("ROLLING_MODE_DAILY".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_DAILY : ("ROLLING_MODE_HOUR".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_HOUR : (rollingModeName.length() == 0 ? ROLLING_MODE_DAILY : rollingModeName)))));
                SilverLog.addAppenderRollingFile(layout, fileName, rollingMode);
                break;
            }
            case 8: {
                String mailHost = resource.getString("appender" + appenderNumber + ".mailHost");
                String mailFrom = resource.getString("appender" + appenderNumber + ".mailFrom");
                String mailTo = resource.getString("appender" + appenderNumber + ".mailTo");
                String mailSubject = resource.getString("appender" + appenderNumber + ".mailSubject");
                SilverLog.addAppenderMail(layout, mailHost, mailFrom, mailTo, mailSubject);
            }
        }
    }

    protected static void addAppenderConsole(String patternLayout, String consoleName) {
        ConsoleAppender a1 = new ConsoleAppender();
        if (currentLogger != null) {
            try {
                currentLogger.removeAppender(SilverLog.getAppenderName(1));
                a1.setName(SilverLog.getAppenderName(1));
                a1.setLayout(SilverLog.getLayout(patternLayout));
                if (StringUtil.isDefined(consoleName)) {
                    a1.setTarget(consoleName);
                }
                a1.activateOptions();
                currentLogger.addAppender((Appender)a1);
            }
            catch (Exception e) {
                SilverTrace.error("silvertrace", "SilverLog.addAppenderConsole()", "silvertrace.ERR_CANT_ADD_APPENDER", "Console ," + patternLayout + "," + consoleName, e);
            }
        }
    }

    protected static void addAppenderFile(String patternLayout, String fileName, boolean appendOnFile) {
        FileAppender a1 = new FileAppender();
        if (currentLogger != null) {
            try {
                currentLogger.removeAppender(SilverLog.getAppenderName(2));
                a1.setName(SilverLog.getAppenderName(2));
                a1.setLayout(SilverLog.getLayout(patternLayout));
                a1.setAppend(appendOnFile);
                a1.setFile(fileName);
                a1.activateOptions();
                currentLogger.addAppender((Appender)a1);
            }
            catch (Exception e) {
                SilverTrace.error("silvertrace", "SilverLog.addAppenderFile()", "silvertrace.ERR_CANT_ADD_APPENDER", "File " + patternLayout + "," + fileName, e);
            }
        }
    }

    protected static void addAppenderRollingFile(String patternLayout, String fileName, String rollingMode) {
        if (currentLogger != null) {
            try {
                DailyRollingFileAppender a1 = new DailyRollingFileAppender(SilverLog.getLayout(patternLayout), fileName, rollingMode);
                currentLogger.removeAppender(SilverLog.getAppenderName(4));
                a1.setName(SilverLog.getAppenderName(4));
                currentLogger.addAppender((Appender)a1);
            }
            catch (Exception e) {
                SilverTrace.error("silvertrace", "SilverLog.addAppenderRollingFile()", "silvertrace.ERR_CANT_ADD_APPENDER", "RollingFile ," + patternLayout + "," + fileName, e);
            }
        }
    }

    protected static void addAppenderMail(String patternLayout, String mailHost, String mailFrom, String mailTo, String mailSubject) {
        SMTPAppender a1 = new SMTPAppender();
        if (currentLogger != null) {
            try {
                currentLogger.removeAppender(SilverLog.getAppenderName(8));
                a1.setName(SilverLog.getAppenderName(8));
                a1.setLayout(SilverLog.getLayout(patternLayout));
                a1.setSMTPHost(mailHost);
                a1.setFrom(mailFrom);
                a1.setTo(mailTo);
                a1.setSubject(mailSubject);
                a1.activateOptions();
                currentLogger.addAppender((Appender)a1);
            }
            catch (Exception e) {
                SilverTrace.error("silvertrace", "SilverLog.addAppenderMail()", "silvertrace.ERR_CANT_ADD_APPENDER", "SMTP ," + patternLayout + "," + mailHost, e);
            }
        }
    }

    protected static void removeAppender(int typeOfAppender) {
        if (currentLogger != null) {
            if ((typeOfAppender & 1) == 1) {
                currentLogger.removeAppender(SilverLog.getAppenderName(1));
            }
            if ((typeOfAppender & 2) == 2) {
                currentLogger.removeAppender(SilverLog.getAppenderName(2));
            }
            if ((typeOfAppender & 4) == 4) {
                currentLogger.removeAppender(SilverLog.getAppenderName(4));
            }
            if ((typeOfAppender & 8) == 8) {
                currentLogger.removeAppender(SilverLog.getAppenderName(8));
            }
        }
    }

    protected static String formatTraceMessage(String message, String adresseIP, String userLogin) {
        StringBuilder valret = new StringBuilder("");
        if (StringUtil.isDefined(message)) {
            valret.append(message).append(",");
        }
        if (StringUtil.isDefined(adresseIP)) {
            valret.append(adresseIP).append(",");
        }
        if (StringUtil.isDefined(userLogin)) {
            valret.append(userLogin);
        }
        return valret.toString();
    }

    protected static String translateFileName(String fileName) {
        String valret = fileName;
        if (StringUtil.isDefined(fileName)) {
            int index = fileName.indexOf("@ErrorDir@");
            if (index == 0) {
                valret = logDir + fileName.substring(index + 10, fileName.length());
            } else if (index > 0) {
                valret = fileName.substring(0, index) + logDir + fileName.substring(index + 10, fileName.length());
            }
        }
        return valret;
    }

    protected static Layout getLayout(String patternLayout) {
        if (patternLayout.equalsIgnoreCase(LAYOUT_HTML)) {
            return new HTMLLayout();
        }
        if (patternLayout.equalsIgnoreCase(LAYOUT_SHORT)) {
            return new PatternLayout(layoutShort);
        }
        if (patternLayout.equalsIgnoreCase(LAYOUT_DETAILED)) {
            return new PatternLayout(layoutDetailed);
        }
        if (patternLayout.equalsIgnoreCase(LAYOUT_FULL_DEBUG)) {
            return new PatternLayout(layoutFullDebug);
        }
        return new PatternLayout(patternLayout);
    }

    protected static String getAppenderName(int typeOfAppender) {
        if ((typeOfAppender & 1) == 1) {
            return logModule + ".ConsoleAppender";
        }
        if ((typeOfAppender & 2) == 2) {
            return logModule + ".FileAppender";
        }
        if ((typeOfAppender & 4) == 4) {
            return logModule + ".DailyRollingFileAppender";
        }
        if ((typeOfAppender & 8) == 8) {
            return logModule + ".SMTPAppender";
        }
        return null;
    }

    static {
        SilverLog.initAll();
        SilverTrace.info("silvertrace", "SilverLog.static", "silvertrace.MSG_END_OF_INIT");
    }
}

