/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.webactiv.util.ResourceLocator;

public class DomainProperty {
    public static final String PROPERTY_TYPE_STRING = "STRING";
    public static final String PROPERTY_TYPE_USERID = "USERID";
    public static final String PROPERTY_TYPE_BOOLEAN = "BOOLEAN";
    public static final int DEFAULT_MAX_LENGTH = 50;
    public static final String PROPERTY_UPDATEALLOWED_ADMIN = "A";
    public static final String PROPERTY_UPDATEALLOWED_USER = "U";
    public static final String PROPERTY_UPDATE_NOT_ALLOWED = "N";
    private String name = null;
    private String type = "STRING";
    private int maxLength = 50;
    private String mapParameter = null;
    private boolean usedToImport = false;
    private String redirectOU = null;
    private String redirectAttribute = null;
    private String updateAllowedTo = "N";
    private String label = null;
    private String description = null;

    public DomainProperty() {
    }

    public DomainProperty(ResourceLocator rs, String num) {
        this.name = rs.getString("property_" + num + ".Name");
        this.type = PROPERTY_TYPE_STRING;
        String s = rs.getString("property_" + num + ".Type");
        if (s != null && s.length() > 0) {
            if (s.equalsIgnoreCase(PROPERTY_TYPE_USERID)) {
                this.type = PROPERTY_TYPE_USERID;
            } else if (s.equalsIgnoreCase(PROPERTY_TYPE_BOOLEAN)) {
                this.type = PROPERTY_TYPE_BOOLEAN;
            }
        }
        this.maxLength = rs.getInteger("property_" + num + ".MaxLength", 50);
        this.mapParameter = rs.getString("property_" + num + ".MapParameter");
        this.usedToImport = rs.getBoolean("property_" + num + ".UsedToImport", false);
        this.redirectOU = rs.getString("property_" + num + ".RedirectOU");
        this.redirectAttribute = rs.getString("property_" + num + ".RedirectAttribute");
        this.updateAllowedTo = rs.getString("property_" + num + ".UpdateAllowedTo", PROPERTY_UPDATE_NOT_ALLOWED);
    }

    public void setName(String propertyName) {
        this.name = propertyName;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String propertyType) {
        this.type = propertyType;
    }

    public String getType() {
        return this.type;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMapParameter(String mapParameter) {
        this.mapParameter = mapParameter;
    }

    public String getMapParameter() {
        return this.mapParameter;
    }

    public boolean isUsedToImport() {
        return this.usedToImport;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRedirectAttribute() {
        return this.redirectAttribute;
    }

    public String getRedirectOU() {
        return this.redirectOU;
    }

    public boolean isUpdateAllowedToUser() {
        return PROPERTY_UPDATEALLOWED_USER.equalsIgnoreCase(this.updateAllowedTo);
    }

    public boolean isUpdateAllowedToAdmin() {
        return PROPERTY_UPDATEALLOWED_ADMIN.equalsIgnoreCase(this.updateAllowedTo);
    }
}

