/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminGroupInst;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.SearchCriteriaDAOFactory;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.dao.GroupDAO;
import com.stratelia.webactiv.beans.admin.dao.GroupSearchCriteriaForDAO;
import com.stratelia.webactiv.beans.admin.dao.UserDAO;
import com.stratelia.webactiv.beans.admin.dao.UserSearchCriteriaForDAO;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.admin.user.constant.UserState;
import org.silverpeas.util.ListSlice;

public class GroupManager {
    private static GroupManager instance = new GroupManager();
    private GroupDAO groupDao = new GroupDAO();
    private UserDAO userDao = new UserDAO();

    public static GroupManager get() {
        return instance;
    }

    private GroupManager() {
    }

    public ListSlice<Group> getGroupsMatchingCriteria(GroupSearchCriteriaForDAO criteria) throws AdminException {
        Connection connection = null;
        try {
            connection = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            ListSlice<Group> groups = this.groupDao.getGroupsByCriteria(connection, criteria);
            String domainIdConstraint = null;
            List<String> domainIds = criteria.getCriterionOnDomainIds();
            for (String domainId : domainIds) {
                if (domainId.equals("-1")) continue;
                domainIdConstraint = domainId;
                break;
            }
            SearchCriteriaDAOFactory factory = SearchCriteriaDAOFactory.getFactory();
            for (Group group : groups) {
                List<String> groupIds = this.getAllSubGroupIdsRecursively(group.getId());
                groupIds.add(group.getId());
                UserSearchCriteriaForDAO criteriaOnUsers = factory.getUserSearchCriteriaDAO();
                Set<UserState> criterionOnUserStatesToExclude = criteria.getCriterionOnUserStatesToExclude();
                int userCount = this.userDao.getUserCountByCriteria(connection, criteriaOnUsers.onDomainId(domainIdConstraint).and().onGroupIds(groupIds.toArray(new String[groupIds.size()])).and().onUserStatesToExclude(criterionOnUserStatesToExclude.toArray(new UserState[criterionOnUserStatesToExclude.size()])));
                group.setTotalNbUsers(userCount);
            }
            ListSlice<Group> listSlice = groups;
            return listSlice;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getGroupsMatchingCriteria", 4, "admin.EX_ERR_GET_USER_GROUPS", e);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public int getTotalUserCountInGroup(String domainId, String groupId) throws AdminException {
        Connection connection = null;
        try {
            int userCount;
            connection = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            SearchCriteriaDAOFactory factory = SearchCriteriaDAOFactory.getFactory();
            List<String> groupIds = this.getAllSubGroupIdsRecursively(groupId);
            groupIds.add(groupId);
            UserSearchCriteriaForDAO criteriaOnUsers = factory.getUserSearchCriteriaDAO();
            int n = userCount = this.userDao.getUserCountByCriteria(connection, criteriaOnUsers.onDomainId(domainId).and().onGroupIds(groupIds.toArray(new String[groupIds.size()])));
            return n;
        }
        catch (SQLException e) {
            throw new AdminException("GroupManager.getGroupsMatchingCriteria", 4, "admin.EX_ERR_GET_USER_GROUPS", e);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public void addUserInGroup(DomainDriverManager ddManager, String sUserId, String sGroupId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ddManager.getOrganization().group.addUserInGroup(this.idAsInt(sUserId), this.idAsInt(sGroupId));
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.removeUserFromGroup", 4, "admin.EX_ERR_GET_USER_GROUPS", "User Id: '" + sUserId + "' GroupId = '" + sGroupId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void removeUserFromGroup(DomainDriverManager ddManager, String sUserId, String sGroupId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ddManager.getOrganization().group.removeUserFromGroup(this.idAsInt(sUserId), this.idAsInt(sGroupId));
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.removeUserFromGroup", 4, "admin.EX_ERR_GET_USER_GROUPS", "User Id: '" + sUserId + "' GroupId = '" + sGroupId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getDirectGroupsOfUser(DomainDriverManager ddManager, String sUserId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow[] grs = ddManager.getOrganization().group.getDirectGroupsOfUser(this.idAsInt(sUserId));
            String[] groups = new String[grs.length];
            for (int nI = 0; nI < grs.length; ++nI) {
                groups[nI] = GroupManager.idAsString(grs[nI].id);
            }
            String[] stringArray = groups;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getDirectGroupsOfUser", 4, "admin.EX_ERR_GET_USER_GROUPS", "User Id: '" + sUserId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<String> getAllGroupsOfUser(DomainDriverManager ddManager, String userId) throws AdminException {
        String[] directGroupIds;
        HashSet<String> allGroupsOfUser = new HashSet<String>();
        for (String directGroupId : directGroupIds = this.getDirectGroupsOfUser(ddManager, userId)) {
            Group group = this.getGroup(ddManager, directGroupId);
            if (group == null) continue;
            allGroupsOfUser.add(group.getId());
            while (group != null && StringUtil.isDefined(group.getSuperGroupId())) {
                if ((group = this.getGroup(ddManager, group.getSuperGroupId())) == null) continue;
                allGroupsOfUser.add(group.getId());
            }
        }
        return new ArrayList<String>(allGroupsOfUser);
    }

    public String getGroupIdBySpecificIdAndDomainId(DomainDriverManager ddManager, String sSpecificId, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow gr = ddManager.getOrganization().group.getGroupBySpecificId(this.idAsInt(sDomainId), sSpecificId);
            String string = GroupManager.idAsString(gr.id);
            return string;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getGroupIdBySpecificIdAndDomain", 4, "admin.EX_ERR_GET_GROUP", "group specific Id: '" + sSpecificId + "', domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getAllGroupIds(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asGroupIds = ddManager.getOrganization().group.getAllGroupIds();
            if (asGroupIds != null) {
                String[] stringArray = asGroupIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getAllGroupIds", 4, "admin.EX_ERR_GET_ALL_GROUP_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getAllRootGroupIds(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asGroupIds = ddManager.getOrganization().group.getAllRootGroupIds();
            if (asGroupIds != null) {
                String[] stringArray = asGroupIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getAllRootGroupIds", 4, "admin.EX_ERR_GET_ALL_ROOT_GROUP_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public Group[] getAllRootGroups(DomainDriverManager ddManager) throws AdminException {
        try {
            Group[] rootGroups;
            ddManager.getOrganizationSchema();
            GroupRow[] rows = ddManager.getOrganization().group.getAllRootGroups();
            if (rows != null) {
                rootGroups = new Group[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    rootGroups[i] = this.groupRow2Group(rows[i]);
                    this.setDirectUsersOfGroup(ddManager, rootGroups[i]);
                }
            } else {
                rootGroups = new Group[]{};
            }
            Group[] groupArray = rootGroups;
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getAllRootGroupIds", 4, "admin.EX_ERR_GET_ALL_ROOT_GROUP_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getAllSubGroupIds(DomainDriverManager ddManager, String superGroupId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asGroupIds = ddManager.getOrganization().group.getDirectSubGroupIds(this.idAsInt(superGroupId));
            if (asGroupIds != null) {
                String[] stringArray = asGroupIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getAllSubGroupIds", 4, "admin.EX_ERR_GET_CHILDREN_GROUP_IDS", "father group Id: '" + superGroupId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<String> getPathToGroup(DomainDriverManager ddManager, String groupId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ArrayList<String> path = new ArrayList<String>();
            GroupRow superGroup = ddManager.getOrganization().group.getSuperGroup(this.idAsInt(groupId));
            while (superGroup != null) {
                path.add(0, GroupManager.idAsString(superGroup.id));
                superGroup = ddManager.getOrganization().group.getSuperGroup(superGroup.id);
            }
            ArrayList<String> arrayList = path;
            return arrayList;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getPathToGroup", 4, "admin.EX_ERR_GET_PATH_TO_GROUP", "groupId = " + groupId, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public boolean isGroupExist(DomainDriverManager ddManager, String sName) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow searchedGroup = new GroupRow();
            searchedGroup.specificId = null;
            searchedGroup.name = sName;
            searchedGroup.description = null;
            GroupRow[] group = ddManager.getOrganization().group.getAllMatchingGroups(searchedGroup);
            boolean bl = group.length > 0;
            return bl;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.isGroupExist", 4, "admin.EX_ERR_IS_GROUP_EXIST", "group name: '" + sName + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public Group getGroup(String groupId) throws AdminException {
        Connection con = null;
        try {
            Group group;
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            Group group2 = group = this.groupDao.getGroup(con, groupId);
            return group2;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getGroup", 4, "admin.EX_ERR_GET_GROUP", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public Group getGroup(DomainDriverManager ddManager, String sGroupId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow gr = ddManager.getOrganization().group.getGroup(this.idAsInt(sGroupId));
            Group group = new Group();
            if (gr != null) {
                group.setId(GroupManager.idAsString(gr.id));
                group.setSpecificId(gr.specificId);
                group.setDomainId(GroupManager.idAsString(gr.domainId));
                group.setSuperGroupId(GroupManager.idAsString(gr.superGroupId));
                group.setName(gr.name);
                group.setDescription(gr.description);
                group.setRule(gr.rule);
            }
            this.setDirectUsersOfGroup(ddManager, group);
            Group group2 = group;
            return group2;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getGroup", 4, "admin.EX_ERR_GET_GROUP", "group Id: '" + sGroupId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<String> getAllSubGroupIdsRecursively(String superGroupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = this.getSubGroupIds(con, superGroupId);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getAllSubGroupIdsRecursively", 4, "admin.EX_ERR_GET_CHILDREN_GROUP_IDS", "father group Id: '" + superGroupId + "'", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private List<String> getSubGroupIds(Connection con, String groupId) throws SQLException {
        ArrayList<String> groupIds = new ArrayList<String>();
        List<Group> groups = this.groupDao.getSubGroups(con, groupId);
        for (Group group : groups) {
            groupIds.add(group.getId());
            groupIds.addAll(this.getSubGroupIds(con, group.getId()));
        }
        return groupIds;
    }

    public Group getGroupByNameInDomain(DomainDriverManager ddManager, String sGroupName, String sDomainFatherId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            Group group = ddManager.getGroupByNameInDomain(sGroupName, sDomainFatherId);
            if (group != null) {
                String specificId = group.getSpecificId();
                GroupRow gr = ddManager.getOrganization().group.getGroupBySpecificId(this.idAsInt(sDomainFatherId), specificId);
                if (gr != null) {
                    group.setId(GroupManager.idAsString(gr.id));
                    this.setDirectUsersOfGroup(ddManager, group);
                } else {
                    Group group2 = null;
                    return group2;
                }
            }
            Group group3 = group;
            return group3;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getGroupByNameInDomain", 4, "admin.EX_ERR_GET_GROUP", "group Name: '" + sGroupName + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public Group[] getRootGroupsOfDomain(DomainDriverManager ddManager, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow[] grs = ddManager.getOrganization().group.getAllRootGroupsOfDomain(this.idAsInt(sDomainId));
            Group[] groups = new Group[grs.length];
            for (int nI = 0; nI < grs.length; ++nI) {
                groups[nI] = this.groupRow2Group(grs[nI]);
                this.setDirectUsersOfGroup(ddManager, groups[nI]);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getRootGroupsOfDomain", 4, "admin.EX_ERR_GET_GROUPS_OF_DOMAIN", "domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public Group[] getSynchronizedGroups(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow[] grs = ddManager.getOrganization().group.getSynchronizedGroups();
            Group[] groups = new Group[grs.length];
            for (int nI = 0; nI < grs.length; ++nI) {
                groups[nI] = this.groupRow2Group(grs[nI]);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getRootGroupsOfDomain", 4, "admin.EX_ERR_GET_GROUPS_OF_DOMAIN", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getRootGroupIdsOfDomain(DomainDriverManager ddManager, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] groupIds = ddManager.getOrganization().group.getAllRootGroupIdsOfDomain(this.idAsInt(sDomainId));
            if (groupIds != null) {
                String[] stringArray = groupIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getRootGroupIdsOfDomain", 4, "admin.EX_ERR_GET_GROUPS_OF_DOMAIN", "domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public Group[] getGroupsOfDomain(DomainDriverManager ddManager, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            SynchroReport.info("GroupManager.getGroupsOfDomain()", "Recherche des groupes du domaine LDAP dans la base...", null);
            GroupRow[] grs = ddManager.getOrganization().group.getAllGroupsOfDomain(this.idAsInt(sDomainId));
            Group[] groups = new Group[grs.length];
            for (int nI = 0; nI < grs.length; ++nI) {
                groups[nI] = this.groupRow2Group(grs[nI]);
                SynchroReport.debug("GroupManager.getGroupsOfDomain()", "Groupe trouv\u00e9 no : " + Integer.toString(nI) + ", specificID : " + groups[nI].getSpecificId() + ", desc. : " + groups[nI].getDescription(), null);
            }
            SynchroReport.info("GroupManager.getGroupsOfDomain()", "R\u00e9cup\u00e9ration de " + grs.length + " groupes du domaine LDAP dans la base", null);
            Group[] groupArray = groups;
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getGroupsOfDomain", 4, "admin.EX_ERR_GET_GROUPS_OF_DOMAIN", "domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] searchGroupsIds(DomainDriverManager ddManager, boolean isRootGroup, String componentId, String[] aProfileId, Group modelGroup) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow model = this.group2GroupRow(modelGroup);
            if (!StringUtil.isDefined(modelGroup.getId())) {
                model.id = -2;
            }
            if (!StringUtil.isDefined(modelGroup.getDomainId())) {
                model.domainId = -2;
            }
            if (!StringUtil.isDefined(modelGroup.getSuperGroupId())) {
                model.superGroupId = -2;
            }
            int[] aRoleId = null;
            if (aProfileId != null) {
                aRoleId = new int[aProfileId.length];
                for (int i = 0; i < aProfileId.length; ++i) {
                    aRoleId[i] = this.idAsInt(aProfileId[i]);
                }
            }
            String[] stringArray = ddManager.getOrganization().group.searchGroupsIds(isRootGroup, this.idAsInt(componentId), aRoleId, model);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.searchGroupsIdsInGroup", 4, "admin.EX_ERR_GET_GROUPS_OF_DOMAIN", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public Group[] searchGroups(DomainDriverManager ddManager, Group modelGroup, boolean isAnd) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            GroupRow model = this.group2GroupRow(modelGroup);
            if (!StringUtil.isDefined(modelGroup.getId())) {
                model.id = -2;
            }
            if (!StringUtil.isDefined(modelGroup.getDomainId())) {
                model.domainId = -2;
            }
            if (!StringUtil.isDefined(modelGroup.getSuperGroupId())) {
                model.superGroupId = -2;
            }
            GroupRow[] grs = ddManager.getOrganization().group.searchGroups(model, isAnd);
            Group[] groups = new Group[grs.length];
            for (int nI = 0; nI < grs.length; ++nI) {
                groups[nI] = this.groupRow2Group(grs[nI]);
                this.setDirectUsersOfGroup(ddManager, groups[nI]);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.searchGroups", 4, "admin.EX_ERR_GET_GROUPS_OF_DOMAIN", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String addGroup(DomainDriverManager ddManager, Group group, boolean onlyInSilverpeas) throws AdminException {
        if (group == null || !StringUtil.isDefined(group.getName())) {
            if (group != null) {
                SynchroReport.error("GroupManager.addGroup()", "Probl\u00e8me lors de l'ajout du groupe " + group.getSpecificId() + " dans la base, ce groupe n'a pas de nom", null);
            }
            return "";
        }
        try {
            ddManager.getOrganizationSchema();
            if (!onlyInSilverpeas && group.getDomainId() != null) {
                String specificId = ddManager.createGroup(group);
                group.setSpecificId(specificId);
            }
            GroupRow gr = this.group2GroupRow(group);
            if (gr.superGroupId != -1) {
                SynchroReport.info("GroupManager.addGroup()", "Ajout du groupe " + group.getName() + " (p\u00e8re=" + this.getGroup(ddManager, group.getSuperGroupId()).getSpecificId() + ") dans la table ST_Group", null);
            } else {
                SynchroReport.info("GroupManager.addGroup()", "Ajout du groupe " + group.getName() + " (groupe racine) dans la table ST_Group...", null);
            }
            ddManager.getOrganization().group.createGroup(gr);
            String sGroupId = GroupManager.idAsString(gr.id);
            ddManager.indexGroup(gr);
            SynchroReport.info("GroupManager.addGroup()", "Inclusion des utilisateurs directement associ\u00e9s au groupe " + group.getName() + " (table ST_Group_User_Rel)", null);
            String[] asUserIds = group.getUserIds();
            int nUserAdded = 0;
            for (String asUserId : asUserIds) {
                if (!StringUtil.isDefined(asUserId)) continue;
                ddManager.getOrganization().group.addUserInGroup(this.idAsInt(asUserId), this.idAsInt(sGroupId));
                ++nUserAdded;
            }
            SynchroReport.info("GroupManager.addGroup()", nUserAdded + " utilisateurs ajout\u00e9s au groupe " + group.getName() + " dans la base", null);
            String string = sGroupId;
            return string;
        }
        catch (Exception e) {
            SynchroReport.error("GroupManager.addGroup()", "probl\u00e8me lors de l'ajout du groupe " + group.getName() + " - " + e.getMessage(), null);
            throw new AdminException("GroupManager.addGroup", 4, "admin.EX_ERR_ADD_GROUP", "group name: '" + group.getName() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String deleteGroupById(DomainDriverManager ddManager, Group group, boolean onlyInSilverpeas) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                ddManager.deleteGroup(group.getId());
            }
            ddManager.getOrganization().group.removeGroup(this.idAsInt(group.getId()));
            ddManager.unindexGroup(group.getId());
            String string = group.getId();
            return string;
        }
        catch (Exception e) {
            SynchroReport.error("GroupManager.deleteGroupById()", "probl\u00e8me lors de la suppression du groupe " + group.getName() + " - " + e.getMessage(), null);
            throw new AdminException("GroupManager.deleteGroupById", 4, "admin.EX_ERR_DELETE_GROUP", "group Id: '" + group.getId() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String updateGroup(DomainDriverManager ddManager, Group group, boolean onlyInSilverpeas) throws AdminException {
        ArrayList<String> alRemUsers = new ArrayList<String>();
        ArrayList<String> alAddUsers = new ArrayList<String>();
        if (group == null || !StringUtil.isDefined(group.getName()) || !StringUtil.isDefined(group.getId())) {
            if (group != null) {
                SynchroReport.error("GroupManager.updateGroup()", "Probl\u00e8me lors de maj du groupe " + group.getSpecificId() + " dans la base, ce groupe n'a pas de nom", null);
            }
            return "";
        }
        try {
            boolean bFound;
            ddManager.getOrganizationSchema();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                ddManager.updateGroup(group);
            }
            String sGroupId = group.getId();
            String strInfoSycnhro = group.getSuperGroupId() != null ? "Maj du groupe " + group.getName() + " (p\u00e8re=" + this.getGroup(ddManager, group.getSuperGroupId()).getSpecificId() + ") dans la base (table ST_Group)..." : "Maj du groupe " + group.getName() + " (groupe racine) dans la base (table ST_Group)...";
            SynchroReport.info("GroupManager.updateGroup()", strInfoSycnhro, null);
            GroupRow gr = this.group2GroupRow(group);
            ddManager.getOrganization().group.updateGroup(gr);
            ddManager.indexGroup(gr);
            SynchroReport.info("GroupManager.updateGroup()", "Maj \u00e9ventuelle des relations du groupe " + group.getName() + " avec les utilisateurs qui y sont directement inclus (tables ST_Group_User_Rel)", null);
            String[] asOldUsersId = ddManager.getOrganization().user.getDirectUserIdsOfGroup(this.idAsInt(sGroupId));
            String[] asNewUsersId = group.getUserIds();
            for (String anAsOldUsersId : asOldUsersId) {
                bFound = false;
                for (String anAsNewUsersId : asNewUsersId) {
                    if (!anAsOldUsersId.equals(anAsNewUsersId)) continue;
                    bFound = true;
                }
                if (bFound) continue;
                alRemUsers.add(anAsOldUsersId);
            }
            for (String anAsNewUsersId : asNewUsersId) {
                bFound = false;
                for (String anAsOldUsersId : asOldUsersId) {
                    if (!anAsNewUsersId.equals(anAsOldUsersId)) continue;
                    bFound = true;
                }
                if (bFound) continue;
                alAddUsers.add(anAsNewUsersId);
            }
            for (String alRemUser : alRemUsers) {
                ddManager.getOrganization().group.removeUserFromGroup(this.idAsInt(alRemUser), this.idAsInt(sGroupId));
            }
            for (String alAddUser : alAddUsers) {
                ddManager.getOrganization().group.addUserInGroup(this.idAsInt(alAddUser), this.idAsInt(sGroupId));
            }
            SynchroReport.info("GroupManager.updateGroup()", "Groupe : " + group.getName() + ", ajout de " + alAddUsers.size() + " nouveaux utilisateurs, suppression de " + alRemUsers.size() + " utilisateurs", null);
            String string = sGroupId;
            return string;
        }
        catch (Exception e) {
            SynchroReport.error("GroupManager.updateGroup()", "probl\u00e8me lors de la maj du groupe " + group.getName() + " - " + e.getMessage(), null);
            throw new AdminException("GroupManager.updateGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "group Id: '" + group.getId() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public AdminGroupInst[] getAdminOrganization(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asGroupIds = this.getAllGroupIds(ddManager);
            Group[] aGroup = new Group[asGroupIds.length];
            for (int nI = 0; nI < asGroupIds.length; ++nI) {
                aGroup[nI] = this.getGroup(ddManager, asGroupIds[nI]);
            }
            ArrayList<Integer> alRoot = new ArrayList<Integer>();
            for (int nI = 0; nI < aGroup.length; ++nI) {
                if (aGroup[nI].getSuperGroupId() != null) continue;
                alRoot.add(nI);
            }
            AdminGroupInst[] aAdminGroupInst = new AdminGroupInst[alRoot.size()];
            for (int nI = 0; nI < alRoot.size(); ++nI) {
                aAdminGroupInst[nI] = new AdminGroupInst();
                aAdminGroupInst[nI].setGroup(aGroup[(Integer)alRoot.get(nI)]);
                aAdminGroupInst[nI].setChildrenAdminGroupInst(this.getChildrenGroupInst(ddManager, aAdminGroupInst[nI].getGroup().getId(), aGroup));
            }
            AdminGroupInst[] adminGroupInstArray = aAdminGroupInst;
            return adminGroupInstArray;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getAdminOrganization", 4, "admin.EX_ERR_GET_ADMIN_ORGANIZATION", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    private ArrayList<AdminGroupInst> getChildrenGroupInst(DomainDriverManager ddManager, String sFatherGroupId, Group[] aGroup) {
        ArrayList<AdminGroupInst> alChildrenGroupInst = new ArrayList<AdminGroupInst>();
        for (Group anAGroup : aGroup) {
            if (anAGroup.getSuperGroupId() == null || !anAGroup.getSuperGroupId().equals(sFatherGroupId)) continue;
            AdminGroupInst adminGroupInst = new AdminGroupInst();
            adminGroupInst.setGroup(anAGroup);
            adminGroupInst.setChildrenAdminGroupInst(this.getChildrenGroupInst(ddManager, adminGroupInst.getGroup().getId(), aGroup));
            alChildrenGroupInst.add(adminGroupInst);
        }
        return alChildrenGroupInst;
    }

    public List<String> getManageableGroupIds(String userId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = this.groupDao.getManageableGroupIds(con, userId, groupIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getManageableGroupIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_GROUP_IDS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public int getNBUsersDirectlyInGroup(String groupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            int n = this.groupDao.getNBUsersDirectlyInGroup(con, groupId);
            return n;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getNBUsersDirectlyInGroup", 4, "admin.EX_ERR_GET_USER_OF_GROUP", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<String> getUsersDirectlyInGroup(String groupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = this.groupDao.getUsersDirectlyInGroup(con, groupId);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("GroupManager.getUsersDirectlyInGroup", 4, "admin.EX_ERR_GET_USER_OF_GROUP", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private void setDirectUsersOfGroup(DomainDriverManager ddManager, Group group) throws AdminPersistenceException {
        String[] asUsersId = ddManager.getOrganization().user.getDirectUserIdsOfGroup(this.idAsInt(group.getId()));
        if (asUsersId != null) {
            group.setUserIds(asUsersId);
        }
    }

    private Group groupRow2Group(GroupRow gr) {
        Group group = new Group();
        if (gr != null) {
            group.setId(GroupManager.idAsString(gr.id));
            group.setSpecificId(gr.specificId);
            group.setDomainId(GroupManager.idAsString(gr.domainId));
            group.setSuperGroupId(GroupManager.idAsString(gr.superGroupId));
            group.setName(gr.name);
            group.setDescription(gr.description);
            group.setRule(gr.rule);
        }
        return group;
    }

    private GroupRow group2GroupRow(Group group) {
        GroupRow gr = new GroupRow();
        gr.id = this.idAsInt(group.getId());
        gr.specificId = group.getSpecificId();
        gr.domainId = this.idAsInt(group.getDomainId());
        gr.superGroupId = this.idAsInt(group.getSuperGroupId());
        gr.name = group.getName();
        gr.description = group.getDescription();
        gr.rule = group.getRule();
        return gr;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        if (id == -1) {
            return null;
        }
        return Integer.toString(id);
    }
}

