/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.jaas;

import com.silverpeas.jcrutil.BasicDaoFactory;
import com.silverpeas.jcrutil.security.impl.SilverpeasSystemCredentials;
import com.silverpeas.jcrutil.security.impl.SilverpeasSystemPrincipal;
import com.stratelia.webactiv.jaas.SilverpeasUserPrincipal;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class SilverpeasAccessManager
implements AccessManager {
    private HierarchyManager manager;
    private NamePathResolver resolver;
    private WorkspaceAccessManager wspAccessMgr;
    private PrivilegeManager privilegeManager;
    private Subject subject;
    private boolean initialized;
    private boolean isSystem = false;
    private Repository repository;

    public boolean canAccess(String workspaceName) throws RepositoryException {
        if (this.isSystem || this.wspAccessMgr == null) {
            return true;
        }
        return this.wspAccessMgr.grants(this.subject.getPrincipals(), workspaceName);
    }

    public void checkPermission(ItemId id, int permissions) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (!this.isGranted(id, permissions)) {
            throw new AccessDeniedException();
        }
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.initialized = false;
    }

    public void init(AMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.manager = context.getHierarchyManager();
        this.resolver = context.getNamePathResolver();
        this.privilegeManager = context.getPrivilegeManager();
        this.subject = context.getSubject();
        this.isSystem = !this.subject.getPrincipals(SilverpeasSystemPrincipal.class).isEmpty();
        this.initialized = true;
    }

    public boolean isGranted(ItemId id, int permissions) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (id.denotesNode() && !this.isSystem) {
            Path path = this.manager.getPath(id);
            if (path.getDepth() > 2 && this.validateNode(path)) {
                return this.isPathAutorized(path);
            }
            if (this.validateFileNode(id)) {
                Set<SilverpeasUserPrincipal> principals = this.subject.getPrincipals(SilverpeasUserPrincipal.class);
                for (SilverpeasUserPrincipal principal : principals) {
                    if (!principal.isAdministrator() && !this.checkUserIsOwner(principal, id)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUserIsOwner(SilverpeasUserPrincipal principal, ItemId id) throws RepositoryException {
        boolean bl;
        Session session;
        block5: {
            session = null;
            session = this.repository.login((Credentials)new SilverpeasSystemCredentials());
            Node node = this.getNode(session, id);
            if (!node.hasProperty("slv:owner")) break block5;
            boolean bl2 = principal.getUserId().equals(node.getProperty("slv:owner").getString());
            BasicDaoFactory.logout(session);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (ItemNotFoundException ex) {
            boolean bl3;
            try {
                bl3 = true;
            }
            catch (Throwable throwable) {
                BasicDaoFactory.logout(session);
                throw throwable;
            }
            BasicDaoFactory.logout(session);
            return bl3;
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUserIsOwner(SilverpeasUserPrincipal principal, Path path) throws RepositoryException {
        boolean bl;
        Session session = null;
        try {
            session = this.repository.login((Credentials)new SilverpeasSystemCredentials());
            Node node = this.getNode(session, path);
            bl = principal.getUserId().equals(node.getProperty("slv:owner").getString());
        }
        catch (ItemNotFoundException ex) {
            boolean bl2;
            try {
                bl2 = true;
            }
            catch (Throwable throwable) {
                BasicDaoFactory.logout(session);
                throw throwable;
            }
            BasicDaoFactory.logout(session);
            return bl2;
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    protected boolean isPathAutorized(Path path) {
        Set<SilverpeasUserPrincipal> principals = this.subject.getPrincipals(SilverpeasUserPrincipal.class);
        Path.Element[] elements = path.getElements();
        for (SilverpeasUserPrincipal principal : principals) {
            for (Path.Element element : elements) {
                if (!principal.isAdministrator() && principal.getUserProfile(element.getName().getLocalName()) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateFileNode(ItemId id) throws RepositoryException {
        boolean bl;
        Session session = null;
        try {
            session = this.repository.login((Credentials)new SilverpeasSystemCredentials());
            Node node = this.getNode(session, id);
            bl = this.validateFileNode(node);
        }
        catch (Throwable throwable) {
            BasicDaoFactory.logout(session);
            throw throwable;
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateNode(Path path) throws RepositoryException {
        boolean bl;
        Session session = null;
        try {
            session = this.repository.login((Credentials)new SilverpeasSystemCredentials());
            Node node = this.getNode(session, path);
            bl = this.validateNode(node);
        }
        catch (Throwable throwable) {
            BasicDaoFactory.logout(session);
            throw throwable;
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    protected boolean validateNode(Node node) throws RepositoryException {
        return node.getPrimaryNodeType().isNodeType("nt:folder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateFileNode(Path path) throws RepositoryException {
        boolean bl;
        Session session = null;
        try {
            session = this.repository.login((Credentials)new SilverpeasSystemCredentials());
            Node node = this.getNode(session, path);
            bl = this.validateFileNode(node);
        }
        catch (RepositoryException rex) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                BasicDaoFactory.logout(session);
                throw throwable;
            }
            BasicDaoFactory.logout(session);
            return bl2;
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    protected boolean validateFileNode(Node node) throws RepositoryException {
        if ("nt:file".equals(node.getPrimaryNodeType().getName())) {
            NodeType[] mixins;
            for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
                if (!"slv:ownable".equals(mixin.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.manager = context.getHierarchyManager();
        this.resolver = context.getNamePathResolver();
        this.privilegeManager = context.getPrivilegeManager();
        this.wspAccessMgr = wspAccessManager;
        this.subject = context.getSubject();
        this.isSystem = !this.subject.getPrincipals(SilverpeasSystemPrincipal.class).isEmpty();
        this.initialized = true;
    }

    public void checkPermission(Path absPath, int permissions) throws RepositoryException {
        if (!this.isGranted(absPath, permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    public boolean isGranted(Path path, int permissions) throws RepositoryException {
        if (!this.isSystem && this.denotesNode(path)) {
            if (path.getDepth() > 2 && this.validateNode(path)) {
                return this.isPathAutorized(path);
            }
            if (this.validateFileNode(path)) {
                Set<SilverpeasUserPrincipal> principals = this.subject.getPrincipals(SilverpeasUserPrincipal.class);
                for (SilverpeasUserPrincipal principal : principals) {
                    if (!principal.isAdministrator() && !this.checkUserIsOwner(principal, path)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean denotesNode(Path path) throws NamespaceException {
        boolean bl;
        Session session;
        block7: {
            Node root;
            String relativePath;
            block6: {
                relativePath = this.getRelativePath(path);
                session = null;
                session = this.repository.login((Credentials)new SilverpeasSystemCredentials());
                root = session.getRootNode();
                if (!path.denotesRoot()) break block6;
                boolean bl2 = true;
                BasicDaoFactory.logout(session);
                return bl2;
            }
            if (!root.hasNode(relativePath)) break block7;
            boolean bl3 = true;
            BasicDaoFactory.logout(session);
            return bl3;
        }
        try {
            bl = false;
        }
        catch (RepositoryException ex) {
            boolean bl4;
            try {
                bl4 = false;
            }
            catch (Throwable throwable) {
                BasicDaoFactory.logout(session);
                throw throwable;
            }
            BasicDaoFactory.logout(session);
            return bl4;
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    protected Node getNode(Session session, Path path) throws RepositoryException {
        String relativePath = this.getRelativePath(path);
        Node root = session.getRootNode();
        if (path.denotesRoot()) {
            return root;
        }
        if (root.hasNode(relativePath)) {
            return root.getNode(relativePath);
        }
        return null;
    }

    protected Node getNode(Session session, ItemId id) throws RepositoryException {
        return session.getNodeByIdentifier(id.toString());
    }

    protected String getRelativePath(Path path) throws NamespaceException {
        String result = this.resolver.getJCRPath(path);
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public boolean isGranted(Path path, Name name, int permission) throws RepositoryException {
        boolean canAccessPath = true;
        if (path != null) {
            canAccessPath = this.isGranted(path, permission);
        }
        return canAccessPath;
    }

    public boolean canRead(Path path, ItemId itemid) throws RepositoryException {
        boolean canAccessPath = true;
        if (path != null) {
            canAccessPath = this.isGranted(path, 1);
        }
        return canAccessPath && this.isGranted(itemid, 1);
    }

    public void checkRepositoryPermission(int permissions) throws RepositoryException {
    }
}

