/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.jaas;

import com.silverpeas.jcrutil.security.impl.DigestCredentials;
import com.silverpeas.jcrutil.security.impl.SilverpeasCredentials;
import com.silverpeas.jcrutil.security.impl.SilverpeasSystemCredentials;
import com.silverpeas.jcrutil.security.impl.SilverpeasSystemPrincipal;
import com.stratelia.webactiv.beans.admin.Admin;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.jaas.SilverpeasUserPrincipal;
import com.stratelia.webactiv.jaas.SilverpeasUserProfileEntry;
import com.stratelia.webactiv.util.exception.WithNested;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.AuthenticationService;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.util.crypto.CryptMD5;

public class SilverpeasLoginModule
implements LoginModule {
    private String userId;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Set<Principal> principals = new HashSet<Principal>();
    private AuthenticationService authenticator;
    private OrganisationController controller;
    private Admin administrator;

    public String getUserId() {
        return this.userId;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setAuthenticator(AuthenticationService authenticator) {
        this.authenticator = authenticator;
    }

    public void setController(OrganisationController controller) {
        this.controller = controller;
    }

    public void setAdministrator(Admin administrator) {
        this.administrator = administrator;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.logout();
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("no CallbackHandler available");
        }
        boolean authenticated = false;
        this.principals.clear();
        try {
            CredentialsCallback ccb = new CredentialsCallback();
            this.callbackHandler.handle(new Callback[]{ccb});
            Credentials creds = ccb.getCredentials();
            if (creds != null) {
                if (creds instanceof SimpleCredentials) {
                    SimpleCredentials sc = (SimpleCredentials)creds;
                    List<String> domains = this.administrator.getAllDomainIdsForLogin(sc.getUserID());
                    for (String domainId : domains) {
                        AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin(sc.getUserID()).withAsPassword(new String(sc.getPassword())).withAsDomainId(domainId);
                        String key = this.authenticator.authenticate(credential);
                        if (key == null || key.startsWith("Error_")) continue;
                        this.userId = this.administrator.identify(key, null, false);
                        SilverpeasUserPrincipal principal = new SilverpeasUserPrincipal(this.userId, this.isRoot(this.userId));
                        this.fillPrincipal(principal);
                        this.principals.add(principal);
                    }
                    if (this.principals.isEmpty() && UserDetail.isAnonymousUser(sc.getUserID())) {
                        this.principals.add((Principal)new AnonymousPrincipal());
                    }
                    authenticated = true;
                } else if (creds instanceof SilverpeasCredentials) {
                    String theUserId = ((SilverpeasCredentials)creds).getUserId();
                    SilverpeasUserPrincipal principal = new SilverpeasUserPrincipal(theUserId, this.isRoot(theUserId));
                    this.fillPrincipal(principal);
                    this.principals.add(principal);
                    authenticated = true;
                } else if (creds instanceof SilverpeasSystemCredentials) {
                    SilverpeasSystemPrincipal principal = new SilverpeasSystemPrincipal();
                    this.principals.add(principal);
                    authenticated = true;
                } else if (creds instanceof DigestCredentials) {
                    DigestCredentials sc = (DigestCredentials)creds;
                    List<String> domains = this.administrator.getAllDomainIdsForLogin(sc.getUsername());
                    for (String domainId : domains) {
                        AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin(sc.getUsername()).withAsDomainId(domainId);
                        String key = this.authenticator.authenticate(credential);
                        if (key == null || key.startsWith("Error_")) continue;
                        this.userId = this.administrator.identify(key, null, false);
                        SilverpeasUserPrincipal principal = new SilverpeasUserPrincipal(this.userId, this.isRoot(this.userId));
                        this.validateDigestUser(principal, sc);
                        this.fillPrincipal(principal);
                        this.principals.add(principal);
                    }
                    if (this.principals.isEmpty() && UserDetail.isAnonymousUser(sc.getUsername())) {
                        this.principals.add((Principal)new AnonymousPrincipal());
                    }
                    authenticated = true;
                }
            } else {
                this.principals.add((Principal)new AnonymousPrincipal());
                authenticated = true;
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getCallback().toString() + " not available");
        }
        catch (AdminException e) {
            StringBuilder message = new StringBuilder();
            Throwable ex = e;
            for (int i = 0; ex != null && i < 10; ++i) {
                message.append(" - ").append(ex.getMessage());
                if (ex instanceof WithNested) {
                    ex = ((WithNested)((Object)ex)).getNested();
                    continue;
                }
                ex = null;
            }
            throw new LoginException(message.toString());
        }
        if (authenticated) {
            return !this.principals.isEmpty();
        }
        this.principals.clear();
        throw new FailedLoginException();
    }

    private boolean isRoot(String userId) {
        boolean isAdmin = false;
        try {
            UserDetail currentUser = this.administrator.getUserDetail(userId);
            if (currentUser != null) {
                isAdmin = currentUser.isAccessAdmin();
            }
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        return isAdmin;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }

    protected void fillPrincipal(SilverpeasUserPrincipal principal) {
        String[] componentIds;
        for (String componentId : componentIds = this.controller.getAllowedComponentIds(principal.getUserId())) {
            String[] profiles;
            for (String profile : profiles = this.controller.getUserProfiles(principal.getUserId(), componentId)) {
                principal.addUserProfile(new SilverpeasUserProfileEntry(componentId, profile));
            }
        }
    }

    public boolean validateDigestUser(SilverpeasUserPrincipal principal, DigestCredentials sc) throws AdminException {
        UserFull user = AdminReference.getAdminService().getUserFull(this.userId);
        String md5a1 = CryptMD5.encrypt(user.getPassword());
        String serverDigestValue = md5a1 + ":" + sc.getNonce() + ":" + sc.getNc() + ":" + sc.getCnonce() + ":" + sc.getQop() + ":" + sc.getMd5a2();
        String serverDigest = CryptMD5.encrypt(serverDigestValue);
        return serverDigest.equals(sc.getClientDigest());
    }
}

