/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.ComponentInstanceRow;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.organization.UserRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserRoleTable
extends Table<UserRoleRow> {
    private static final String USERROLE_COLUMNS = "id,instanceId,name,roleName,description,isInherited,objectId";
    private static final String SELECT_USERROLE_BY_ID = "select id,instanceId,name,roleName,description,isInherited,objectId from ST_UserRole where id = ?";
    private static final String SELECT_USERROLE_BY_ROLENAME = "select id,instanceId,name,roleName,description,isInherited,objectId from ST_UserRole where instanceId = ? and isInherited = ? and rolename = ? and objectId is null";
    private static final String SELECT_ALL_INSTANCE_USERROLES = "select id,instanceId,name,roleName,description,isInherited,objectId from ST_UserRole where instanceId = ? ";
    private static final String SELECT_ALL_INSTANCE_USERROLE_IDS = "select id from ST_UserRole where instanceId = ? and objectId is null";
    private static final String SELECT_ALL_INSTANCE_OBJECT_USERROLE_IDS = "select id from ST_UserRole where instanceId = ? and objectId is not null";
    private static final String SELECT_ALL_OBJECT_USERROLE_IDS = "select id from ST_UserRole where instanceId = ? and objectId = ? and objectType = ? ";
    private static final String SELECT_USER_USERROLES = "select id,instanceId,name,roleName,description,isInherited,objectId from ST_UserRole, ST_UserRole_User_Rel where id = userRoleId and userId = ? ";
    private static final String SELECT_GROUP_USERROLES = "select id,instanceId,name,roleName,description,isInherited,objectId from ST_UserRole, ST_UserRole_Group_Rel where id = userRoleId and groupId = ? ";
    private static final String INSERT_USERROLE = "insert into ST_UserRole(id,instanceId,name,roleName,description,isInherited,objectId,objectType) values     (? ,?         ,?   ,?       ,?\t\t\t ,?\t\t\t ,?\t\t  ,?)";
    private static final String UPDATE_USERROLE = "update ST_UserRole set name = ?, description = ? where id = ?";
    private static final String DELETE_USERROLE = "delete from ST_UserRole where id = ?";
    private static final String SELECT_COUNT_USERROLE_USER_REL = "select count(*) from ST_UserRole_User_Rel where userId = ? and userRoleId = ?";
    private static final String INSERT_A_USERROLE_USER_REL = "insert into ST_UserRole_User_Rel(userRoleId, userId) values(?,?)";
    private static final String DELETE_USERROLE_USER_REL = "delete from ST_UserRole_User_Rel where userRoleId = ? and userId = ?";
    private static final String DELETE_ALL_USERS_FROM_USERROLE = "delete from ST_UserRole_User_Rel where userRoleId = ? ";
    private static final String DELETE_ALL_GROUPS_FROM_USERROLE = "delete from ST_UserRole_Group_Rel where userRoleId = ? ";
    private static final String SELECT_COUNT_USERROLE_GROUP_REL = "select count(*) from ST_UserRole_Group_Rel where groupId = ? and userRoleId = ?";
    private static final String INSERT_A_USERROLE_GROUP_REL = "insert into ST_UserRole_Group_Rel(userRoleId, groupId) values(?,?)";
    private static final String DELETE_USERROLE_GROUP_REL = "delete from ST_UserRole_Group_Rel where userRoleId = ? and groupId = ?";
    private OrganizationSchema organization = null;

    public UserRoleTable(OrganizationSchema organization) {
        super(organization, "ST_UserRole");
        this.organization = organization;
    }

    protected UserRoleRow fetchUserRole(ResultSet rs) throws SQLException {
        UserRoleRow ur = new UserRoleRow();
        ur.id = rs.getInt(1);
        ur.instanceId = rs.getInt(2);
        ur.name = rs.getString(3);
        ur.roleName = rs.getString(4);
        ur.description = rs.getString(5);
        ur.isInherited = rs.getInt(6);
        ur.objectId = rs.getInt(7);
        return ur;
    }

    public UserRoleRow getUserRole(int id) throws AdminPersistenceException {
        return (UserRoleRow)this.getUniqueRow(SELECT_USERROLE_BY_ID, id);
    }

    public UserRoleRow getUserRole(int instanceId, String roleName, int inherited) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(instanceId);
        params.add(inherited);
        params.add(roleName);
        List userRoles = this.getRows(SELECT_USERROLE_BY_ROLENAME, params);
        if (userRoles.isEmpty()) {
            return null;
        }
        if (userRoles.size() >= 2) {
            SilverTrace.error("admin", "UserRoleTable.getUserRole", "root.MSG_GEN_PARAM_VALUE", "# = " + userRoles.size() + ", instanceId = " + instanceId + ", roleName = " + roleName);
        }
        return (UserRoleRow)userRoles.get(0);
    }

    public UserRoleRow[] getAllUserRolesOfInstance(int instanceId) throws AdminPersistenceException {
        List<UserRoleRow> rows = this.getRows(SELECT_ALL_INSTANCE_USERROLES, instanceId);
        return rows.toArray(new UserRoleRow[rows.size()]);
    }

    public String[] getAllUserRoleIdsOfInstance(int instanceId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_INSTANCE_USERROLE_IDS, instanceId);
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getAllObjectUserRoleIdsOfInstance(int instanceId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_INSTANCE_OBJECT_USERROLE_IDS, instanceId);
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getAllUserRoleIdsOfObject(int objectId, String objectType, int instanceId) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(instanceId);
        params.add(objectId);
        params.add(objectType);
        List<String> ids = this.getIds(SELECT_ALL_OBJECT_USERROLE_IDS, params);
        return ids.toArray(new String[ids.size()]);
    }

    public UserRoleRow[] getDirectUserRolesOfUser(int userId) throws AdminPersistenceException {
        List<UserRoleRow> rows = this.getRows(SELECT_USER_USERROLES, userId);
        return rows.toArray(new UserRoleRow[rows.size()]);
    }

    public UserRoleRow[] getDirectUserRolesOfGroup(int groupId) throws AdminPersistenceException {
        List<UserRoleRow> rows = this.getRows(SELECT_GROUP_USERROLES, groupId);
        return rows.toArray(new UserRoleRow[rows.size()]);
    }

    public void createUserRole(UserRoleRow userRole) throws AdminPersistenceException {
        ComponentInstanceRow instance = this.organization.instance.getComponentInstance(userRole.instanceId);
        if (instance == null) {
            throw new AdminPersistenceException("UserRoleTable.createUserRole", 4, "admin.EX_ERR_INSTANCE_NOT_FOUND", "instance id : '" + userRole.instanceId + "'");
        }
        if (userRole.objectId != -1 && !StringUtil.isDefined(userRole.objectType)) {
            throw new AdminPersistenceException("UserRoleTable.createUserRole", 4, "admin.EX_ERR_OBJECT_TYPE_NOT_SPECIFIED", "objectId = " + userRole.objectId);
        }
        this.insertRow(INSERT_USERROLE, userRole);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, UserRoleRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setInt(2, row.instanceId);
        insert.setString(3, UserRoleTable.truncate(row.name, 100));
        insert.setString(4, UserRoleTable.truncate(row.roleName, 100));
        insert.setString(5, UserRoleTable.truncate(row.description, 500));
        insert.setInt(6, row.isInherited);
        if (row.objectId == -1) {
            insert.setNull(7, 4);
        } else {
            insert.setInt(7, row.objectId);
        }
        if (!StringUtil.isDefined(row.objectType)) {
            insert.setNull(8, 12);
        } else {
            insert.setString(8, row.objectType);
        }
    }

    public void updateUserRole(UserRoleRow userRole) throws AdminPersistenceException {
        this.updateRow(UPDATE_USERROLE, userRole);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, UserRoleRow row) throws SQLException {
        update.setString(1, UserRoleTable.truncate(row.name, 100));
        update.setString(2, UserRoleTable.truncate(row.description, 500));
        update.setInt(3, row.id);
    }

    public void removeUserRole(int id) throws AdminPersistenceException {
        UserRoleRow userRole = this.getUserRole(id);
        if (userRole == null) {
            return;
        }
        this.removeAllGroupsFromUserRole(id);
        this.removeAllUsersFromUserRole(id);
        this.updateRelation(DELETE_USERROLE, id);
    }

    public boolean isUserDirectlyInRole(int userId, int userRoleId) throws AdminPersistenceException {
        int[] ids = new int[]{userId, userRoleId};
        Integer result = this.getInteger(SELECT_COUNT_USERROLE_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInUserRole(int userId, int userRoleId) throws AdminPersistenceException {
        if (this.isUserDirectlyInRole(userId, userRoleId)) {
            return;
        }
        UserRow user = this.organization.user.getUser(userId);
        if (user == null) {
            throw new AdminPersistenceException("UserRoleTable.addUserInUserRole", 4, "admin.EX_ERR_USER_NOT_FOUND", "user id : '" + userId + "'");
        }
        UserRoleRow userRole = this.getUserRole(userRoleId);
        if (userRole == null) {
            throw new AdminPersistenceException("UserRoleTable.addUserInUserRole", 4, "admin.EX_ERR_USERROLE_NOT_FOUND", "user role id : '" + userRoleId + "'");
        }
        int[] params = new int[]{userRoleId, userId};
        this.updateRelation(INSERT_A_USERROLE_USER_REL, params);
    }

    public void removeUserFromUserRole(int userId, int userRoleId) throws AdminPersistenceException {
        if (!this.isUserDirectlyInRole(userId, userRoleId)) {
            throw new AdminPersistenceException("UserRoleTable.removeUserFromUserRole", 4, "admin.EX_ERR_USER_NOT_IN_USERROLE", "userrole id: '" + userRoleId + "', user id: '" + userId + "'");
        }
        int[] params = new int[]{userRoleId, userId};
        SynchroReport.debug("UserRoleTable.removeUserFromUserRole()", "Retrait de l'utilisateur d'ID " + userId + " du role d'ID " + userRoleId + ", requ\u00eate : " + DELETE_USERROLE_USER_REL, null);
        this.updateRelation(DELETE_USERROLE_USER_REL, params);
    }

    public void removeAllUsersFromUserRole(int userRoleId) throws AdminPersistenceException {
        SynchroReport.debug("UserRoleTable.removeAllUsersFromUserRole()", "Retrait des utilisateurs du role d'ID " + userRoleId + ", requ\u00eate : " + DELETE_USERROLE_USER_REL, null);
        this.updateRelation(DELETE_ALL_USERS_FROM_USERROLE, userRoleId);
    }

    public void removeAllGroupsFromUserRole(int userRoleId) throws AdminPersistenceException {
        SynchroReport.debug("UserRoleTable.removeAllGroupsFromUserRole()", "Retrait des groupes du role d'ID " + userRoleId + ", requ\u00eate : " + DELETE_USERROLE_USER_REL, null);
        this.updateRelation(DELETE_ALL_GROUPS_FROM_USERROLE, userRoleId);
    }

    public boolean isGroupDirectlyInRole(int groupId, int userRoleId) throws AdminPersistenceException {
        int[] ids = new int[]{groupId, userRoleId};
        Integer result = this.getInteger(SELECT_COUNT_USERROLE_GROUP_REL, ids);
        SilverTrace.debug("admin", "UserRoleTable.isGroupDirectlyInRole()", "Le groupe d'ID " + groupId + " et le role d'ID " + userRoleId + " ont un nb de lien = " + result);
        return result != null && result >= 1;
    }

    public void addGroupInUserRole(int groupId, int userRoleId) throws AdminPersistenceException {
        if (this.isGroupDirectlyInRole(groupId, userRoleId)) {
            return;
        }
        GroupRow group = this.organization.group.getGroup(groupId);
        if (group == null) {
            throw new AdminPersistenceException("UserRoleTable.addGroupInUserRole", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id : '" + groupId + "'");
        }
        UserRoleRow userRole = this.getUserRole(userRoleId);
        if (userRole == null) {
            throw new AdminPersistenceException("UserRoleTable.addGroupInUserRole", 4, "admin.EX_ERR_USERROLE_NOT_FOUND", "user role id : '" + userRoleId + "'");
        }
        int[] params = new int[]{userRoleId, groupId};
        this.updateRelation(INSERT_A_USERROLE_GROUP_REL, params);
    }

    public void removeGroupFromUserRole(int groupId, int userRoleId) throws AdminPersistenceException {
        if (!this.isGroupDirectlyInRole(groupId, userRoleId)) {
            throw new AdminPersistenceException("UserRoleTable.removeGroupFromUserRole", 4, "admin.EX_ERR_GROUP_NOT_IN_USERROLE", "userrole id: '" + userRoleId + "', group id: '" + groupId + "'");
        }
        int[] params = new int[]{userRoleId, groupId};
        SynchroReport.debug("UserRoleTable.removeGroupFromUserRole()", "Retrait du groupe d'ID " + groupId + " du role d'ID " + userRoleId + ", requ\u00eate : " + DELETE_USERROLE_GROUP_REL, null);
        this.updateRelation(DELETE_USERROLE_GROUP_REL, params);
    }

    @Override
    protected UserRoleRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchUserRole(rs);
    }
}

