/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractTable<T> {
    protected Schema schema = null;
    private String tableName = null;

    public AbstractTable(Schema schema, String tableName) {
        this.schema = schema;
        this.tableName = tableName;
    }

    public static String aliasColumns(String rowAlias, String columnList) {
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(columnList, ",");
        String separator = "";
        while (st.hasMoreTokens()) {
            String column = st.nextToken();
            result.append(separator);
            result.append(rowAlias);
            result.append(".");
            result.append(column);
            separator = ",";
        }
        return result.toString();
    }

    public static String truncate(String value, int maxSize) {
        if (value != null && value.length() > maxSize) {
            return value.substring(0, maxSize - 1);
        }
        return value;
    }

    public int getNextId() throws SQLException {
        int nextId;
        try {
            nextId = DBUtil.getNextId(this.tableName, "id");
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        if (nextId == 0) {
            return 1;
        }
        return nextId;
    }

    protected abstract T fetchRow(ResultSet var1) throws SQLException;

    protected abstract void prepareInsert(String var1, PreparedStatement var2, T var3) throws SQLException;

    protected abstract void prepareUpdate(String var1, PreparedStatement var2, T var3) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getUniqueRow(String query, int id) throws UtilException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                select.setInt(1, id);
                rs = select.executeQuery();
                t = this.getUniqueRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getUniqueRow", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getUniqueRow(String query, String parameter) throws UtilException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                select.setString(1, parameter);
                rs = select.executeQuery();
                t = this.getUniqueRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getUniqueRow", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getUniqueRow(String query, int[] ids) throws UtilException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                for (int i = 0; i < ids.length; ++i) {
                    select.setInt(i + 1, ids[i]);
                }
                rs = select.executeQuery();
                t = this.getUniqueRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getUniqueRow", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getUniqueRow(String query, String[] params) throws UtilException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                for (int i = 0; i < params.length; ++i) {
                    select.setString(i + 1, params[i]);
                }
                rs = select.executeQuery();
                t = this.getUniqueRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getUniqueRow", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getUniqueRow(String query, int[] ids, String[] params) throws UtilException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                int i;
                for (i = 0; i < ids.length; ++i) {
                    select.setInt(i + 1, ids[i]);
                }
                for (int j = 0; j < params.length; ++j) {
                    select.setString(i + j + 1, params[j]);
                }
                rs = select.executeQuery();
                t = this.getUniqueRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getUniqueRow", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getUniqueRow(String query) throws UtilException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                rs = select.executeQuery();
                t = this.getUniqueRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getUniqueRow", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<T> getRows(String query) throws UtilException {
        ArrayList<T> arrayList;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                rs = select.executeQuery();
                arrayList = this.getRows(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getRows", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<T> getRows(String query, int id) throws UtilException {
        ArrayList<T> arrayList;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                select.setInt(1, id);
                rs = select.executeQuery();
                arrayList = this.getRows(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getRows", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<T> getRows(String query, String parameter) throws UtilException {
        ArrayList<T> arrayList;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                select.setString(1, parameter);
                rs = select.executeQuery();
                arrayList = this.getRows(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getRows", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<T> getRows(String query, int[] ids) throws UtilException {
        ArrayList<T> arrayList;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                for (int i = 0; i < ids.length; ++i) {
                    select.setInt(i + 1, ids[i]);
                }
                rs = select.executeQuery();
                arrayList = this.getRows(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getRows", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<T> getRows(String query, String[] params) throws UtilException {
        ArrayList<T> arrayList;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                for (int i = 0; i < params.length; ++i) {
                    select.setString(i + 1, params[i]);
                }
                rs = select.executeQuery();
                arrayList = this.getRows(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getRows", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<T> getRows(String query, int[] ids, String[] params) throws UtilException {
        ArrayList<T> arrayList;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                int i;
                for (i = 0; i < ids.length; ++i) {
                    select.setInt(i + 1, ids[i]);
                }
                for (int j = 0; j < params.length; ++j) {
                    select.setString(i + j + 1, params[j]);
                }
                rs = select.executeQuery();
                arrayList = this.getRows(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getRows", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    protected List<T> getMatchingRows(String returnedColumns, String[] matchColumns, String[] matchValues) throws UtilException {
        String query = "select " + returnedColumns + " from " + this.tableName;
        ArrayList<String> notNullValues = new ArrayList<String>();
        String sep = " where ";
        for (int i = 0; i < matchColumns.length; ++i) {
            if (matchValues[i] == null) continue;
            query = query + sep + matchColumns[i] + " like ?";
            sep = " , ";
            notNullValues.add(matchValues[i]);
        }
        return this.getRows(query, notNullValues.toArray(new String[notNullValues.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer getInteger(String query, int[] ids) throws UtilException {
        Integer n;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            PreparedStatement preparedStatement = select = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                for (int i = 0; i < ids.length; ++i) {
                    select.setInt(i + 1, ids[i]);
                }
                rs = select.executeQuery();
                n = this.getInteger(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new UtilException("AbstractTable.getInteger", "Select failed", e);
            }
        }
        DBUtil.close(rs, select);
        return n;
    }

    protected T getUniqueRow(ResultSet rs) throws SQLException, UtilException {
        if (!rs.next()) {
            return null;
        }
        T result = this.fetchRow(rs);
        if (rs.next()) {
            throw new UtilException("AbstractTable.getUniqueRow", "Not unique row !");
        }
        return result;
    }

    protected ArrayList<T> getRows(ResultSet rs) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            result.add(this.fetchRow(rs));
        }
        return result;
    }

    protected Integer getInteger(ResultSet rs) throws SQLException, UtilException {
        if (!rs.next()) {
            return null;
        }
        int result = rs.getInt(1);
        if (rs.next()) {
            throw new UtilException("AbstractTable.getInteger", "Not unique row !");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertRow(String insertQuery, T row) throws UtilException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            PreparedStatement preparedStatement = statement = this.schema.getStatement(insertQuery);
            synchronized (preparedStatement) {
                this.prepareInsert(insertQuery, statement, row);
                rowsCount = statement.executeUpdate();
            }
            n = rowsCount;
        }
        catch (SQLException e) {
            try {
                throw new UtilException("AbstractTable.insertRow", "Creation failed", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateRow(String updateQuery, T row) throws UtilException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            PreparedStatement preparedStatement = statement = this.schema.getStatement(updateQuery);
            synchronized (preparedStatement) {
                this.prepareUpdate(updateQuery, statement, row);
                rowsCount = statement.executeUpdate();
            }
            n = rowsCount;
        }
        catch (SQLException e) {
            try {
                throw new UtilException("AbstractTable.updateRow", "Update failed", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateRelation(String query, int param) throws UtilException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            PreparedStatement preparedStatement = statement = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                if (param == -1) {
                    statement.setNull(1, 4);
                } else {
                    statement.setInt(1, param);
                }
                rowsCount = statement.executeUpdate();
            }
            n = rowsCount;
        }
        catch (SQLException e) {
            try {
                throw new UtilException("AbstractTable.updateRelation", "Update failed", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateRelation(String query, int[] param) throws UtilException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            PreparedStatement preparedStatement = statement = this.schema.getStatement(query);
            synchronized (preparedStatement) {
                for (int i = 0; i < param.length; ++i) {
                    if (param[i] == -1) {
                        statement.setNull(i + 1, 4);
                        continue;
                    }
                    statement.setInt(i + 1, param[i]);
                }
                rowsCount = statement.executeUpdate();
            }
            n = rowsCount;
        }
        catch (SQLException e) {
            try {
                throw new UtilException("AbstractTable.updateRelation", "Update failed", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }
}

